/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.andes.util.Strings;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.identity.application.common.model.xsd.Claim;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimConfig;
import org.wso2.carbon.identity.application.common.model.xsd.ClaimMapping;
import org.wso2.carbon.identity.application.common.model.xsd.ServiceProvider;
import org.wso2.carbon.identity.application.mgt.stub.IdentityApplicationManagementServiceIdentityApplicationManagementException;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceClaimMetadataException;
import org.wso2.carbon.identity.oauth.stub.OAuthAdminServiceIdentityOAuthAdminException;
import org.wso2.carbon.identity.oauth.stub.dto.OAuthConsumerAppDTO;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.RemoteUserStoreManagerServiceUserStoreExceptionException;
import org.wso2.carbon.user.core.UserStoreException;

public class JWTTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(JWTTestCase.class);
    private final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";
    private final String DEFAULT_PROFILE = "default";
    private String apiName = "JWTUserClaimAPI";
    private String apiContext = "jwtTest";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String oauthApplicationName = "OauthAppForJWTTest";
    private String jwtApplicationName = "JWTAppFOrJWTTest";
    private String endpointURL;
    String[] users = new String[]{"subscriberUser2", "subscriberUser2@wso2.com", "subscriberUser2@abc.com"};
    String enduserPassword = "password@123";
    private String oauthApplicationId;
    private String jwtApplicationId;
    private String apiId;
    URL tokenEndpointURL;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        this.providerName = this.user.getUserName();
        this.endpointURL = this.getSuperTenantAPIInvocationURLHttp("jwt_backend", "1.0");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationDTO = this.restAPIStore.createApplication(this.oauthApplicationName, "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.oauthApplicationId = applicationDTO.getData();
        applicationDTO = this.restAPIStore.createApplication(this.jwtApplicationName, "JWT Application", "50PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.jwtApplicationId = applicationDTO.getData();
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(this.endpointURL));
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setVisibility("public");
        apiRequest.setProvider(this.providerName);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.restAPIStore.subscribeToAPI(this.apiId, this.oauthApplicationId, "Gold");
        this.restAPIStore.subscribeToAPI(this.apiId, this.jwtApplicationId, "Gold");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        this.restAPIStore.generateKeys(this.oauthApplicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.restAPIStore.generateKeys(this.jwtApplicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.createUser();
        this.createClaimMapping();
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for Oauth Based App")
    public void testEnableJWTAndClaimsForOauthApp() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.oauthApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        for (String endUser : this.users) {
            String accessToken = this.generateUserToken(applicationKeyDTO.getConsumerKey(), applicationKeyDTO.getConsumerSecret(), endUser, this.enduserPassword, this.user, new String[]{"default"});
            log.info((Object)("Access Token Generated in oauth ==" + accessToken));
            String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
            get.addHeader("Authorization", "Bearer " + tokenJti);
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
            Header[] responseHeaders = response.getAllHeaders();
            Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
            log.debug((Object)("Decoded JWTString = " + decodedJWTString));
            String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
            String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
            boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
            AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
            log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
            JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
            Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
            Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
            JSONObject jsonObject = new JSONObject(decodedJWTString);
            log.info((Object)("JWT Received ==" + jsonObject.toString()));
            this.checkDefaultUserClaims(jsonObject, this.oauthApplicationName);
            String claim = jsonObject.getString("http://wso2.org/claims/givenname");
            AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first name".concat(endUser)));
            claim = jsonObject.getString("http://wso2.org/claims/lastname");
            AssertJUnit.assertTrue((String)("JWT claim lastname  not received" + claim), (boolean)claim.contains("last name".concat(endUser)));
            claim = jsonObject.getString("http://wso2.org/claims/mobile");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("94123456987"));
            claim = jsonObject.getString("http://wso2.org/claims/organization");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("ABC".concat(endUser)));
            boolean bExceptionOccured = false;
            try {
                jsonObject.getString("http://wso2.org/claims/wrongclaim");
            }
            catch (JSONException e) {
                bExceptionOccured = true;
            }
            AssertJUnit.assertTrue((String)"JWT claim received is invalid", (boolean)bExceptionOccured);
        }
    }

    @Test(groups={"wso2.am"}, description="Backend JWT Token Generation for JWT Based App")
    public void testEnableJWTAndClaimsForJWTApp() throws Exception {
        ApiResponse applicationKeysByKeyType = this.restAPIStore.getApplicationKeysByKeyType(this.jwtApplicationId, ApplicationKeyDTO.KeyTypeEnum.PRODUCTION.getValue());
        ApplicationKeyDTO applicationKeyDTO = (ApplicationKeyDTO)applicationKeysByKeyType.getData();
        this.updateServiceProviderWithRequiredClaims(applicationKeyDTO.getConsumerKey());
        for (String endUser : this.users) {
            String accessToken = this.generateUserToken(applicationKeyDTO.getConsumerKey(), applicationKeyDTO.getConsumerSecret(), endUser, this.enduserPassword, this.user, new String[]{"openid"});
            log.info((Object)("Acess Token Generated in JWT ==" + accessToken));
            CloseableHttpClient httpclient = HttpClientBuilder.create().build();
            HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
            get.addHeader("Authorization", "Bearer " + accessToken);
            HttpResponse response = httpclient.execute((HttpUriRequest)get);
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
            Header[] responseHeaders = response.getAllHeaders();
            Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
            String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
            log.debug((Object)("Decoded JWTString = " + decodedJWTString));
            String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
            byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
            String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
            boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
            AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
            log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
            JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
            Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
            Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
            JSONObject jsonObject = new JSONObject(decodedJWTString);
            this.checkDefaultUserClaims(jsonObject, this.jwtApplicationName);
            log.info((Object)("JWT Received ==" + jsonObject.toString()));
            String claim = jsonObject.getString("http://wso2.org/claims/givenname");
            AssertJUnit.assertTrue((String)("JWT claim givenname  not received" + claim), (boolean)claim.contains("first name".concat(endUser)));
            claim = jsonObject.getString("http://wso2.org/claims/lastname");
            AssertJUnit.assertTrue((String)("JWT claim lastname  not received" + claim), (boolean)claim.contains("last name".concat(endUser)));
            claim = jsonObject.getString("mobile");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("94123456987"));
            claim = jsonObject.getString("organization");
            AssertJUnit.assertTrue((String)("JWT claim mobile  not received" + claim), (boolean)claim.contains("ABC".concat(endUser)));
            boolean bExceptionOccured = false;
            try {
                jsonObject.getString("http://wso2.org/claims/wrongclaim");
            }
            catch (JSONException e) {
                bExceptionOccured = true;
            }
            AssertJUnit.assertTrue((String)"JWT claim received is invalid", (boolean)bExceptionOccured);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        for (String user : this.users) {
            this.userManagementClient.deleteUser(user);
        }
        this.removeClaimMapping();
        super.cleanUp();
    }

    private void checkDefaultUserClaims(JSONObject jsonObject, String applicationName) throws JSONException {
        String claim = jsonObject.getString("iss");
        AssertJUnit.assertTrue((String)"JWT assertion is invalid", (boolean)claim.contains("wso2.org/products/am"));
        claim = jsonObject.getString("http://wso2.org/claims/subscriber");
        AssertJUnit.assertTrue((String)("JWT claim subscriber invalid. Received " + claim), (boolean)claim.contains(this.user.getUserName()));
        claim = jsonObject.getString("http://wso2.org/claims/applicationname");
        AssertJUnit.assertTrue((String)("JWT claim applicationname invalid. Received " + claim), (boolean)claim.contains(applicationName));
        claim = jsonObject.getString("http://wso2.org/claims/applicationtier");
        AssertJUnit.assertTrue((String)("JWT claim applicationtier invalid. Received " + claim), (boolean)claim.contains("50PerMin"));
        claim = jsonObject.getString("http://wso2.org/claims/keytype");
        AssertJUnit.assertTrue((String)("JWT claim keytype invalid. Received " + claim), (boolean)claim.contains("PRODUCTION"));
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public JWTTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    private void createUser() throws RemoteException, RemoteUserStoreManagerServiceUserStoreExceptionException, UserStoreException {
        for (String user : this.users) {
            this.remoteUserStoreManagerServiceClient.addUser(user, this.enduserPassword, new String[0], new ClaimValue[0], "default", false);
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/givenname", "first name".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/lastname", "last name".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/organization", "ABC".concat(user), "default");
            this.remoteUserStoreManagerServiceClient.setUserClaimValue(user, "http://wso2.org/claims/mobile", "94123456987", "default");
        }
    }

    private void createClaimMapping() throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException, OAuthAdminServiceIdentityOAuthAdminException {
        this.remoteClaimMetaDataMgtAdminClient.addExternalClaim("http://wso2.org/oidc/claim", "mobile", "http://wso2.org/claims/mobile");
        this.remoteClaimMetaDataMgtAdminClient.addExternalClaim("http://wso2.org/oidc/claim", "organization", "http://wso2.org/claims/organization");
        this.oAuthAdminServiceClient.updateScope("openid", new String[]{"mobile", "organization"}, new String[0]);
    }

    private void updateServiceProviderWithRequiredClaims(String consumerKey) throws OAuthAdminServiceIdentityOAuthAdminException, RemoteException, IdentityApplicationManagementServiceIdentityApplicationManagementException {
        String[] requestedClaims = new String[]{"http://wso2.org/claims/givenname", "http://wso2.org/claims/lastname", "http://wso2.org/claims/organization", "http://wso2.org/claims/mobile"};
        OAuthConsumerAppDTO oAuthApplicationData = this.oAuthAdminServiceClient.getOAuthApplicationData(consumerKey);
        String applicationName = oAuthApplicationData.getApplicationName();
        ServiceProvider application = this.applicationManagementClient.getApplication(applicationName);
        ClaimConfig claimConfig = new ClaimConfig();
        for (String claimUri : requestedClaims) {
            ClaimMapping claimMapping = new ClaimMapping();
            Claim claim = new Claim();
            claim.setClaimUri(claimUri);
            claimMapping.setLocalClaim(claim);
            claimMapping.setRemoteClaim(claim);
            claimMapping.setRequested(true);
            claimMapping.setMandatory(true);
            claimConfig.addClaimMappings(claimMapping);
        }
        application.setClaimConfig(claimConfig);
        this.applicationManagementClient.updateApplication(application);
    }

    private void removeClaimMapping() throws RemoteException, ClaimMetadataManagementServiceClaimMetadataException, OAuthAdminServiceIdentityOAuthAdminException {
        this.oAuthAdminServiceClient.updateScope("openid", new String[0], new String[]{"mobile", "organization"});
        this.remoteClaimMetaDataMgtAdminClient.removeExternalClaim("http://wso2.org/oidc/claim", "http://wso2.org/oidc/claim/mobile");
        this.remoteClaimMetaDataMgtAdminClient.removeExternalClaim("http://wso2.org/oidc/claim", "http://wso2.org/oidc/claim/organization");
    }

    private String generateUserToken(String consumerKey, String consumerSecret, String enduserName, String enduserPassword, User user, String[] scopes) throws APIManagerIntegrationTestException, JSONException {
        String username = enduserName.concat("@").concat(user.getUserDomain());
        String requestBody = "grant_type=password&username=" + username + "&password=" + enduserPassword + "&scope=" + Strings.join((String)" ", (Object[])scopes);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, this.tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(httpResponse.getData());
        return accessTokenGenerationResponse.getString("access_token");
    }
}

