/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIEndpointURLsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIURLsDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM720GetAllEndPointsTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM720GetAllEndPointsTestCase.class);
    private static final String apiName = "EndPointTestAPI";
    private static final String apiVersion = "1.0.0";
    private static final String apiContext = "endpointtestapi";
    private final String tags = "document";
    private String tier = "Unlimited";
    private String resTier = "Unlimited";
    private final String description = "testApi";
    private String apiProvider;
    private final String endPointType = "http";
    private String gatewayUrl;
    private String apiID;
    private APIIdentifier apiIdentifier;

    @Factory(dataProvider="userModeDataProvider")
    public APIM720GetAllEndPointsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        this.apiProvider = this.publisherContext.getContextTenant().getContextUser().getUserName();
        String uri = "customers/{id}/";
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.resTier, uri));
        String endpointProduction = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/production";
        String endpointSandbox = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice/sandbox";
        ArrayList<String> prodEndpointList = new ArrayList<String>();
        ArrayList<String> sandboxEndpointList = new ArrayList<String>();
        prodEndpointList.add(endpointProduction);
        sandboxEndpointList.add(endpointSandbox);
        for (int i = 0; i < 3; ++i) {
            prodEndpointList.add(endpointProduction + "_" + i);
            sandboxEndpointList.add(endpointSandbox + "_" + i);
        }
        APIRequest apiRequest = new APIRequest(apiName, apiContext, apiVersion, prodEndpointList, sandboxEndpointList);
        apiRequest.setEndpointType("http");
        apiRequest.setTags("document");
        apiRequest.setTier(this.tier);
        apiRequest.setDescription("testApi");
        apiRequest.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        this.apiIdentifier = new APIIdentifier(this.apiProvider, apiName, apiVersion);
        HttpResponse apiCreateResponse = this.restAPIPublisher.addAPI(apiRequest);
        Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Error when creating API: EndPointTestAPI");
        this.apiID = apiCreateResponse.getData();
        HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiID);
        Assert.assertEquals((int)getAPIResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error when retrieving API: EndPointTestAPI");
        HttpResponse changeLCStatusResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiID, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)changeLCStatusResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error when publishing the API: EndPointTestAPI");
        this.waitForAPIDeploymentSync(this.apiProvider, apiName, apiVersion, "\"isApiExists\":true");
        this.gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
    }

    @Test(description="Get All Endpoints")
    public void getAllEndpointUrlsTest() throws Exception {
        HttpResponse getAPIResponse = this.restAPIPublisher.getAPI(this.apiID);
        Assert.assertEquals((int)getAPIResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Error when retrieving API: EndPointTestAPI");
        Gson gson = new Gson();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO api = (org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO)gson.fromJson(getAPIResponse.getData(), org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO.class);
        LinkedTreeMap endpointConfig = (LinkedTreeMap)api.getEndpointConfig();
        ArrayList sandboxEndpoints = (ArrayList)endpointConfig.get((Object)"sandbox_endpoints");
        ArrayList productionEndpoints = (ArrayList)endpointConfig.get((Object)"production_endpoints");
        Assert.assertEquals((int)productionEndpoints.size(), (int)4, (String)"Mismatch in the number of production endpoints");
        Assert.assertEquals((int)sandboxEndpoints.size(), (int)4, (String)"Mismatch in the number of sandbox endpoints");
        Assert.assertEquals((Object)endpointConfig.get((Object)"endpoint_type"), (Object)"load_balance", (String)"Endpoint type mismatched");
        Assert.assertEquals((Object)endpointConfig.get((Object)"algoCombo"), (Object)"org.apache.synapse.endpoints.algorithms.RoundRobin", (String)"Endpoint selection algorithm mismatched");
        APIDTO apiFromStore = this.restAPIStore.getAPI(this.apiID);
        List endpointURLs = apiFromStore.getEndpointURLs();
        APIURLsDTO urls = ((APIEndpointURLsDTO)endpointURLs.get(0)).getUrLs();
        Assert.assertEquals((String)((APIEndpointURLsDTO)endpointURLs.get(0)).getEnvironmentName(), (String)"Production and Sandbox", (String)"Mismatch in environment name");
        Assert.assertEquals((String)((APIEndpointURLsDTO)endpointURLs.get(0)).getEnvironmentType(), (String)"hybrid", (String)"Mismatch in environment type");
        Assert.assertTrue((urls.getHttp() != null ? 1 : 0) != 0, (String)"HTTP URL is not available");
        Assert.assertTrue((urls.getHttps() != null ? 1 : 0) != 0, (String)"HTTPS URL is not available");
        Assert.assertEquals((String)urls.getHttp(), (String)(this.gatewayUrl + apiContext + "/" + apiVersion), (String)"Error in HTTP endpoint URL");
        Assert.assertEquals((String)urls.getHttps(), (String)(this.gatewayHTTPSURL + apiContext + "/" + apiVersion), (String)"Error in HTTPSendpoint URL");
        APIDTO apiResponse = this.restAPIStore.getAPI(this.apiID);
        Assert.assertNotNull((Object)apiResponse);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiID);
    }
}

