/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.tenant.mgt.stub.TenantMgtAdminServiceExceptionException;

public class APIMANAGER4081PaginationCountTestCase
extends APIMIntegrationBaseTest {
    private String tenantDomain = "paginationtest.com";
    private int numberOfAPIs = 5;
    private List<APIDTO> createdAPIs = new ArrayList<APIDTO>();

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() {
        try {
            super.init();
            this.tenantManagementServiceClient.addTenant(this.tenantDomain, this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), "demo");
        }
        catch (XPathExpressionException e) {
            Assert.fail((String)"Error occurred while retrieving context. Pagination count test case failed.");
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.fail((String)"Error occurred while adding tenant. Pagination count test case failed.");
        }
        catch (RemoteException e) {
            Assert.fail((String)"Error occurred while creating session. Pagination count test case failed.");
        }
        catch (TenantMgtAdminServiceExceptionException e) {
            Assert.fail((String)"Error while getting tenant management service. Pagination count test case failed.");
        }
    }

    @Test(groups={"wso2.am"}, description="Pagination test case")
    public void testPagination() throws Exception {
        try {
            for (int i = 0; i < this.numberOfAPIs; ++i) {
                String APIName = "PaginationTestAPI" + Integer.toString(i);
                String APIContext = "paginationTest" + Integer.toString(i);
                String tags = "pagination";
                String url = "https://localhost:9443/test";
                String description = "This is test API create by API manager integration test";
                String APIVersion = "1.0.0";
                String providerName = this.publisherContext.getContextTenant().getTenantAdmin().getUserName() + "@" + this.tenantDomain;
                this.waitForAPIDeployment();
                APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
                apiRequest.setTags(tags);
                apiRequest.setDescription(description);
                apiRequest.setVersion(APIVersion);
                apiRequest.setSandbox(url);
                apiRequest.setResourceMethod("GET");
                APIDTO createdAPI = this.restAPIPublisher.addAPI(apiRequest, "v2");
                this.createdAPIs.add(createdAPI);
                HttpResponse lifecycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatusToPublish(createdAPI.getId(), false);
                Assert.assertNotNull((Object)lifecycleChangeResponse, (String)("Failed to publish the API " + createdAPI.getName() + ":" + createdAPI.getVersion()));
            }
            boolean apisAvailableForTesting = false;
            for (int i = 0; i < 12; ++i) {
                if (this.restAPIPublisher.getAllAPIs().getCount() == this.numberOfAPIs && this.restAPIStore.getAllAPIs().getCount() == this.numberOfAPIs) {
                    apisAvailableForTesting = true;
                    break;
                }
                Thread.sleep(5000L);
            }
            if (!apisAvailableForTesting) {
                Assert.fail((String)(this.numberOfAPIs + " APIs are not visible properly Store or Publisher"));
            }
        }
        catch (XPathExpressionException e) {
            Assert.fail((String)"Error occurred when retrieving context to add APIs. Pagination count test case failed.");
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.fail((String)"Error occurred while log-in to add APIs. Pagination count test case failed.");
        }
        catch (MalformedURLException e) {
            Assert.fail((String)"Invalid service URL to add APIs. Pagination count test case failed.");
        }
        this.getPaginatedAPIsFromStoreAndVerify(0, 2, 2);
        this.getPaginatedAPIsFromStoreAndVerify(2, 2, 2);
        this.getPaginatedAPIsFromStoreAndVerify(4, 3, 1);
        this.getPaginatedAPIsFromPublisherAndVerify(0, 2, 2);
        this.getPaginatedAPIsFromPublisherAndVerify(2, 2, 2);
        this.getPaginatedAPIsFromPublisherAndVerify(4, 3, 1);
    }

    private void getPaginatedAPIsFromPublisherAndVerify(int offset, int limit, int expect) throws org.wso2.am.integration.clients.publisher.api.ApiException {
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO publisherAPIs = this.restAPIPublisher.getAPIs(offset, limit);
        Assert.assertEquals((int)publisherAPIs.getCount(), (int)expect, (String)("Expected " + expect + " of APIs in the page with offset:" + offset + " but was " + publisherAPIs.getCount()));
        Assert.assertNotNull((Object)publisherAPIs.getPagination(), (String)"pagination element cannot be null in get APIs response");
        Assert.assertEquals((int)publisherAPIs.getPagination().getTotal(), (int)this.numberOfAPIs, (String)("Expected " + this.numberOfAPIs + " as total number of APIs in the system but was " + publisherAPIs.getPagination().getTotal()));
    }

    private void getPaginatedAPIsFromStoreAndVerify(int offset, int limit, int expect) throws ApiException {
        APIListDTO storeAPIs = this.restAPIStore.getAPIs(offset, limit);
        Assert.assertEquals((int)storeAPIs.getCount(), (int)expect, (String)("Expected " + expect + " of APIs in the page with offset:" + offset + " but was " + storeAPIs.getCount()));
        Assert.assertNotNull((Object)storeAPIs.getPagination(), (String)"pagination element cannot be null in get APIs response");
        Assert.assertEquals((int)storeAPIs.getPagination().getTotal(), (int)this.numberOfAPIs, (String)("Expected " + this.numberOfAPIs + " as total number of APIs in the system but was " + storeAPIs.getPagination().getTotal()));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.restAPIPublisher != null) {
            for (int j = 0; j < this.numberOfAPIs; ++j) {
                String APIVersion = "1.0.0";
                this.restAPIPublisher.deleteAPI(this.createdAPIs.get(j).getId());
            }
        }
        super.cleanUp();
    }
}

