/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APIMANAGER4480AllSubscriptionsByApplicationTestCase
extends APIMIntegrationBaseTest {
    public static final int numberOfApplications = 5;
    public static final String SILVER = "Silver";
    private APIStoreRestClient apiStore;
    private final String applicationNamePrefix = "APILifeCycleTestAPI-application_";

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER4480AllSubscriptionsByApplicationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        APIPublisherRestClient apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        String APIName = "APIGetAllSubscriptionsTestAPI";
        String APIContext = "getAllSubscriptionsTestAPI";
        String tags = "youtube, video, media";
        String url = "http://gdata.youtube.com/feeds/api/standardfeeds";
        String description = "This is test API create by API manager integration test";
        String providerName = "admin";
        String APIVersion = "1.0.0";
        apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setVisibility("restricted");
        apiRequest.setRoles("admin");
        apiRequest.setTiersCollection(SILVER);
        apiRequest.setTier(SILVER);
        apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(APIName, providerName, APILifeCycleState.PUBLISHED);
        apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        for (int i = 0; i < 5; ++i) {
            String applicationName = "APILifeCycleTestAPI-application_" + i;
            this.apiStore.addApplication(applicationName, "50PerMin", "", "this-is-test");
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(APIName, this.storeContext.getContextTenant().getContextUser().getUserName());
            subscriptionRequest.setApplicationName(applicationName);
            subscriptionRequest.setTier(SILVER);
            this.apiStore.subscribe(subscriptionRequest);
            APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(applicationName);
            String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
            JSONObject response = new JSONObject(responseString);
            String error = response.getString("error");
            if (!"true".equals(error)) continue;
            throw new Exception("Unable to generate the tokens. Hence unable to execute the test case");
        }
        Thread.sleep(60000L);
    }

    @Test(description="List all Subscriptions By by calling the getAllSubscriptions")
    public void testGetAllSubscriptions() throws Exception {
        String subscriptionData = this.apiStore.getAllSubscriptions().getData();
        JSONObject jsonSubscription = new JSONObject(subscriptionData);
        int returnedSubscriptions = 0;
        if (jsonSubscription.getString("error").equals("false")) {
            JSONObject jsonSubscriptionsObject = jsonSubscription.getJSONObject("subscriptions");
            JSONArray jsonApplicationsArray = jsonSubscriptionsObject.getJSONArray("applications");
            for (int i = 0; i < jsonApplicationsArray.length(); ++i) {
                JSONObject appObject = jsonApplicationsArray.getJSONObject(i);
                String applicationName = appObject.getString("name");
                if ("DefaultApplication".equals(applicationName)) continue;
                JSONArray subscribedAPIJSONArray = appObject.getJSONArray("subscriptions");
                int length = subscribedAPIJSONArray.length();
                Assert.assertEquals((int)1, (int)length, (String)("No subscriptions found for application : " + applicationName));
                if (length <= 0) continue;
                ++returnedSubscriptions;
            }
        } else {
            throw new Exception("Unable to get the list of subscriptions.");
        }
        Assert.assertEquals((int)5, (int)returnedSubscriptions, (String)"Invalid number of total subscriptions were returned by getAllSubscriptions()");
    }

    @Test(description="List all Subscriptions By by calling the getAllSubscriptionsOfApplication")
    public void testGetAllSubscriptionsOfApplication() throws Exception {
        String subscriptionData = this.apiStore.getAllSubscriptionsOfApplication().getData();
        JSONObject jsonSubscription = new JSONObject(subscriptionData);
        int returnedSubscriptions = 0;
        if (jsonSubscription.getString("error").equals("false")) {
            JSONObject jsonSubscriptionsObject = jsonSubscription.getJSONObject("subscriptions");
            JSONArray jsonApplicationsArray = jsonSubscriptionsObject.getJSONArray("applications");
            for (int i = 0; i < jsonApplicationsArray.length(); ++i) {
                JSONObject appObject = jsonApplicationsArray.getJSONObject(i);
                String applicationName = appObject.getString("name");
                if ("DefaultApplication".equals(applicationName)) continue;
                JSONArray subscribedAPIJSONArray = appObject.getJSONArray("subscriptions");
                int length = subscribedAPIJSONArray.length();
                if (i == 0) {
                    Assert.assertEquals((int)1, (int)length, (String)("No subscriptions found for application : " + applicationName));
                } else {
                    Assert.assertEquals((int)0, (int)length, (String)("Subscriptions found for application : " + applicationName));
                }
                if (length <= 0) continue;
                ++returnedSubscriptions;
            }
        } else {
            throw new Exception("Unable to get the list of subscriptions.");
        }
        Assert.assertEquals((int)1, (int)returnedSubscriptions, (String)"More than the number of expected subscriptions were returned");
    }

    @Test(description="List all Subscriptions By by calling the getAllSubscriptionsOfApplication with application name")
    public void testGetAllSubscriptionsOfApplicationWithSelectedApp() throws Exception {
        String selectedApplication = "APILifeCycleTestAPI-application_1";
        String subscriptionData = this.apiStore.getAllSubscriptionsOfApplication(selectedApplication).getData();
        JSONObject jsonSubscription = new JSONObject(subscriptionData);
        if (jsonSubscription.getString("error").equals("false")) {
            JSONObject jsonSubscriptionsObject = jsonSubscription.getJSONObject("subscriptions");
            JSONArray jsonApplicationsArray = jsonSubscriptionsObject.getJSONArray("applications");
            for (int i = 0; i < jsonApplicationsArray.length(); ++i) {
                JSONObject appObject = jsonApplicationsArray.getJSONObject(i);
                String applicationName = appObject.getString("name");
                JSONArray subscribedAPIJSONArray = appObject.getJSONArray("subscriptions");
                int length = subscribedAPIJSONArray.length();
                if ("DefaultApplication".equals(applicationName)) {
                    Assert.assertEquals((int)0, (int)length, (String)("subscriptions found for the default application : " + applicationName));
                    continue;
                }
                if (selectedApplication.equals(applicationName)) {
                    Assert.assertEquals((int)1, (int)length, (String)("No subscriptions found for the selected application : " + applicationName));
                    continue;
                }
                Assert.assertEquals((int)0, (int)length, (String)("subscriptions found for invalid application : " + applicationName));
            }
        } else {
            throw new Exception("Unable to get the list of subscriptions.");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.cleanUp();
    }
}

