/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIScopeTestForTenantsTestCase
extends APIMIntegrationBaseTest {
    private final String TENANT1_DOMAIN = "tenantscope1.com";
    private final String TENANT1_ADMIN_USERNAME = "firstAdmin";
    private final String TENANT1_ADMIN_PASSWORD = "password1";
    private final String TENANT1_API_NAME = "APIScopeTenantAPI1";
    private final String TENANT1_API_VERSION = "1.0.0";
    private final String TENANT1_APP_NAME = "TenantScope1App";
    private final String TENANT1_ADMIN_USER = "firstAdmin@tenantscope1.com";
    private final String TENANT1_API_CONTEXT = "testScopeAPITenant1";
    private UserManagementClient userManagementClient1 = null;
    private final String TENANT1_SUBSCRIBER_ROLE = "subscriberTenant1";
    private final String USER_PETER = "peter";
    private final String USER_PASSWORD = "peter123";
    private final String TENANT1_USER_PETER = "peter@tenantscope1.com";
    private final String TENANT2_DOMAIN = "tenantscope2.com";
    private final String TENANT2_ADMIN_USERNAME = "secondAdmin";
    private final String TENANT2_ADMIN_PASSWORD = "password2";
    private final String TENANT2_API_NAME = "APIScopeTenantAPI2";
    private final String TENANT2_API_VERSION = "1.0.0";
    private final String TENANT2_APP_NAME = "TenantScope2App";
    private final String TENANT2_ADMIN_USER = "secondAdmin@tenantscope2.com";
    private final String TENANT2_API_CONTEXT = "testScopeAPITenant2";
    private final String TENANT2_SUBSCRIBER_ROLE = "subscriberTenant2";
    private final String TENANT2_USER_PETER = "peter@tenantscope2.com";
    private UserManagementClient userManagementClient2 = null;
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiPublisher = new APIPublisherRestClient(this.getPublisherURLHttp());
        this.apiStore = new APIStoreRestClient(this.getStoreURLHttp());
        String[] userPermissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
        this.tenantManagementServiceClient.addTenant("tenantscope1.com", "password1", "firstAdmin", "demo");
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), "firstAdmin@tenantscope1.com", "password1");
        this.userManagementClient1.addRole("subscriberTenant1", new String[0], userPermissions);
        this.userManagementClient1.addUser("peter", "peter123", new String[]{"subscriberTenant1"}, "peter");
        this.tenantManagementServiceClient.addTenant("tenantscope2.com", "password2", "secondAdmin", "demo");
        this.userManagementClient2 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), "secondAdmin@tenantscope2.com", "password2");
        this.userManagementClient2.addRole("subscriberTenant2", new String[0], userPermissions);
        this.userManagementClient2.addUser("peter", "peter123", new String[]{"subscriberTenant2"}, "peter");
    }

    @Test(groups={"wso2.am"}, description="Testing using same scope key in tenants")
    public void testSameScopeInTenants() throws Exception {
        this.publishAPI("firstAdmin@tenantscope1.com", "password1", "APIScopeTenantAPI1", "testScopeAPITenant1", "1.0.0", "subscriberTenant1");
        this.apiStore.login("peter@tenantscope1.com", "peter123");
        this.subscribeToAPI("TenantScope1App", "APIScopeTenantAPI1", "firstAdmin@tenantscope1.com");
        JSONObject jsonResponse = this.getApplicationKeys("TenantScope1App");
        String consumerKey = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        String consumerSecret = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        JSONObject accessTokenGenerationResponse = this.getUserAccessKeys("peter@tenantscope1.com", "peter123", consumerKey, consumerSecret);
        this.apiStore.logout();
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        String gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + "tenantscope1.com" + "/";
        HttpResponse response = this.invokeAPI(accessToken, gatewayUrl, "testScopeAPITenant1", "1.0.0");
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"peter@tenantscope1.com can access the POST method");
        this.publishAPI("secondAdmin@tenantscope2.com", "password2", "APIScopeTenantAPI2", "testScopeAPITenant2", "1.0.0", "subscriberTenant2");
        this.apiStore.login("peter@tenantscope2.com", "peter123");
        this.subscribeToAPI("TenantScope2App", "APIScopeTenantAPI2", "secondAdmin@tenantscope2.com");
        jsonResponse = this.getApplicationKeys("TenantScope2App");
        consumerKey = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerKey");
        consumerSecret = jsonResponse.getJSONObject("data").getJSONObject("key").getString("consumerSecret");
        accessTokenGenerationResponse = this.getUserAccessKeys("peter@tenantscope2.com", "peter123", consumerKey, consumerSecret);
        this.apiStore.logout();
        accessToken = accessTokenGenerationResponse.getString("access_token");
        gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + "tenantscope2.com" + "/";
        response = this.invokeAPI(accessToken, gatewayUrl, "testScopeAPITenant2", "1.0.0");
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"peter@tenantscope2.com can access the POST method");
    }

    private void publishAPI(String adminUser, String adminPassword, String apiName, String apiContext, String apiVersion, String role) throws Exception {
        String url = this.getGatewayURLNhttp() + "response";
        String description = "This is a test API created by API manager integration test";
        this.apiPublisher.login(adminUser, adminPassword);
        this.waitForAPIDeployment();
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setDescription(description);
        apiRequest.setVersion(apiVersion);
        apiRequest.setProvider(adminUser);
        this.apiPublisher.addAPI(apiRequest);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, adminUser, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        this.waitForAPIDeploymentSync(adminUser, apiName, apiVersion, "\"isApiExists\":true");
        String modifiedResource = "{\"paths\":{ \"/test\":{\"put\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\" },\"post\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"user_scope\"},\"get\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\" },\"delete\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\"},\"options\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"APIScopeTestAPI\",\"version\":\"1.0.0\"},\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[{\"name\":\"user_scope\",\"description\":\"\",\"key\":\"user_scope\",\"roles\":\"" + role + "\"}]}}}";
        this.apiPublisher.updateResourceOfAPI(adminUser, apiName, apiVersion, modifiedResource);
        this.waitForAPIDeployment();
        this.apiPublisher.logout();
    }

    private void subscribeToAPI(String appName, String apiName, String adminUser) throws Exception {
        this.apiStore.addApplication(appName, "Unlimited", "some_url", "NewApp");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, adminUser);
        subscriptionRequest.setApplicationName(appName);
        this.apiStore.subscribe(subscriptionRequest);
    }

    private JSONObject getApplicationKeys(String appName) throws Exception {
        APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator(appName);
        String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
        return new JSONObject(responseString);
    }

    private JSONObject getUserAccessKeys(String username, String password, String consumerKey, String consumerSecret) throws Exception {
        URL tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        String requestBody = "grant_type=password&username=" + username + "&password=" + password + "&scope=user_scope";
        HttpResponse response = this.apiStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        return new JSONObject(response.getData());
    }

    private HttpResponse invokeAPI(String accessToken, String gatewayUrl, String apiContext, String apiVersion) throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        URL endPointURL = new URL(gatewayUrl + apiContext + "/" + apiVersion + "/test");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        return HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiStore != null) {
            this.apiStore.login("peter@tenantscope1.com", "peter123");
            this.apiStore.removeApplication("TenantScope1App");
            this.apiStore.logout();
            this.apiStore.login("peter@tenantscope2.com", "peter123");
            this.apiStore.removeApplication("TenantScope2App");
            this.apiStore.logout();
        }
        if (this.apiPublisher != null) {
            this.apiPublisher.login("firstAdmin@tenantscope1.com", "password1");
            this.apiPublisher.deleteAPI("APIScopeTenantAPI1", "1.0.0", "firstAdmin@tenantscope1.com");
            this.apiPublisher.logout();
            this.apiPublisher.login("secondAdmin@tenantscope2.com", "password2");
            this.apiPublisher.deleteAPI("APIScopeTenantAPI2", "1.0.0", "secondAdmin@tenantscope2.com");
            this.apiPublisher.logout();
        }
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser("peter");
            this.userManagementClient1.deleteRole("subscriberTenant1");
        }
        if (this.userManagementClient2 != null) {
            this.userManagementClient2.deleteUser("peter");
            this.userManagementClient2.deleteRole("subscriberTenant2");
        }
        super.cleanUp();
    }
}

