/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class AdvancedConfigDeploymentConfig
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(AdvancedConfigDeploymentConfig.class);
    private final String TENANT_CONFIG_LOCATION = "/_system/config/apimgt/applicationdata/tenant-conf.json";
    private ServerConfigurationManager serverConfigurationManager;
    private AutomationContext superTenantKeyManagerContext;
    private ResourceAdminServiceClient resourceAdminServiceClient;

    @BeforeTest(alwaysRun=true)
    public void startServerWithMultipleConfigs() throws Exception {
        super.init();
        this.superTenantKeyManagerContext = new AutomationContext("APIM", "keyManager", TestUserMode.SUPER_TENANT_ADMIN);
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        String tenantConfSrcLocation = IOUtils.toString((InputStream)new FileInputStream(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "notification" + File.separator + "tenant-conf.json"));
        this.resourceAdminServiceClient.updateTextContent("/_system/config/apimgt/applicationdata/tenant-conf.json", tenantConfSrcLocation);
        this.serverConfigurationManager = new ServerConfigurationManager(this.superTenantKeyManagerContext);
        this.serverConfigurationManager.applyConfigurationWithoutRestart(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "common" + File.separator + "deployment.toml"));
        this.serverConfigurationManager.restartGracefully();
    }

    @AfterTest(alwaysRun=true)
    public void restoreConfigs() throws Exception {
        String tenantConfSrcLocation = IOUtils.toString((InputStream)new FileInputStream(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "common" + File.separator + "tenant-conf.json"));
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        this.resourceAdminServiceClient.updateTextContent("/_system/config/apimgt/applicationdata/tenant-conf.json", tenantConfSrcLocation);
        this.serverConfigurationManager.restoreToLastConfiguration();
    }
}

