/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.webapp.WebAppAdminClient;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.webapp.WebAppDeploymentUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class DeleteSubscribedApiFromPublisherTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(DeleteSubscribedApiFromPublisherTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String apiName = "DeleteSubscribeAPITest1";
    private String version = "1.0.0";
    private String apiContext = "deletesubscribeapi";
    private String tags = "testtag1,teasttag2";
    private String providerName;
    private String applicationName = "DeleteSubscribeAPITestCase";
    private String visibility = "public";
    private String description = "Test_Delete_Subscribe_API_from_Publisher";
    private String endPointType = "http";
    private String tier = "Gold";
    private static final String webApp = "jaxrs_basic";

    @Factory(dataProvider="userModeDataProvider")
    public DeleteSubscribedApiFromPublisherTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String fileFormat = ".war";
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        String path = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator;
        String sourcePath = path + webApp + fileFormat;
        String sessionId = this.createSession(this.gatewayContextWrk);
        WebAppAdminClient webAppAdminClient = new WebAppAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), sessionId);
        webAppAdminClient.uploadWarFile(sourcePath);
        boolean isWebAppDeployed = WebAppDeploymentUtil.isWebApplicationDeployed((String)this.gatewayContextWrk.getContextUrls().getBackEndUrl(), (String)sessionId, (String)webApp);
        Assert.assertTrue((boolean)isWebAppDeployed, (String)"Web APP is not deployed");
        String publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
        String storeURLHttp = this.storeUrls.getWebAppURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(storeURLHttp);
        this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        ArrayList<APIResourceBean> resourceBeanList = new ArrayList<APIResourceBean>();
        resourceBeanList.add(new APIResourceBean("GET", "Application & Application User", this.tier, "customers/{id}/"));
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        String endpoint = "/services/customers/customerservice";
        String endPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + webApp + endpoint;
        String accessUrl = gatewayUrl + this.apiContext + "/" + this.version + "/customers/123";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean(this.apiName, this.apiContext, this.version, this.providerName, new URL(endPointUrl));
        apiCreationRequestBean.setResourceBeanList(resourceBeanList);
        apiCreationRequestBean.setVisibility(this.visibility);
        apiCreationRequestBean.setDescription(this.description);
        apiCreationRequestBean.setTags(this.tags);
        apiCreationRequestBean.setEndpointType(this.endPointType);
        HttpResponse apiCreateResponse = this.apiPublisher.addAPI(apiCreationRequestBean);
        Assert.assertEquals((int)apiCreateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)apiCreateResponse.getData().contains("{\"error\" : false}"), (String)("Response Data Mismatched Actual: " + apiCreateResponse.getData()));
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(this.apiName, this.providerName, APILifeCycleState.PUBLISHED);
        HttpResponse statusUpdateResponse = this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        Assert.assertEquals((int)statusUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code is Mismatched");
        Assert.assertTrue((boolean)statusUpdateResponse.getData().contains("\"error\" : false"), (String)"Response Data Mismatched");
        this.apiStore.addApplication(this.applicationName, this.tier, "", "This-is-Test");
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, this.version, this.providerName, this.applicationName, this.tier);
        this.apiStore.subscribe(subscriptionRequest);
        log.info((Object)subscriptionRequest);
        APPKeyRequestGenerator appKeyRequestGenerator = new APPKeyRequestGenerator(this.applicationName);
        String responseString = this.apiStore.generateApplicationKey(appKeyRequestGenerator).getData();
        JSONObject jsonObject = new JSONObject(responseString);
        String accessToken = jsonObject.getJSONObject("data").getJSONObject("key").getString("accessToken");
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("Authorization", " Bearer " + accessToken);
        requestHeader.put("accept", "text/xml");
        new HttpRequestUtil();
        HttpResponse response = HttpRequestUtil.doGet((String)accessUrl, requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatched");
        Assert.assertTrue((boolean)response.getData().contains("<Customer><id>123</id><name>John</name></Customer>"), (String)"Response Data Mismatch");
    }

    @Test(groups={"wso2.am"}, description="Delete Subscribe API from Publisher")
    public void testDeleteSubscribedApi() throws Exception {
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        HttpResponse deleteResponse = this.apiPublisher.deleteAPI(this.apiName, this.version, this.providerName);
        Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode());
        JSONObject deleteResponseJson = new JSONObject(deleteResponse.getData());
        Assert.assertTrue((boolean)deleteResponseJson.getBoolean("error"), (String)"Response Data Error");
        HttpResponse apiNOTDeletePublisher = this.apiPublisher.getAllAPIs();
        JSONObject jsonObject = new JSONObject((Object)apiNOTDeletePublisher);
        String responseString = jsonObject.getString("data");
        JSONObject jsonObject1 = new JSONObject(responseString);
        JSONArray jsonArray = jsonObject1.getJSONArray("apis");
        if (jsonArray.length() != 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                String apiName = jsonArray.getJSONObject(i).getString("name");
                Assert.assertEquals((String)apiName, (String)this.apiName, (String)"API is deleted from the publisher");
            }
        }
    }

    @Test(groups={"wso2.am"}, description="Delete API from Store and Publisher", dependsOnMethods={"testDeleteSubscribedApi"})
    public void deleteApiFromSubscriberPublisher() throws Exception {
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        HttpResponse storeDeleteResponse = this.apiStore.removeAPISubscriptionByName(this.apiName, this.version, this.providerName, this.applicationName);
        Assert.assertEquals((int)storeDeleteResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)storeDeleteResponse.getData().contains("{\"error\" : false}"), (String)"Response Data Mismatch");
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        HttpResponse publisherApiDelete = this.apiPublisher.deleteAPI(this.apiName, this.version, this.providerName);
        Assert.assertEquals((int)publisherApiDelete.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Invalid Response Code");
        Assert.assertTrue((boolean)publisherApiDelete.getData().contains("{\"error\" : false}"), (String)"Response Data Mismatch");
        HttpResponse apiDeletePublisher = this.apiPublisher.getAllAPIs();
        JSONObject jsonObject = new JSONObject((Object)apiDeletePublisher);
        String responseString = jsonObject.getString("data");
        JSONObject jsonObject1 = new JSONObject(responseString);
        JSONArray jsonArray = jsonObject1.getJSONArray("apis");
        if (jsonArray.length() != 0) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                String apiName = jsonArray.getJSONObject(i).getString("name");
                Assert.assertNotEquals((Object)apiName, (Object)this.apiName, (String)"API is not deleted from the publisher");
            }
        }
        this.providerName = this.storeContext.getContextTenant().getContextUser().getUserName();
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(this.apiName, this.version, this.providerName, this.applicationName, this.tier);
        HttpResponse subscribeResponseWithoutPublisher = this.apiStore.subscribe(subscriptionRequest);
        Assert.assertTrue((boolean)subscribeResponseWithoutPublisher.getData().contains("{\"error\" : true"), (String)"Response Data Mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.apiStore.removeApplication(this.applicationName);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }
}

