/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;

public class LocationHeaderTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(LocationHeaderTestCase.class);
    private String applicationId;
    private String apiId;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="Check whether the Location header is correct")
    public void testAPIWithLocationHeader() throws Exception {
        String endpointUrl = this.getAPIInvocationURLHttp("locationheader");
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpGet get = new HttpGet(endpointUrl);
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);
        Header locationHeader = httpResponse.getFirstHeader("Location");
        Assert.assertFalse((boolean)locationHeader.getValue().endsWith("//abc/domain"), (String)"Location header contains additional / character");
        Assert.assertTrue((boolean)locationHeader.getValue().endsWith("/abc/domain"), (String)("Unexpected Location header. Expected to end with /abc/domain but received " + locationHeader));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

