/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class SameVersionAPITestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(SameVersionAPITestCase.class);
    private static final String API_NAME = "SameVersionAPITest";
    private static final String API_CONTEXT = "SameVersionAPI";
    private String version = "1.0.0";
    private String newVersion = "1.0.0";
    private String TAGS = "testtag1, testtag2";
    private String providerName;
    private String visibility = "public";
    private String description = "Test Description";
    private String tier = "Gold";
    private String resTier = "10KPerMin";
    private String endPointType = "http";
    private String apiId;
    private String resourceMethodAuthType = "Application & Application User";
    private String uriTemplate = "customers/{id}/";

    @Factory(dataProvider="userModeDataProvider")
    public SameVersionAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"webapp"}, description="Copy Same Version")
    public void copySameVersion() throws Exception {
        String gatewayUrl = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        String endpointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        APIRequest apiRequest = new APIRequest(API_NAME, API_CONTEXT, new URL(endpointUrl));
        apiRequest.setTags(this.TAGS);
        apiRequest.setDescription(this.description);
        apiRequest.setVersion(this.version);
        apiRequest.setProvider(this.providerName);
        apiRequest.setEndpointType(this.endPointType);
        apiRequest.setResourceMethodAuthType(this.resourceMethodAuthType);
        apiRequest.setTier(this.tier);
        apiRequest.setResourceMethodThrottlingTier(this.resTier);
        apiRequest.setUriTemplate(this.uriTemplate);
        apiRequest.setVisibility(this.visibility);
        HttpResponse serviceResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = serviceResponse.getData();
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Invalid Response Code");
        try {
            this.restAPIPublisher.copyAPI(this.newVersion, this.apiId, Boolean.valueOf(false));
            Assert.assertTrue((boolean)false, (String)"Same version API test case failed");
        }
        catch (Exception e) {
            if (((ApiException)((Object)e)).getResponseBody().contains("Resource Already Exists")) {
                log.info((Object)"Same version API test case passed");
            }
            Assert.assertTrue((boolean)false, (String)"Same version API test case failed");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

