/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class SharedScopeTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(SharedScopeTestCase.class);
    private String sharedScopeName = "TestSharedScope";
    private String sharedScopeDisplayName = "Test Shared Scope";
    private String description = "This is a test shared scope";
    private String updatedDescription = "This is a updated test shared scope";
    private List<String> roles = new ArrayList<String>();
    private String sharedScopeId;

    @Factory(dataProvider="userModeDataProvider")
    public SharedScopeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Test add shared scope")
    public void testAddSharedScope() throws Exception {
        ScopeDTO scopeDTO = new ScopeDTO();
        scopeDTO.setName(this.sharedScopeName);
        scopeDTO.setDisplayName(this.sharedScopeDisplayName);
        scopeDTO.setDescription(this.description);
        this.roles.add("Internal/publisher");
        this.roles.add("admin");
        scopeDTO.setBindings(this.roles);
        ScopeDTO addedScopeDTO = this.restAPIPublisher.addSharedScope(scopeDTO);
        this.sharedScopeId = addedScopeDTO.getId();
        Assert.assertNotNull((Object)this.sharedScopeId, (String)"The scope ID cannot be null or empty");
    }

    @Test(groups={"wso2.am"}, description="Test get and update shared scope", dependsOnMethods={"testAddSharedScope"})
    public void testGetAndUpdateSharedScope() throws Exception {
        ScopeDTO sharedScopeDTO = this.restAPIPublisher.getSharedScopeById(this.sharedScopeId);
        Assert.assertEquals((String)sharedScopeDTO.getName(), (String)this.sharedScopeName, (String)"Shared scope name does not match with the expected name");
        Assert.assertEquals((String)sharedScopeDTO.getDisplayName(), (String)this.sharedScopeDisplayName, (String)"Shared scope display name does not match with the expected display name");
        Assert.assertTrue((boolean)sharedScopeDTO.getBindings().contains("admin"), (String)"Shared scope does not include the expected role");
        sharedScopeDTO.setDescription(this.updatedDescription);
        ScopeDTO updateScopeDTO = this.restAPIPublisher.updateSharedScope(this.sharedScopeId, sharedScopeDTO);
        Assert.assertEquals((String)updateScopeDTO.getDescription(), (String)this.updatedDescription, (String)"Shared scope description does not match with the expected description");
    }

    @Test(groups={"wso2.am"}, description="Test get and update shared scope", dependsOnMethods={"testGetAndUpdateSharedScope"})
    public void testDeleteSharedScope() throws Exception {
        this.restAPIPublisher.deleteSharedScope(this.sharedScopeId);
    }
}

