/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.integration.common.utils.mgt.ServerConfigurationManager;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceExceptionException;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class SubscriptionWFHTTPRedirectTest
extends APIManagerLifecycleBaseTest {
    private APIPublisherRestClient apiPublisher;
    private String publisherURLHttp;
    private String storeURLHttp;
    private String userName;
    private String originalWFExtentionsXML;
    private String newWFExtentionsXML;
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private APIIdentifier apiIdentifier;
    private final String DEFAULT_WF_EXTENTIONS_XML_REG_CONFIG_LOCATION = "/_system/governance/apimgt/applicationdata/workflow-extensions.xml";
    private String appName = "sample-application-workflow2";
    private static JSONParser parser = new JSONParser();

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws AutomationUtilException, XPathExpressionException, IOException, APIManagerIntegrationTestException, URISyntaxException, ResourceAdminServiceExceptionException {
        super.init();
        ServerConfigurationManager serverConfigurationManager = new ServerConfigurationManager(this.gatewayContextMgt);
        serverConfigurationManager.copyToComponentLib(new File(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "workflowHTTPRedirect" + File.separator + "SubscriptionCreationCustomWorkflowExecutor-1.0.0.jar"));
        serverConfigurationManager.restartGracefully();
        super.init();
        this.publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.userName = this.user.getUserName();
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        this.originalWFExtentionsXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml");
        this.newWFExtentionsXML = this.readFile(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "workflowHTTPRedirect" + File.separator + "workflow-extentions.xml");
    }

    @Test(groups={"wso2.am"}, description="Test if the custom subscription workflow response returns the redirect URI")
    public void testHTTPredirectInSubscriptionWorkflow() throws Exception {
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.newWFExtentionsXML);
        String apiName = "HTTPRedirectTestAPI2";
        String url = "http://localhost:9443/carbon";
        String description = "This is test API create by API manager integration test";
        String apiVersion = "1.0.0";
        this.apiPublisher = new APIPublisherRestClient(this.publisherURLHttp);
        APIStoreRestClient apiStore = new APIStoreRestClient(this.storeURLHttp);
        this.apiPublisher.login(this.userName, this.userName);
        APIRequest apiRequest = new APIRequest(apiName, apiVersion, new URL(url));
        apiRequest.setDescription(description);
        apiRequest.setVersion(apiVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.userName);
        this.apiPublisher.addAPI(apiRequest);
        this.apiIdentifier = new APIIdentifier(this.userName, apiName, apiVersion);
        APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.userName, APILifeCycleState.PUBLISHED);
        this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
        apiStore.login(this.userName, this.user.getPassword());
        apiStore.addApplication(this.appName, "50PerMin", "", "this-is-test");
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, this.userName);
        subscriptionRequest.setApplicationName(this.appName);
        HttpResponse httpresponse = apiStore.subscribe(subscriptionRequest);
        String httpresponseData = httpresponse.getData();
        org.json.JSONObject jsondata = new org.json.JSONObject(httpresponseData);
        org.json.JSONObject status = (org.json.JSONObject)jsondata.get("status");
        if (status != null) {
            org.json.JSONObject workflowResponse = null;
            JSONObject jsonpayloadObject = null;
            workflowResponse = (org.json.JSONObject)status.get("workflowResponse");
            if (workflowResponse != null && (jsonpayloadObject = (JSONObject)parser.parse((String)workflowResponse.get("jsonPayload"))) != null) {
                Assert.assertEquals((String)jsonpayloadObject.get((Object)"redirectUrl").toString(), (String)"http://google.lk");
            }
        } else {
            Assert.assertFalse((boolean)true);
        }
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        super.cleanUp();
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.originalWFExtentionsXML);
    }
}

