/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.client.utils.AuthenticateStubUtil;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceClaimMetadataException;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.ClaimMetadataManagementServiceStub;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.AttributeMappingDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.ClaimPropertyDTO;
import org.wso2.carbon.identity.claim.metadata.mgt.stub.dto.LocalClaimDTO;
import org.wso2.carbon.registry.resource.stub.ResourceAdminServiceExceptionException;
import org.wso2.carbon.utils.FileManipulator;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class TenantClaimsTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(TenantClaimsTestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private final String STORE_USERNAME = "kimhill@wso2.com";
    private final String STORE_PASSWORD = "kimhill1234";
    private static final String hostname = "localhost";
    private static final String port = "9943";
    private static final String serviceEndpoint = "https://localhost:9943/services/";
    private static final String USER_EMAIL_ADDRESS = "kim@wso2.com";
    private String storeURLHttp;
    private String newSignUPXML;
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private final String SIGNUP_XML_REG_CONFIG_LOCATION = "/_system/governance/apimgt/applicationdata/sign-up-config.xml";
    private final String claims = " Kim|Hill|ABC Network|USA|kim@wso2.com|0016269934122|0016269934134|kimhill|www.abcNsounds.org|department|12-12-2000|subscriber";

    @Factory(dataProvider="userModeDataProvider")
    public TenantClaimsTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    public void initialize() throws APIManagerIntegrationTestException {
        try {
            this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.publisherContext.getContextUrls().getBackEndUrl(), this.createSession(this.publisherContext));
            String artifactsLocation = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + "sign-up-config.xml";
            this.newSignUPXML = this.readFile(artifactsLocation);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while getting accessing claims");
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error while getting accessing claims");
        }
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String publisherURLHttp = this.getPublisherURLHttp();
        this.storeURLHttp = this.getStoreURLHttp();
        this.apiPublisher = new APIPublisherRestClient(publisherURLHttp);
        this.apiStore = new APIStoreRestClient(this.storeURLHttp);
    }

    @Test(groups={"wso2.am"}, description="Testing Notification Feature")
    public void tenantClaimsTestCase() throws APIManagerIntegrationTestException {
        try {
            this.replaceSignUpXml();
            this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
            this.addClaims();
            this.checkDisplayOrder();
            HttpResponse storeSignUpResponse = this.apiStore.signUpforTenant("kimhill@wso2.com", "kimhill1234", " Kim|Hill|ABC Network|USA|kim@wso2.com|0016269934122|0016269934134|kimhill|www.abcNsounds.org|department|12-12-2000|subscriber");
            log.info((Object)"Sign Up User: kimhill@wso2.com");
            JSONObject signUpJsonObject = null;
            signUpJsonObject = new JSONObject(storeSignUpResponse.getData());
            Assert.assertFalse((boolean)signUpJsonObject.getBoolean("error"), (String)"Error in user sign up Response");
            HttpResponse loginResponse = this.apiStore.login("kimhill@wso2.com", "kimhill1234");
            JSONObject loginJsonObject = new JSONObject(loginResponse.getData());
            Assert.assertFalse((boolean)loginJsonObject.getBoolean("error"), (String)"Error in Login Request: User Name : kimhill@wso2.com");
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error while getting store context", (Throwable)e);
        }
        catch (JSONException e) {
            log.error((Object)"Error while signing up", (Throwable)e);
        }
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.TENANT_ADMIN}};
    }

    public void replaceSignUpXml() throws APIManagerIntegrationTestException {
        this.initialize();
        try {
            this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/sign-up-config.xml", this.newSignUPXML);
        }
        catch (RemoteException e) {
            log.error((Object)"Error while updating text context", (Throwable)e);
        }
        catch (ResourceAdminServiceExceptionException e) {
            log.error((Object)"Error while getting service client", (Throwable)e);
        }
    }

    public void addClaims() {
        String url = null;
        try {
            url = this.keyManagerContext.getContextUrls().getBackEndUrl();
            ClaimMetadataManagementServiceStub stub = new ClaimMetadataManagementServiceStub(null, url + "ClaimMetadataManagementService");
            AuthenticateStubUtil.authenticateStub((String)"admin@wso2.com", (String)"admin", (Stub)stub);
            AttributeMappingDTO attributeMappingDTO = new AttributeMappingDTO();
            attributeMappingDTO.setAttributeName("dateOfBirth");
            attributeMappingDTO.setUserStoreDomain("primary");
            LocalClaimDTO localClaimDTO = new LocalClaimDTO();
            ClaimPropertyDTO claimPropertyDTO1 = new ClaimPropertyDTO();
            ClaimPropertyDTO claimPropertyDTO2 = new ClaimPropertyDTO();
            claimPropertyDTO1.setPropertyName("DisplayName");
            claimPropertyDTO1.setPropertyValue("Birth Date");
            claimPropertyDTO2.setPropertyName("SupportedByDefault");
            claimPropertyDTO2.setPropertyValue("true");
            ClaimPropertyDTO[] claimPropertyDTO = new ClaimPropertyDTO[]{claimPropertyDTO1, claimPropertyDTO2};
            AttributeMappingDTO[] attributeMappingDTO1 = new AttributeMappingDTO[]{attributeMappingDTO};
            localClaimDTO.setAttributeMappings(attributeMappingDTO1);
            localClaimDTO.setClaimProperties(claimPropertyDTO);
            localClaimDTO.setLocalClaimURI("http://wso2.org/claims/dob");
            stub.updateLocalClaim(localClaimDTO);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error while getting Key Manager context", (Throwable)e);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error while getting accessing claims", (Throwable)axisFault);
        }
        catch (ClaimMetadataManagementServiceClaimMetadataException e) {
            log.error((Object)"Error while updating local claim", (Throwable)e);
        }
        catch (RemoteException e) {
            log.error((Object)"Error while connecting to stub", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkDisplayOrder() throws APIManagerIntegrationTestException {
        this.apiStore.login(this.user.getUserName(), this.user.getPassword());
        int deploymentDelayInMilliseconds = 90000;
        String finalOutputStore = null;
        String[] responseArrayFromStore = new String[27];
        ArrayList<String> userFieldNames = new ArrayList<String>();
        boolean isStoreResponse = false;
        long startTime = System.currentTimeMillis();
        try {
            this.storeContext = new AutomationContext("APIM", "store-old", TestUserMode.TENANT_ADMIN);
            String fileStore = this.storeContext.getContextTenant().getDomain().equals("carbon.super") ? "testStore.jag" : "testStoreTenantClaims.jag";
            String sourcePath = this.computeSourcePath(fileStore);
            String destinationPath = this.computeDestPath(fileStore);
            this.copySampleFile(sourcePath, destinationPath);
            while (System.currentTimeMillis() - startTime < (long)deploymentDelayInMilliseconds && !isStoreResponse) {
                String inputLine;
                URL jaggeryURL = new URL(this.storeUrls.getWebAppURLHttp() + "testapp/" + fileStore);
                URLConnection jaggeryServerConnection = jaggeryURL.openConnection();
                BufferedReader in = new BufferedReader(new InputStreamReader(jaggeryServerConnection.getInputStream()));
                while ((inputLine = in.readLine()) != null) {
                    finalOutputStore = inputLine;
                }
                Assert.assertNotNull((Object)finalOutputStore);
                Gson gson = new Gson();
                if (null != finalOutputStore) {
                    responseArrayFromStore = finalOutputStore.split("==");
                    ArrayList userFields = (ArrayList)gson.fromJson(responseArrayFromStore[8], ArrayList.class);
                    for (Object string : userFields) {
                        userFieldNames.add(string.toString().split(",")[0].split("=")[1]);
                    }
                    Assert.assertTrue((boolean)((String)userFieldNames.get(0)).contentEquals("First Name"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(1)).contentEquals("Last Name"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(2)).contentEquals("Organization"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(3)).contentEquals("Country"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(4)).contentEquals("Email"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(5)).contentEquals("Telephone"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(6)).contentEquals("Mobile"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(7)).contentEquals("IM"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(8)).contentEquals("URL"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(9)).contentEquals("Department"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(10)).contentEquals("Birth Date"));
                    Assert.assertTrue((boolean)((String)userFieldNames.get(11)).contentEquals("Role"));
                }
                in.close();
                Assert.assertNotNull((Object)finalOutputStore, (String)"Result cannot be null");
            }
            log.info(finalOutputStore);
        }
        catch (XPathExpressionException e) {
            log.error((Object)"Error while getting Tenant domain", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while invoking test application to test publisher host object", (Throwable)e);
        }
        finally {
            Assert.assertNotNull(finalOutputStore, (String)"Result cannot be null");
        }
        return true;
    }

    protected String readFile(String fileLocation) throws APIManagerIntegrationTestException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(new File(fileLocation)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ioE) {
            throw new APIManagerIntegrationTestException("IOException when reading the file from:" + fileLocation, (Throwable)ioE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error when closing the buffer reader which used to reed the file:" + fileLocation + ". Error:" + e.getMessage()));
                }
            }
        }
    }

    private void copySampleFile(String sourcePath, String destPath) {
        File sourceFile = new File(sourcePath);
        File destFile = new File(destPath);
        try {
            FileManipulator.copyFile((File)sourceFile, (File)destFile);
        }
        catch (IOException e) {
            log.error((Object)"Error while copying the other into Jaggery server", (Throwable)e);
        }
    }

    private String computeDestPath(String fileName) {
        String serverRoot = System.getProperty("carbon.home");
        String deploymentPath = serverRoot + "/repository/deployment/server/jaggeryapps/testapp";
        File depFile = new File(deploymentPath);
        if (!depFile.exists() && !depFile.mkdir()) {
            log.error((Object)("Error while creating the deployment folder : " + deploymentPath));
        }
        return deploymentPath + File.separator + fileName;
    }

    private String computeSourcePath(String fileName) {
        return this.getAMResourceLocation() + File.separator + "jaggery/" + fileName;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

