/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.net.URL;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM520UpdateAnAPIThroughThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    private final String apiNameTest = "APIM520PublisherTest";
    private final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisher;
    private String apiProviderName;
    private String apiProductionEndPointUrl;
    private String id;

    @Factory(dataProvider="userModeDataProvider")
    public APIM520UpdateAnAPIThroughThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String apiProductionEndpointPostfixUrl = "jaxrs_basic/services/customers/customerservice/customers/123";
        this.apiProductionEndPointUrl = this.gatewayUrlsWrk.getWebAppURLHttp() + apiProductionEndpointPostfixUrl;
        this.apiProviderName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Update an API Through the Publisher Rest API")
    public void testUpdateAnAPIThroughThePublisherRest() throws Exception {
        String apiContextTest = "apim520PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTag = "tag520-1, tag520-2, tag520-3";
        APIRequest apiCreationRequestBean = new APIRequest("APIM520PublisherTest", apiContextTest, new URL(this.apiProductionEndPointUrl));
        apiCreationRequestBean.setVersion("1.0.0");
        apiCreationRequestBean.setProvider(this.apiProviderName);
        apiCreationRequestBean.setTags(apiTag);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefault_version("default_version");
        apiCreationRequestBean.setDefault_version_checked("default_version");
        apiCreationRequestBean.setBusinessOwner("api520b");
        apiCreationRequestBean.setBusinessOwnerEmail("api520b@ee.com");
        apiCreationRequestBean.setTechnicalOwner("api520t");
        apiCreationRequestBean.setTechnicalOwnerEmail("api520t@ww.com");
        HttpResponse apiCreationResponse = this.restAPIPublisher.addAPI(apiCreationRequestBean);
        this.id = apiCreationResponse.getData();
        Assert.assertEquals((int)apiCreationResponse.getResponseCode(), (int)Response.Status.CREATED.getStatusCode(), (String)"Response Code miss matched when creating the API");
        HttpResponse apiResponsePublisher = this.restAPIPublisher.getAPI(this.id);
        Assert.assertTrue((boolean)apiResponsePublisher.getData().contains("APIM520PublisherTest"), (String)"APIM520PublisherTest is not visible in publisher");
        apiCreationRequestBean.setDescription("Description Changed");
        apiCreationRequestBean.setTiersCollection("Unlimited,Gold,Bronze");
        HttpResponse apiUpdateResponse = this.restAPIPublisher.updateAPI(apiCreationRequestBean, this.id);
        Assert.assertEquals((int)apiUpdateResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code miss matched when creating the API");
        this.waitForAPIDeployment();
        HttpResponse apiUpdateResponsePublisher = this.restAPIPublisher.getAPI(this.id);
        Assert.assertTrue((boolean)apiUpdateResponsePublisher.getData().contains("APIM520PublisherTest"), (String)"APIM520PublisherTest is not updated");
        Assert.assertTrue((boolean)apiUpdateResponsePublisher.getData().contains("Description Changed"), (String)"Description of the APIM520PublisherTest is not updated");
        Assert.assertTrue((boolean)apiUpdateResponsePublisher.getData().contains("Unlimited"), (String)"Tier Collection of the APIM520PublisherTest is not updated");
        Assert.assertTrue((boolean)apiUpdateResponsePublisher.getData().contains("Bronze"), (String)"Tier Collection of the APIM520PublisherTest is not updated");
        Assert.assertTrue((boolean)apiUpdateResponsePublisher.getData().contains("Gold"), (String)"Tier Collection of the APIM520PublisherTest is not updated");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.id);
        super.cleanUp();
    }
}

