/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import java.io.File;
import java.net.URL;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM614AddDocumentationToAnAPIWithDocTypeSampleAndSDKThroughPublisherRestAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String apiName = "APIM614PublisherTest";
    private final String apiVersion = "1.0.0";
    private final String docName = "APIM629PublisherTestHowTo-File-summary";
    private final String summary = "Testing";
    private String apiProvider;
    private String apiEndPointUrl;
    private String apiId;
    private String fileTypeDocumentId;
    private DocumentDTO documentDTO = new DocumentDTO();

    @Factory(dataProvider="userModeDataProvider")
    public APIM614AddDocumentationToAnAPIWithDocTypeSampleAndSDKThroughPublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewayUrl = "carbon.super".equals(this.gatewayContextWrk.getContextTenant().getDomain()) ? this.gatewayUrlsWrk.getWebAppURLNhttp() : this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.gatewayContextWrk.getContextTenant().getDomain() + "/";
        this.apiEndPointUrl = gatewayUrl + "jaxrs_basic/services/customers/customerservice";
        this.apiProvider = this.user.getUserName();
    }

    @Test(groups={"wso2.am"}, description="Create an API to update the documents with source type file  through the publisher rest API ")
    public void testApiCreation() throws Exception {
        String apiContext = "apim614PublisherTestAPI";
        String apiDescription = "This is Test API Created by API Manager Integration Test";
        String apiTags = "tag614-1, tag622-2, tag624-3";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIM614PublisherTest", apiContext, "1.0.0", this.apiProvider, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTags(apiTags);
        apiCreationRequestBean.setDescription(apiDescription);
        apiCreationRequestBean.setTiersCollection("Gold,Bronze");
        apiCreationRequestBean.setDefaultVersion("default_version");
        apiCreationRequestBean.setDefaultVersionChecked("default_version");
        apiCreationRequestBean.setBizOwner("api620b");
        apiCreationRequestBean.setBizOwnerMail("api620b@ee.com");
        apiCreationRequestBean.setTechOwner("api620t");
        apiCreationRequestBean.setTechOwnerMail("api620t@ww.com");
        APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
        this.apiId = apiDto.getId();
        this.documentDTO.setName("APIM629PublisherTestHowTo-File-summary");
        this.documentDTO.setSummary("Testing");
        this.documentDTO.setType(DocumentDTO.TypeEnum.HOWTO);
        this.documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.FILE);
        this.documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        HttpResponse documentationResponse = this.restAPIPublisher.addDocument(this.apiId, this.documentDTO);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while adding file-based documentation to API");
        this.fileTypeDocumentId = documentationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type HowTo And Source File through the publisher rest API ", dependsOnMethods={"testApiCreation"})
    public void testAddDocumentToAnAPIHowToFile() throws Exception {
        String fileNameAPIM614 = "APIM614.txt";
        String docName = "APIM614PublisherTestHowTo-File-summary";
        String filePathAPIM614 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM614;
        File file = new File(filePathAPIM614);
        this.documentDTO.setType(DocumentDTO.TypeEnum.HOWTO);
        this.documentDTO.setName(docName);
        HttpResponse updateDocumentResponse = this.restAPIPublisher.updateDocument(this.apiId, this.fileTypeDocumentId, this.documentDTO);
        Assert.assertEquals((int)updateDocumentResponse.getResponseCode(), (int)200, (String)"Error while updating the documents");
        HttpResponse documentationResponse = this.restAPIPublisher.updateContentDocument(this.apiId, this.fileTypeDocumentId, file);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while updating documentation to API");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type Sample SDK And Source File through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPIHowToFile"})
    public void testAddDocumentToAnAPISDKToFile() throws Exception {
        String fileNameAPIM622 = "APIM622.txt";
        String docName = "APIM622PublisherTestHowTo-File-summary";
        String filePathAPIM622 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM622;
        File file = new File(filePathAPIM622);
        this.documentDTO.setType(DocumentDTO.TypeEnum.SAMPLES);
        this.documentDTO.setName(docName);
        HttpResponse updateDocumentResponse = this.restAPIPublisher.updateDocument(this.apiId, this.fileTypeDocumentId, this.documentDTO);
        Assert.assertEquals((int)updateDocumentResponse.getResponseCode(), (int)200, (String)"Error while updating the documents");
        HttpResponse documentationResponse = this.restAPIPublisher.updateContentDocument(this.apiId, this.fileTypeDocumentId, file);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while updating documentation to API");
    }

    @Test(groups={"wso2.am"}, description="Add Documentation To An API With Type Other And Source File through the publisher rest API ", dependsOnMethods={"testAddDocumentToAnAPISDKToFile"})
    public void testAddDocumentToAnAPIOtherFile() throws Exception {
        String fileNameAPIM629 = "APIM629.txt";
        String docName = "APIM629PublisherTestHowTo-File-summary";
        String filePathAPIM629 = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "lifecycletest" + File.separator + fileNameAPIM629;
        File file = new File(filePathAPIM629);
        this.documentDTO.setType(DocumentDTO.TypeEnum.HOWTO);
        this.documentDTO.setName(docName);
        HttpResponse updateDocumentResponse = this.restAPIPublisher.updateDocument(this.apiId, this.fileTypeDocumentId, this.documentDTO);
        Assert.assertEquals((int)updateDocumentResponse.getResponseCode(), (int)200, (String)"Error while updating the documents");
        HttpResponse documentationResponse = this.restAPIPublisher.updateContentDocument(this.apiId, this.fileTypeDocumentId, file);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while updating documentation to API");
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

