/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.publisher;

import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ThrottlingPolicyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ThrottlingPolicyListDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class APIM634GetAllTheThrottlingTiersFromThePublisherRestAPITestCase
extends APIMIntegrationBaseTest {
    @Factory(dataProvider="userModeDataProvider")
    public APIM634GetAllTheThrottlingTiersFromThePublisherRestAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Get all the throttling tiers from the publisher rest API ")
    public void testGetAllTheThrottlingTiers() throws Exception {
        ThrottlingPolicyListDTO throttlingPolicyListDTO = this.restAPIPublisher.getTiers(ThrottlingPolicyDTO.PolicyLevelEnum.SUBSCRIPTION.getValue());
        Assert.assertNotNull((Object)throttlingPolicyListDTO, (String)"There are no API level policies available");
        ThrottlingPolicyDTO tierBronze = (ThrottlingPolicyDTO)throttlingPolicyListDTO.getList().get(0);
        Assert.assertEquals((String)tierBronze.getDescription(), (String)"Allows 1000 requests per minute", (String)"Invalid description of the tier Bronze");
        Assert.assertEquals((String)tierBronze.getDisplayName(), (String)"Bronze", (String)"Invalid display name of the tier Bronze");
        Assert.assertEquals((String)tierBronze.getName(), (String)"Bronze", (String)"Invalid name of the tier Bronze");
        ThrottlingPolicyDTO tierGold = (ThrottlingPolicyDTO)throttlingPolicyListDTO.getList().get(1);
        Assert.assertEquals((String)tierGold.getDescription(), (String)"Allows 5000 requests per minute", (String)"Invalid description of the tier Gold");
        Assert.assertEquals((String)tierGold.getDisplayName(), (String)"Gold", (String)"Invalid display name of the tier Gold");
        Assert.assertEquals((String)tierGold.getName(), (String)"Gold", (String)"Invalid name of the tier Gold");
        ThrottlingPolicyDTO tierSilver = (ThrottlingPolicyDTO)throttlingPolicyListDTO.getList().get(2);
        Assert.assertEquals((String)tierSilver.getDescription(), (String)"Allows 2000 requests per minute", (String)"Invalid description of the tier Silver");
        Assert.assertEquals((String)tierSilver.getDisplayName(), (String)"Silver", (String)"Invalid display name of the tier Silver");
        Assert.assertEquals((String)tierSilver.getName(), (String)"Silver", (String)"Invalid name of the tier Silver");
        ThrottlingPolicyDTO tierUnlimited = (ThrottlingPolicyDTO)throttlingPolicyListDTO.getList().get(3);
        Assert.assertEquals((String)tierUnlimited.getDescription(), (String)"Allows unlimited requests", (String)"Invalid description of the tier Unlimited");
        Assert.assertEquals((String)tierUnlimited.getDisplayName(), (String)"Unlimited", (String)"Invalid display name of the tier Unlimited");
        Assert.assertEquals((String)tierUnlimited.getName(), (String)"Unlimited", (String)"Invalid name of the tier Unlimited");
    }
}

