/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.rest;

import java.io.File;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class URLMappingRESTTestCase
extends APIMIntegrationBaseTest {
    private String gatewaySessionCookie;

    @Factory(dataProvider="userModeDataProvider")
    public URLMappingRESTTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.gatewaySessionCookie = this.createSession(this.gatewayContextMgt);
        String synapseConfFile = this.gatewayContextWrk.getContextTenant().getDomain().equals("carbon.super") ? "url-mapping-synapse.xml" : "url-mapping-synapse-tenant.xml";
        this.loadSynapseConfigurationFromClasspath("artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + synapseConfFile, this.gatewayContextMgt, this.gatewaySessionCookie);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "urlmapping", "1.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Sending a Message Via REST to test uri template fix")
    public void testRESTURITemplate() throws Exception {
        HttpResponse response = HttpRequestUtil.sendGetRequest((String)this.getAPIInvocationURLHttp("urlmapping/1.0.0/test/"), null);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatch");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

