/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi;

import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SearchResultListDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class ContentSearchTestCase
extends APIManagerLifecycleBaseTest {
    private Log log = LogFactory.getLog(ContentSearchTestCase.class);
    private String endpointURL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private String version = "1.0.0";
    private int retries = 10;
    private String contentSearchTestAPI = "contentSearchTestAPI";
    private String description = "Unified Search Feature";
    private String apiId;
    private String password = "wso2apim";
    private String user1 = "user1";
    private String user2 = "user2";
    private String role1 = "role1";
    private String role2 = "role2";
    private RestAPIPublisherImpl restAPIPublisherFirstUser;
    private RestAPIStoreImpl restAPIStoreFirstUser;
    private RestAPIPublisherImpl restAPIPublisherSecondUser;
    private RestAPIStoreImpl restAPIStoreSecondUser;
    private UserManagementClient userManagementClient1;
    private final String[] SEC_ROLE1_PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage", "/permission/admin/configure", "/permission/admin/monitor"};
    private final String[] SEC_ROLE2_PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/configure"};
    private final String[] SEC_OLD_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone"};

    @Factory(dataProvider="userModeDataProvider")
    public ContentSearchTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        APIRequest apiRequest = this.createAPIRequest(this.contentSearchTestAPI, this.contentSearchTestAPI, this.endpointURL, this.version, this.user.getUserName(), this.description);
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.user1 = "secondary/" + this.user1;
            this.user2 = "secondary/" + this.user2;
            this.role1 = "secondary/" + this.role1;
            this.role2 = "secondary/" + this.role2;
            this.userManagementClient1.addRole(this.role1, new String[0], this.SEC_ROLE1_PERMISSIONS);
            this.userManagementClient1.addRole(this.role2, new String[0], this.SEC_ROLE2_PERMISSIONS);
            String[] newRoleList = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", this.role1};
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), newRoleList);
        }
        this.userManagementClient1.addUser(this.user1, this.password, new String[]{this.role1, "Internal/publisher", "Internal/subscriber"}, this.user1);
        this.userManagementClient1.addUser(this.user2, this.password, new String[]{this.role2, "Internal/publisher", "Internal/subscriber"}, this.user2);
        this.restAPIPublisherFirstUser = new RestAPIPublisherImpl(this.user1, this.password, this.user.getUserDomain(), this.publisherURLHttps);
        this.restAPIPublisherSecondUser = new RestAPIPublisherImpl(this.user2, this.password, this.user.getUserDomain(), this.publisherURLHttps);
        this.restAPIStoreFirstUser = new RestAPIStoreImpl(this.user1, this.password, this.user.getUserDomain(), this.storeURLHttps);
        this.restAPIStoreSecondUser = new RestAPIStoreImpl(this.user2, this.password, this.user.getUserDomain(), this.storeURLHttps);
    }

    @Test(groups={"wso2.am"}, description="Test basic content Search")
    public void testBasicContentSearch() throws Exception {
        org.wso2.am.integration.clients.publisher.api.v1.dto.SearchResultListDTO searchResultListDTO;
        int i;
        this.log.info((Object)"Basic Content Search");
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIPublisher.searchAPIs(this.description);
            if (searchResultListDTO.getCount() == 1) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Basic content search in publisher failed. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Basic content search in publisher failed. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(3000L);
        }
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIStore.searchAPIs(this.description);
            if (searchResultListDTO.getCount() == 1) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Basic content search in store failed. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Basic content search in store failed. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(3000L);
        }
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEMOTE_TO_CREATE.getAction());
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIStore.searchAPIs(this.description);
            if (searchResultListDTO.getCount() == 0) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Basic content search in store failed. 0 results expected. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Basic content search in store failed. 0 results expected. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(3000L);
        }
    }

    @Test(groups={"wso2.am"}, description="Test document content Search", dependsOnMethods={"testContentSearchWithStoreVisibility"})
    public void testDocumentContentSearch() throws Exception {
        org.wso2.am.integration.clients.publisher.api.v1.dto.SearchResultListDTO searchResultListDTO;
        int i;
        this.log.info((Object)"Document Content Search");
        String documentName = "Test-Document";
        String documentContent = "This is a sample API to test unified search feature - github4156";
        DocumentDTO documentDTO = new DocumentDTO();
        documentDTO.setName(documentName);
        documentDTO.setSourceType(DocumentDTO.SourceTypeEnum.INLINE);
        documentDTO.setType(DocumentDTO.TypeEnum.HOWTO);
        documentDTO.setSummary("document summary");
        documentDTO.setVisibility(DocumentDTO.VisibilityEnum.API_LEVEL);
        HttpResponse documentHttpResponse = this.restAPIPublisher.addDocument(this.apiId, documentDTO);
        Assert.assertEquals((int)documentHttpResponse.getResponseCode(), (int)200, (String)"Error while add documentation to API");
        String documentId = documentHttpResponse.getData();
        this.restAPIPublisher.addContentDocument(this.apiId, documentId, documentContent);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIPublisher.searchAPIs("github4156");
            if (searchResultListDTO.getCount() == 1) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Document content search in publisher failed. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Document content search in publisher failed. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(3000L);
        }
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIStore.searchAPIs("github4156");
            if (searchResultListDTO.getCount() == 1) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Document content search in store failed. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Document content search in store failed. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(3000L);
        }
    }

    @Test(groups={"wso2.am"}, description="Test content Search with access control", dependsOnMethods={"testBasicContentSearch"})
    public void testContentSearchWithAccessControl() throws Exception {
        org.wso2.am.integration.clients.publisher.api.v1.dto.SearchResultListDTO searchResultListDTO;
        int i;
        HttpResponse httpResponse = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apiDto = (APIDTO)g.fromJson(httpResponse.getData(), APIDTO.class);
        apiDto.setAccessControl(APIDTO.AccessControlEnum.RESTRICTED);
        ArrayList<String> roles = new ArrayList<String>();
        roles.add(this.role1);
        apiDto.setAccessControlRoles(roles);
        apiDto.setVisibility(APIDTO.VisibilityEnum.RESTRICTED);
        apiDto.setVisibleRoles(roles);
        this.restAPIPublisher.updateAPI(apiDto);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction());
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIPublisherFirstUser.searchAPIs(this.description);
            if (searchResultListDTO.getCount() == 1) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Content search with access control failed. 1 result expected. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Content search with access control failed. 1 results expected. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(3000L);
        }
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIPublisherSecondUser.searchAPIs(this.description);
            if (searchResultListDTO.getCount() == 0) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Content search with access control failed. 0 result expected. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Content search with access control failed. 0 results expected. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(3000L);
        }
    }

    @Test(groups={"wso2.am"}, description="Test content Search with store visibility", dependsOnMethods={"testContentSearchWithAccessControl"})
    public void testContentSearchWithStoreVisibility() throws Exception {
        SearchResultListDTO searchResultListDTO;
        int i;
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIStoreFirstUser.searchAPIs(this.description);
            if (searchResultListDTO.getCount() == 1) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Content search with visibility failed. 1 result expected. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Content search with visibility failed. 1 results expected. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(5000L);
        }
        for (i = 0; i <= this.retries; ++i) {
            searchResultListDTO = this.restAPIStoreSecondUser.searchAPIs(this.description);
            if (searchResultListDTO.getCount() == 0) {
                Assert.assertTrue((boolean)true);
                break;
            }
            if (i == this.retries) {
                Assert.fail((String)("Content search with visibility failed. 0 result expected. Received response : " + searchResultListDTO.getCount()));
                continue;
            }
            this.log.warn((Object)("Content search with visibility failed. 0 results expected. Received response : " + searchResultListDTO.getCount() + " Retrying..."));
            Thread.sleep(5000L);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroyAPIs() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.userManagementClient1.deleteRole(this.role1);
            this.userManagementClient1.deleteRole(this.role2);
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.SEC_OLD_ROLE_LIST);
        }
        this.userManagementClient1.deleteUser(this.user1);
        this.userManagementClient1.deleteUser(this.user2);
        super.cleanUp();
    }

    private APIRequest createAPIRequest(String name, String context, String url, String version, String provider, String description) throws MalformedURLException, APIManagerIntegrationTestException {
        APIRequest apiRequest = new APIRequest(name, context, new URL(url));
        apiRequest.setVersion(version);
        apiRequest.setDescription(description);
        apiRequest.setProvider(provider);
        return apiRequest;
    }
}

