/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.admin;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.ApiException;
import org.wso2.am.integration.clients.admin.ApiResponse;
import org.wso2.am.integration.clients.admin.api.dto.LabelDTO;
import org.wso2.am.integration.clients.admin.api.dto.LabelListDTO;
import org.wso2.am.integration.test.helpers.AdminApiTestHelper;
import org.wso2.am.integration.test.impl.DtoFactory;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class LabelTestCase
extends APIMIntegrationBaseTest {
    private LabelDTO labelDTO;
    private AdminApiTestHelper adminApiTestHelper;

    @Factory(dataProvider="userModeDataProvider")
    public LabelTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminApiTestHelper = new AdminApiTestHelper();
    }

    @Test(groups={"wso2.am"}, description="Test add label")
    public void testAddLabel() throws Exception {
        String name = "Test Label";
        String description = "This is a test label";
        List<String> accessUrls = Collections.singletonList("http://localhost:9443/");
        this.labelDTO = DtoFactory.createLabelDTO((String)name, (String)description, accessUrls);
        ApiResponse addedLabel = this.restAPIAdmin.addLabel(this.labelDTO);
        Assert.assertEquals((int)addedLabel.getStatusCode(), (int)201);
        LabelDTO addedLabelDTO = (LabelDTO)addedLabel.getData();
        String labelId = addedLabelDTO.getId();
        Assert.assertNotNull((Object)labelId, (String)"The label ID cannot be null or empty");
        this.labelDTO.setId(labelId);
        this.adminApiTestHelper.verifyLabelDTO(this.labelDTO, addedLabelDTO);
    }

    @Test(groups={"wso2.am"}, description="Test get all labels", dependsOnMethods={"testAddLabel"})
    public void testGetLabels() throws Exception {
        ApiResponse retrievedLabels = this.restAPIAdmin.getLabels();
        Assert.assertEquals((int)retrievedLabels.getStatusCode(), (int)200);
        LabelListDTO labelListDTO = (LabelListDTO)retrievedLabels.getData();
        List labelDTOS = labelListDTO.getList();
        for (LabelDTO label : labelDTOS) {
            this.adminApiTestHelper.verifyLabelDTO(this.labelDTO, label);
        }
    }

    @Test(groups={"wso2.am"}, description="Test update label", dependsOnMethods={"testGetLabels"})
    public void testUpdateLabel() throws Exception {
        String updatedDescription = "This is a updated test label";
        this.labelDTO.setDescription(updatedDescription);
        ApiResponse updatedLabel = this.restAPIAdmin.updateLabel(this.labelDTO.getId(), this.labelDTO);
        LabelDTO updatedLabelDTO = (LabelDTO)updatedLabel.getData();
        Assert.assertEquals((int)updatedLabel.getStatusCode(), (int)200);
        this.adminApiTestHelper.verifyLabelDTO(this.labelDTO, updatedLabelDTO);
    }

    @Test(groups={"wso2.am"}, description="Test delete label", dependsOnMethods={"testUpdateLabel"})
    public void testDeleteLabel() throws Exception {
        ApiResponse apiResponse = this.restAPIAdmin.deleteLabel(this.labelDTO.getId());
        Assert.assertEquals((int)apiResponse.getStatusCode(), (int)200);
    }

    @Test(groups={"wso2.am"}, description="Test delete label with non existing label ID", dependsOnMethods={"testDeleteLabel"})
    public void testDeleteLabelWithNonExistingLabelId() {
        try {
            this.restAPIAdmin.deleteLabel(UUID.randomUUID().toString() + UUID.randomUUID().toString());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404);
        }
    }
}

