/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.restapi.testcases;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.tests.restapi.RESTAPITestConstants;
import org.wso2.am.integration.tests.restapi.utils.RESTAPITestUtil;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class OnHoldSubscriptionWorkflowIdTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(OnHoldSubscriptionWorkflowIdTestCase.class);
    private final String DEFAULT_WF_EXTENTIONS_XML_REG_CONFIG_LOCATION = "/_system/governance/apimgt/applicationdata/workflow-extensions.xml";
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private String originalWFExtentionsXML;
    private String newWFExtentionsXML;

    @Factory(dataProvider="userModeDataProvider")
    public OnHoldSubscriptionWorkflowIdTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        this.originalWFExtentionsXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml");
        this.newWFExtentionsXML = this.readFile(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "APIM5898" + File.separator + "workflow-extensions.xml");
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.newWFExtentionsXML);
    }

    @Test(groups={"wso2.am"}, description="Returning workflow external ref. id from subscriptions rest api in publisher when subscription is in ON_HOLD status")
    public void testSubscription() {
        String gatewayURL = this.getGatewayURLNhttp();
        String keyManagerURL = this.getKeyManagerURLHttp();
        String dataFilePath = new File(System.getProperty("user.dir")).getParent() + RESTAPITestConstants.PATH_SUBSTRING + "APIM5898.txt";
        boolean testSuccessStatus = new RESTAPITestUtil().testRestAPI(dataFilePath, gatewayURL, keyManagerURL);
        Assert.assertTrue((boolean)testSuccessStatus);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        super.cleanUp();
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.originalWFExtentionsXML);
    }

    protected String readFile(String fileLocation) throws APIManagerIntegrationTestException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(new File(fileLocation)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ioE) {
            throw new APIManagerIntegrationTestException("IOException when reading the file from:" + fileLocation, (Throwable)ioE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error when closing the buffer reade which used to reed the file:" + fileLocation + ". Error:" + e.getMessage()));
                }
            }
        }
    }
}

