/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.sequence;

import java.net.URL;
import java.util.ArrayList;
import javax.activation.DataHandler;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationPolicyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class DefaultEndpointTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "AddDynamicEndpointAndInvokeAPITest";
    private final String API_CONTEXT = "AddDynamicEndpointAndInvokeAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AddDynamicEndpointAndInvokeAPI";
    private final String RESOURCE_PATH_SEPARATOR = "/";
    private String apiId;
    private String applicationID;
    private String subscriptionId1;
    private APIDTO apiDto;
    private String accessToken;
    private String apiEndPointUrl;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("AddDynamicEndpointAndInvokeAPI", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationID = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the default endpoint")
    public void testAPIInvocationAfterAddingDynamicEndpoint() throws Exception {
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRequest = new APIRequest("AddDynamicEndpointAndInvokeAPITest", "AddDynamicEndpointAndInvokeAPI", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operationsDTOS);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse subscription = this.restAPIStore.createSubscription(this.apiId, this.applicationID, "Unlimited");
        this.subscriptionId1 = subscription.getData();
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        ResourceAdminServiceClient resourceAdminServiceClient = new ResourceAdminServiceClient(this.publisherContext.getContextUrls().getBackEndUrl(), "admin", "admin");
        boolean isResourceAdded = resourceAdminServiceClient.addResource("/_system/governance/apimgt/applicationdata/provider/admin/AddDynamicEndpointAndInvokeAPITest/1.0.0/in/default_endpoint.xml", "application/xml", "xml files", new DataHandler(new URL("file:///" + this.getAMResourceLocation() + "/" + "sequence" + "/" + "default_endpoint.xml")));
        Assert.assertTrue((boolean)isResourceAdded, (String)"Adding Mediation Sequence File failed");
        ArrayList<MediationPolicyDTO> mediationPolicies = new ArrayList<MediationPolicyDTO>();
        MediationPolicyDTO mediationPolicyDTO = new MediationPolicyDTO();
        mediationPolicyDTO.setName("default_endpoint");
        mediationPolicyDTO.setType("in");
        mediationPolicies.add(mediationPolicyDTO);
        apiRequest.setMediationPolicies(mediationPolicies);
        String endPointString = "{\n  \"production_endpoints\": {\n    \"template_not_supported\": false,\n    \"config\": null,\n    \"url\": \"" + this.apiEndPointUrl + "\"\n  },\n  \"sandbox_endpoints\": {\n    \"url\": \"" + this.apiEndPointUrl + "\",\n    \"config\": null,\n    \"template_not_supported\": false\n  },\n  \"endpoint_type\": \"default\"\n}";
        JSONParser parser = new JSONParser();
        apiRequest.setEndpoint((JSONObject)parser.parse(endPointString));
        this.restAPIPublisher.updateAPI(apiRequest, this.apiId);
        this.waitForAPIDeployment();
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddDynamicEndpointAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response.getHeaders("Content-Type")[0].getValue(), (String)"application/xml");
    }
}

