/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.throttling;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class APIThrottlingTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIThrottlingTestCase.class);
    private String apiName = "APIThrottleAPI";
    private String apiContext = "api_throttle";
    private String tags = "token, throttling";
    private String description = "This is test API created by API manager integration test";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String applicationName = "APIThrottle-application";
    private String backendURL;
    private String apiId;
    private String applicationId;
    String subscriberUser = "subscriberUser2";
    String subscriberUserWithTenantDomain;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.backendURL = this.getSuperTenantAPIInvocationURLHttp("api_throttle_backend", "1.0");
        this.providerName = this.user.getUserName();
    }

    @Test(groups={"throttling"}, description="API Throttling Test", enabled=true)
    public void testAPIThrottling_1() throws APIManagerIntegrationTestException, XPathExpressionException, IOException, org.wso2.am.integration.clients.publisher.api.ApiException, ApiException, ParseException {
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("20KPerMin");
        apiOperationsDTO.setTarget("/test");
        apiOperationsDTOS.add(apiOperationsDTO);
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(this.backendURL));
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setProvider(this.providerName);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setOperationsDTOS(apiOperationsDTOS);
        apiRequest.setTags(this.tags);
        apiRequest.setDescription(this.description);
        HttpResponse applicationResponse = this.restAPIStore.createApplication(this.applicationName, "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.OAUTH);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId = applicationResponse.getData();
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiName, this.apiVersion, "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found. return token: ", (String)accessToken);
        String invokeURL = this.getAPIInvocationURLHttps(this.apiContext);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        log.info((Object)("=============================== Headers : " + requestHeaders));
        log.info((Object)("=============================== invokeURL : " + invokeURL));
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/1.0.0/test"), requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.checkThrottling(accessToken, invokeURL, requestHeaders);
    }

    private void checkThrottling(String accessToken, String invokeURL, Map<String, String> requestHeaders) {
        int limit = 4;
        int numberOfIterations = 4;
        for (int count = 0; count < numberOfIterations; ++count) {
            try {
                log.info((Object)(" =================================== Number of time API Invoked : " + count));
                if (count == limit) {
                    Thread.sleep(10000L);
                }
                HttpResponse serviceResponse = this.callAPI(invokeURL, requestHeaders);
                if (count == limit) {
                    Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)429, (String)"Response code is not as expected");
                    continue;
                }
                Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Error occurred while calling API : " + ex));
                break;
            }
        }
    }

    private HttpResponse callAPI(String invokeURL, Map<String, String> requestHeaders) throws Exception {
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/1.0.0/test"), requestHeaders);
        return serviceResponse;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public APIThrottlingTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

