/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;

public class APIMANAGERUIIntegrationTestRunner
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGERUIIntegrationTestRunner.class);
    private String npmCommand;
    private String npmSourcePath;

    static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("win");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String output(InputStream inputStream) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = null;){
            String line;
            br = new BufferedReader(new InputStreamReader(inputStream));
            while ((line = br.readLine()) != null) {
                sb.append(line + System.getProperty("line.separator"));
            }
        }
        return sb.toString();
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() {
        try {
            super.init();
            this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
            this.npmCommand = APIMANAGERUIIntegrationTestRunner.isWindows() ? "npm.cmd" : "npm";
            this.npmSourcePath = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "jest-integration-tests";
        }
        catch (APIManagerIntegrationTestException e) {
            org.testng.Assert.assertTrue((boolean)false, (String)"Error occurred while initializing UI test executor");
        }
    }

    @Test(groups={"wso2.am"}, description="UI Integration test executor")
    public void testAllUI() {
        this.run("install");
        this.run("test");
    }

    void run(String arguments) {
        try {
            ProcessBuilder process = new ProcessBuilder(this.npmCommand, arguments).directory(new File(this.npmSourcePath));
            Map<String, String> env = process.environment();
            env.put("WSO2_PORT_OFFSET", String.valueOf(500));
            Process activeProcess = process.start();
            int exitCode = activeProcess.waitFor();
            log.info((Object)("Echo Input:\n" + APIMANAGERUIIntegrationTestRunner.output(activeProcess.getInputStream())));
            String errorOut = APIMANAGERUIIntegrationTestRunner.output(activeProcess.getErrorStream());
            log.warn((Object)("Echo Error:\n" + errorOut));
            Assert.assertEquals((String)errorOut, (long)0L, (long)exitCode);
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)"Something went wrong while executing the UI tests", (Throwable)e);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

