/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.workflow;

import com.google.gson.Gson;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.registry.ResourceAdminServiceClient;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowInfoDTO;
import org.wso2.am.integration.clients.admin.api.dto.WorkflowListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.HttpResponse;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.UserManagementUtils;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.am.integration.test.utils.clients.AdminDashboardRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.WorkflowStatus;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class WorkflowApprovalExecutorTest
extends APIManagerLifecycleBaseTest {
    private UserManagementClient userManagementClient = null;
    protected String user;
    private String originalWFExtentionsXML;
    private String newWFExtentionsXML;
    private String USER_SMITH = "smith";
    private String ADMIN_ROLE = "admin";
    private String USER_ADMIN = "jackson";
    private String userName;
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private ResourceAdminServiceClient resourceAdminServiceClient;
    private final String ALLOWED_ROLE = "admin";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private final String[] ADMIN_PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage", "/permission/admin/configure", "/permission/admin/monitor"};
    private final String[] NEW_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "admin"};
    private final String APIM_CONFIG_XML = "api-manager.xml";
    private final String DEFAULT_WF_EXTENTIONS_XML_REG_CONFIG_LOCATION = "/_system/governance/apimgt/applicationdata/workflow-extensions.xml";
    private RestAPIAdminImpl restAPIAdminUser;
    private static final Log log = LogFactory.getLog(WorkflowApprovalExecutorTest.class);
    private APIIdentifier apiIdentifier;
    private AdminDashboardRestClient adminDashboardRestClient;
    private String apiId;
    private String applicationID;
    private String subscriptionId;
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private RestAPIStoreImpl APIStoreClient;

    @Factory(dataProvider="userModeDataProvider")
    public WorkflowApprovalExecutorTest(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.adminDashboardRestClient = new AdminDashboardRestClient(this.getPublisherURLHttps());
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        this.userManagementClient.addUser(this.USER_SMITH, "john123", new String[]{"Internal/subscriber"}, this.USER_SMITH);
        this.userManagementClient.addUser(this.USER_ADMIN, "admin", new String[]{"admin"}, this.ADMIN_ROLE);
        this.resourceAdminServiceClient = new ResourceAdminServiceClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl(), this.createSession(this.gatewayContextMgt));
        this.originalWFExtentionsXML = this.resourceAdminServiceClient.getTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml");
        this.newWFExtentionsXML = this.readFile(this.getAMResourceLocation() + File.separator + "configFiles" + File.separator + "approveWorkflow" + File.separator + "workflow-extensions.xml");
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.newWFExtentionsXML);
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
    }

    @Test(groups={"wso2.am"}, description="Api workflow process check")
    public void testAPIWorkflowProcess() throws Exception {
        String apiName = "WorkflowCheckAPI";
        String apiVersion = "1.0.0";
        String apiContext = "workflowCheck";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.USER_SMITH);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifeCycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)201, (String)"API creation test failed in Approval Workflow Executor");
        Assert.assertEquals((int)lifeCycleChangeResponse.getResponseCode(), (int)200, (String)"Status code mismatch when request is make for change API state");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse api = this.restAPIPublisher.getAPI(this.apiId);
        JSONObject apiObj = new JSONObject(api.getData());
        String apiStatus = (String)apiObj.get("workflowStatus");
        Assert.assertEquals((String)apiStatus, (String)APILifeCycleState.CREATED.toString(), (String)"Lifecycle state should remain without changing till approval. ");
        String workflowType = "AM_API_STATE";
        this.restAPIAdminUser = new RestAPIAdminImpl(this.USER_SMITH, "john123", "carbon.super", this.adminURLHttps);
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow requests can only be viewed for the admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        Gson gsonResponse = new Gson();
        WorkflowListDTO workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        List list = new ArrayList();
        list = workflowListDTO.getList();
        String externalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : list) {
            externalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request by external workflow reference failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow request update failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String status = workflowDTO.getStatus().toString();
        Assert.assertEquals((String)status, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiNew = this.restAPIPublisher.getAPI(this.apiId);
        JSONObject apiObject = new JSONObject(apiNew.getData());
        String apiNewStatus = (String)apiObject.get("lifeCycleStatus");
        Assert.assertEquals((String)apiNewStatus, (String)APILifeCycleState.PUBLISHED.toString(), (String)"Lifecycle state should change after approval. ");
    }

    @Test(groups={"wso2.am"}, description="Application workflow process check", dependsOnMethods={"testAPIWorkflowProcess"}, enabled=true)
    public void testApplicationWorkflowProcess() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("ThisApp", "Default version testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        this.applicationID = applicationResponse.getData();
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Application Creation test failed in Approval Workflow Executor");
        ApplicationDTO appResponse = this.restAPIStore.getApplicationById(this.applicationID);
        String status1 = appResponse.getStatus();
        Assert.assertEquals((String)status1, (String)"CREATED", (String)"Application state should remain without changing till approval. ");
        String workflowType = "AM_APPLICATION_CREATION";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow requests an only view by Admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        Gson gsonResponse = new Gson();
        WorkflowListDTO workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        List list = new ArrayList();
        list = workflowListDTO.getList();
        String externalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : list) {
            externalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow state update failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        ApplicationDTO appFinalResponse = this.restAPIStore.getApplicationById(this.applicationID);
        String status = appFinalResponse.getStatus();
        Assert.assertEquals((String)status, (String)"APPROVED", (String)"Application state should change after  approval. ");
    }

    @Test(groups={"wso2.am"}, description="Subscription workflow process check", dependsOnMethods={"testApplicationWorkflowProcess"})
    public void testSubscriptionWorkflowProcess() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse SubscribeResponse = this.restAPIStore.createSubscription(this.apiId, this.applicationID, "Unlimited");
        this.subscriptionId = SubscribeResponse.getData();
        Assert.assertEquals((int)SubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of API is not successful");
        SubscriptionListDTO subscriptionListDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiId);
        List subscriptionList = new ArrayList();
        subscriptionList = subscriptionListDTO.getList();
        SubscriptionDTO.SubscriptionStatusEnum SubscriptionStatus = SubscriptionDTO.SubscriptionStatusEnum.BLOCKED;
        for (SubscriptionDTO subscriptioninfo : subscriptionList) {
            SubscriptionStatus = subscriptioninfo.getSubscriptionStatus();
        }
        Assert.assertEquals((Object)SubscriptionStatus, (Object)SubscriptionDTO.SubscriptionStatusEnum.ON_HOLD, (String)"Subscription state should remain without changing till approval. ");
        String workflowType = "AM_SUBSCRIPTION_CREATION";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow Pending requests can only viewed for User Admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        Gson gsonResponse = new Gson();
        WorkflowListDTO workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        List list = new ArrayList();
        list = workflowListDTO.getList();
        String externalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : list) {
            externalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Updated workflow state is failed for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        SubscriptionListDTO subscriptionFinalListDTO = this.restAPIPublisher.getSubscriptionByAPIID(this.apiId);
        List subscriptionFinalList = new ArrayList();
        subscriptionFinalList = subscriptionFinalListDTO.getList();
        for (SubscriptionDTO subscriptioninfo : subscriptionFinalList) {
            SubscriptionStatus = subscriptioninfo.getSubscriptionStatus();
        }
        Assert.assertEquals((Object)SubscriptionStatus, (Object)SubscriptionDTO.SubscriptionStatusEnum.UNBLOCKED, (String)"Subscription state should change after approval. ");
    }

    @Test(groups={"wso2.am"}, description="Registration workflow process check", dependsOnMethods={"testSubscriptionWorkflowProcess"})
    public void testRegistrationWorkflowProcess() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String keyState = applicationKeyDTO.getKeyState();
        Assert.assertEquals((String)keyState, (String)"CREATED", (String)"Application key generation should not change until approval");
        String workflowType = "AM_APPLICATION_REGISTRATION_PRODUCTION";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow pending requests can only view by admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        Gson gsonResponse = new Gson();
        WorkflowListDTO workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        List list = new ArrayList();
        list = workflowListDTO.getList();
        String externalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : list) {
            externalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated for the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"failed to update the workflow request for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        ApiResponse apiresponse = this.restAPIStore.getApplicationKeysByKeyType(this.applicationID, "PRODUCTION");
        ApplicationKeyDTO applicationKeyData = (ApplicationKeyDTO)apiresponse.getData();
        Assert.assertEquals((String)applicationKeyData.getKeyState(), (String)"COMPLETED", (String)"Application key generation stat should change after approval");
    }

    @Test(groups={"wso2.am"}, description="User Sign Up workflow process check", dependsOnMethods={"testRegistrationWorkflowProcess"})
    public void testUserSignUpWorkflowProcess() throws Exception {
        String giveName = "Jane";
        String username = "JaneDoe";
        String password = "admin";
        String organization = "wso2";
        String email = "janedoe@gmail.com";
        String store = this.storeURLHttps;
        UserManagementUtils.signupUser((String)username, (String)password, (String)giveName, (String)organization, (String)email);
        String workflowType = "AM_USER_SIGNUP";
        HttpResponse response = this.restAPIAdminUser.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow requests can only viewed by admin");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        Gson gsonResponse = new Gson();
        WorkflowListDTO workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        List list = new ArrayList();
        list = workflowListDTO.getList();
        String externalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : list) {
            externalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        response = this.restAPIAdminUser.getWorkflowByExternalWorkflowReference(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be viewed for the admin");
        response = this.restAPIAdminUser.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Workflow request can only be updated by the the admin");
        response = this.restAPIAdmin.updateWorkflowStatus(externalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Failed to update Workflow request for user admin");
        String jsonUpdateResponse = response.getData();
        Gson gsonUpdateResponse = new Gson();
        WorkflowDTO workflowDTO = (WorkflowDTO)gsonUpdateResponse.fromJson(jsonUpdateResponse, WorkflowDTO.class);
        String workflowStatus = workflowDTO.getStatus().toString();
        Assert.assertEquals((String)workflowStatus, (String)WorkflowStatus.APPROVED.toString(), (String)"Workflow state should change by the authorized admin. ");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse loginResponse = this.apiStore.login(username, password);
        Assert.assertEquals((int)loginResponse.getResponseCode(), (int)302, (String)"Failed to login to developer portal");
    }

    @Test(groups={"wso2.am"}, description="clean up workflow process check", dependsOnMethods={"testUserSignUpWorkflowProcess"})
    public void testCleanUpWorkflowProcess() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("MyApp", "Testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String applicationIDNew = applicationResponse.getData();
        String apiName = "WorkflowCheckingAPI";
        String apiVersion = "1.0.0";
        String apiContext = "workflowChecking";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.USER_SMITH);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        String apiIdNew = apiResponse.getData();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifeCycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(apiIdNew, APILifeCycleAction.PUBLISH.getAction(), null);
        String workflowType = "AM_API_STATE";
        HttpResponse response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonAPIStateChangeGetResponse = response.getData();
        Gson gsonAPIStateChangeGetResponse = new Gson();
        WorkflowListDTO workflowListDTO = (WorkflowListDTO)gsonAPIStateChangeGetResponse.fromJson(jsonAPIStateChangeGetResponse, WorkflowListDTO.class);
        List apiStateChangelist = new ArrayList();
        apiStateChangelist = workflowListDTO.getList();
        String apiStateChangeExternalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : apiStateChangelist) {
            apiStateChangeExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(apiStateChangeExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        workflowType = "AM_APPLICATION_CREATION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonApplicationCreationGetResponse = response.getData();
        Gson gsonApplicationCreationGetResponse = new Gson();
        workflowListDTO = (WorkflowListDTO)gsonApplicationCreationGetResponse.fromJson(jsonApplicationCreationGetResponse, WorkflowListDTO.class);
        List applicationCreationlist = new ArrayList();
        applicationCreationlist = workflowListDTO.getList();
        String applicationCreationExternalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : applicationCreationlist) {
            applicationCreationExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(applicationCreationExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        this.restAPIPublisher.deleteAPI(apiIdNew);
        this.restAPIStore.deleteApplication(applicationIDNew);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(applicationCreationExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for Application creation");
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(apiStateChangeExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for API state change");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponseNew = this.restAPIStore.createApplication("MyApp", "Testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String applicationIDSecond = applicationResponseNew.getData();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponseNew = this.restAPIPublisher.addAPI(apiRequest);
        String apiIdSecond = apiResponseNew.getData();
        this.restAPIPublisher.changeAPILifeCycleStatus(apiIdSecond, APILifeCycleAction.PUBLISH.getAction(), null);
        workflowType = "AM_API_STATE";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonAPIStateGetResponse = response.getData();
        Gson gsonAPIStateGetResponse = new Gson();
        workflowListDTO = (WorkflowListDTO)gsonAPIStateGetResponse.fromJson(jsonAPIStateGetResponse, WorkflowListDTO.class);
        List apiStateChangenewlist = new ArrayList();
        apiStateChangenewlist = workflowListDTO.getList();
        String apiStateChangeNewExternalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : apiStateChangenewlist) {
            apiStateChangeNewExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.updateWorkflowStatus(apiStateChangeNewExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Update workflow pending process is failed for user admin");
        workflowType = "AM_APPLICATION_CREATION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonApplicationCreation = response.getData();
        Gson gsonApplicationCreation = new Gson();
        workflowListDTO = (WorkflowListDTO)gsonApplicationCreation.fromJson(jsonApplicationCreation, WorkflowListDTO.class);
        List applicationCreationNewlist = new ArrayList();
        applicationCreationNewlist = workflowListDTO.getList();
        String applicationCreationNewExternalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : applicationCreationNewlist) {
            applicationCreationNewExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.updateWorkflowStatus(applicationCreationNewExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Update workflow pending process is failed for user admin");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse SubscribeResponse = this.restAPIStore.createSubscription(apiIdSecond, applicationIDSecond, "Unlimited");
        this.subscriptionId = SubscribeResponse.getData();
        Assert.assertEquals((int)SubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of  API  request not successful");
        workflowType = "AM_SUBSCRIPTION_CREATION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonSubscriptionCreationGet = response.getData();
        Gson gsonSubscriptionCreationGet = new Gson();
        workflowListDTO = (WorkflowListDTO)gsonSubscriptionCreationGet.fromJson(jsonSubscriptionCreationGet, WorkflowListDTO.class);
        List subscriptionCreationlist = new ArrayList();
        subscriptionCreationlist = workflowListDTO.getList();
        String subscriptionCreationExternalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : subscriptionCreationlist) {
            subscriptionCreationExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(subscriptionCreationExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationIDSecond, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        workflowType = "AM_APPLICATION_REGISTRATION_PRODUCTION";
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonKeyGenerationGetResponse = response.getData();
        Gson gsonKeyGenerationGetResponse = new Gson();
        workflowListDTO = (WorkflowListDTO)gsonKeyGenerationGetResponse.fromJson(jsonKeyGenerationGetResponse, WorkflowListDTO.class);
        List keyGenerationlist = new ArrayList();
        keyGenerationlist = workflowListDTO.getList();
        String keyGenerationExternalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : keyGenerationlist) {
            keyGenerationExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(keyGenerationExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending request failed for User Admin");
        this.restAPIStore.deleteApplication(applicationIDSecond);
        this.restAPIPublisher.deleteAPI(apiIdSecond);
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(subscriptionCreationExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for Subscription Creation");
        response = this.restAPIAdmin.getWorkflowByExternalWorkflowReference(keyGenerationExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)500, (String)"Clean up pending task process is failed for Application Key generation");
    }

    @Test(groups={"wso2.am"}, description="pending tasks workflow process check", dependsOnMethods={"testCleanUpWorkflowProcess"})
    public void testPendingTaskWorkflowProcess() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("AppApp", "Testing application", "Unlimited", ApplicationDTO.TokenTypeEnum.OAUTH);
        String applicationIDNew = applicationResponse.getData();
        String workflowType = null;
        HttpResponse response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        String jsonResponse = response.getData();
        Gson gsonResponse = new Gson();
        WorkflowListDTO workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        int count = workflowListDTO.getCount();
        Assert.assertEquals((int)count, (int)1, (String)"Correct Number of Workflow requests never received");
        List firstlist = new ArrayList();
        firstlist = workflowListDTO.getList();
        String firstExternalWorkflowRef = "";
        for (WorkflowInfoDTO workflowinfo : firstlist) {
            firstExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        String apiName = "WorkflowCheckCount";
        String apiVersion = "1.0.0";
        String apiContext = "workflowCheckCount";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(url));
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.USER_SMITH);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        String apiIdFirst = apiResponse.getData();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse lifeCycleChangeResponse = this.restAPIPublisher.changeAPILifeCycleStatus(apiIdFirst, APILifeCycleAction.PUBLISH.getAction(), null);
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        jsonResponse = response.getData();
        workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        count = workflowListDTO.getCount();
        Assert.assertEquals((int)count, (int)2, (String)"Correct Number of Workflow requests never received");
        List secondlist = new ArrayList();
        secondlist = workflowListDTO.getList();
        String secondExternalWorkflowRef = "";
        response = this.restAPIAdmin.updateWorkflowStatus(firstExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow request can only be viewed for the admin");
        for (WorkflowInfoDTO workflowinfo : secondlist) {
            secondExternalWorkflowRef = workflowinfo.getReferenceId();
        }
        response = this.restAPIAdmin.updateWorkflowStatus(secondExternalWorkflowRef);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Workflow request can only be viewed for the admin");
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse SubscribeResponse = this.restAPIStore.createSubscription(apiIdFirst, applicationIDNew, "Unlimited");
        this.subscriptionId = SubscribeResponse.getData();
        Assert.assertEquals((int)SubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of old API version request not successful");
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        jsonResponse = response.getData();
        workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        count = workflowListDTO.getCount();
        Assert.assertEquals((int)count, (int)1, (String)"Correct Number of Workflow requests never received");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(applicationIDNew, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        jsonResponse = response.getData();
        workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        count = workflowListDTO.getCount();
        Assert.assertEquals((int)count, (int)2, (String)"Correct Number of Workflow requests never received");
        this.restAPIStore.deleteApplication(applicationIDNew);
        this.restAPIPublisher.deleteAPI(apiIdFirst);
        response = this.restAPIAdmin.getWorkflows(workflowType);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Get Workflow Pending requests failed for User Admin");
        jsonResponse = response.getData();
        workflowListDTO = (WorkflowListDTO)gsonResponse.fromJson(jsonResponse, WorkflowListDTO.class);
        count = workflowListDTO.getCount();
        Assert.assertEquals((int)count, (int)0, (String)"Correct Number of Workflow requests never received");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.userManagementClient.deleteUser(this.USER_SMITH);
        this.userManagementClient.deleteUser(this.USER_ADMIN);
        this.userManagementClient.deleteUser("JaneDoe");
        this.resourceAdminServiceClient.updateTextContent("/_system/governance/apimgt/applicationdata/workflow-extensions.xml", this.originalWFExtentionsXML);
        super.cleanUp();
    }
}

