/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIMANAGER5337SubscriptionRetainTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER5337SubscriptionRetainTestCase.class);
    private String apiId;
    private String applicationID;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.am"}, description="testing error responses")
    public void testAPIErrorResponse() throws Exception {
        String apiName = "SubscriptionCheckAPI";
        String apiVersion = "1.0.0";
        String apiContext = "subscriptionCheck";
        String endpointUrl = this.getAPIInvocationURLHttp("response");
        try {
            APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
            apiRequest.setVersion(apiVersion);
            apiRequest.setTiersCollection("Unlimited");
            apiRequest.setTier("Unlimited");
            HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
            this.apiId = apiResponse.getData();
            this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
            this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
            HttpResponse applicationResponse = this.restAPIStore.createApplication("subscriptionCheckApp1", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
            this.applicationID = applicationResponse.getData();
            HttpResponse response = this.restAPIStore.createSubscription(this.apiId, this.applicationID, "Unlimited");
            this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, "Demote to Created", null);
            Thread.sleep(1000L);
            SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationID);
            Gson g = new Gson();
            String subscriptionJsonString = g.toJson((Object)subsDTO, SubscriptionListDTO.class);
            Assert.assertEquals((boolean)subscriptionJsonString.contains("SubscriptionCheckAPI"), (boolean)true, (String)"Subscription of the SubscriptionCheckAPI has been removed.");
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

