/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import org.codehaus.plexus.util.StringUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIPublishingAndVisibilityInStoreTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "APIPublishingAndVisibilityInStoreTest";
    private final String API_CONTEXT = "APIPublishingAndVisibilityInStore";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String apiId;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
    }

    @Test(groups={"wso2.am"}, description="Create a API and  check its availability in Publisher.")
    public void testAvailabilityOfAPIInPublisher() throws APIManagerIntegrationTestException, MalformedURLException, org.wso2.am.integration.clients.publisher.api.ApiException {
        APIRequest apiRequest = new APIRequest("APIPublishingAndVisibilityInStoreTest", "APIPublishingAndVisibilityInStore", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + this.apiId));
        HttpResponse apiDto = this.restAPIPublisher.getAPI(apiResponse.getData());
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDto.getData()), (String)("Added Api is not available in APi Publisher. API ID " + this.apiId));
    }

    @Test(groups={"wso2.am"}, description="Check the visibility of API in Store before the API publish. it should not be available in store.", dependsOnMethods={"testAvailabilityOfAPIInPublisher"})
    public void testVisibilityOfAPIInStoreBeforePublishing() throws Exception {
        try {
            APIDTO apiDto = this.restAPIStore.getAPI(this.apiId);
            Assert.assertFalse((boolean)StringUtils.isNotEmpty((String)apiDto.getId()), (String)("Api is visible in API Store before publish. API ID" + this.apiId));
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)403, (String)("Api is visible in API Store before publish. API ID" + this.apiId));
        }
    }

    @Test(groups={"wso2.am"}, description="Test the API publishing action. Response HTTP message should contains API status change from  CREATED to PUBLISHED", dependsOnMethods={"testVisibilityOfAPIInStoreBeforePublishing"})
    public void testAPIPublishing() throws Exception {
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        HttpResponse response = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        Assert.assertEquals((int)response.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.apiId));
        APIDTO apiDto = this.restAPIStore.getAPI(this.apiId);
        Assert.assertFalse((boolean)StringUtils.isEmpty((String)apiDto.getId()), (String)("Api is not visible in API Store. API ID" + this.apiId));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

