/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIResourceWithSpecialCharactersInvocation
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "SpecialCharacterResourceNameAPI";
    private static final String API_CONTEXT = "specialCharacterResourceNameAPI";
    private static final String API_END_POINT_POSTFIX_URL = "specialCRN/";
    private static final String API_DESCRIPTION = "This is a test API created by API manager integration test";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String RESPONSE_GET = "<response><value>Received GET /special,-._~resource</value></response>";
    private static final String API_ENDPOINT_RESOURCE = "/special,-._~resource";
    private String apiEndPointUrl;
    private String providerName;
    private String apiId;
    private String applicationId;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.getGatewayURLNhttp() + API_END_POINT_POSTFIX_URL;
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of GET resource which has special characters in its name")
    public void testInvokeGETResourceWithSpecialCharacters() throws Exception {
        String APPLICATION_NAME = "SpecialCharacterResourceNameAPP";
        HttpResponse applicationResponse = this.restAPIStore.createApplication(APPLICATION_NAME, " Description", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, API_NAME, API_VERSION_1_0_0);
        APIRequest apiRequest = new APIRequest(API_NAME, API_CONTEXT, new URL(this.apiEndPointUrl));
        apiRequest.setVersion(API_VERSION_1_0_0);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget(API_ENDPOINT_RESOURCE);
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        apiRequest.setOperationsDTOS(operationsDTOS);
        apiRequest.setVisibility("public");
        apiRequest.setDescription(API_DESCRIPTION);
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        HttpResponse httpResponseGet = HttpRequestUtil.doGet((String)(this.getGatewayURLNhttp() + API_CONTEXT + "/" + API_VERSION_1_0_0 + API_ENDPOINT_RESOURCE), requestHeaders);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for /special,-._~resource");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains(RESPONSE_GET), (String)("Response Data not match for GET request for/special,-._~resource Expected value :\"<response><value>Received GET /special,-._~resource</value></response>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

