/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.internal.ApiException;
import org.wso2.am.integration.clients.internal.api.dto.RevokedJWTDTO;
import org.wso2.am.integration.clients.internal.api.dto.RevokedJWTListDTO;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIKeyDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.http.HttpRequestUtil;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.utils.exceptions.AutomationUtilException;
import org.wso2.carbon.um.ws.api.stub.ClaimValue;
import org.wso2.carbon.um.ws.api.stub.RemoteUserStoreManagerServiceUserStoreExceptionException;
import org.wso2.carbon.user.core.UserStoreException;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APISecurityTestCase
extends APIManagerLifecycleBaseTest {
    private final String mutualSSLOnlyAPIName = "mutualsslOnlyAPI";
    private final String mutualSSLWithOAuthAPI = "mutualSSLWithOAuthAPI";
    private final String mutualSSLandOauthMandatoryAPI = "mutualSSLandOAuthMandatoryAPI";
    private final String apiKeySecuredAPI = "apiKeySecuredAPI";
    private final String mutualSSLOnlyAPIContext = "mutualsslOnlyAPI";
    private final String mutualSSLWithOAuthAPIContext = "mutualSSLWithOAuthAPI";
    private final String mutualSSLandOAuthMandatoryAPIContext = "mutualSSLandOAuthMandatoryAPI";
    private final String apiKeySecuredAPIContext = "apiKeySecuredAPI";
    private final String basicAuthSecuredAPI = "BasicAuthSecuredAPI";
    private final String basicAuthSecuredAPIContext = "BasicAuthSecuredAPI";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase";
    private String accessToken;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String applicationId;
    private String consumerKey;
    private String consumerSecret;
    private String apiId1;
    private String apiId2;
    private String apiId3;
    private String apiId4;
    private String apiId5;
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    String[] users = new String[]{"apisecUser", "apisecUser2@wso2.com", "apisecUser2@abc.com"};
    String endUserPassword = "password@123";

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private void createUser() throws RemoteException, RemoteUserStoreManagerServiceUserStoreExceptionException, UserStoreException {
        for (String user : this.users) {
            this.remoteUserStoreManagerServiceClient.addUser(user, this.endUserPassword, new String[0], new ClaimValue[0], "default", false);
        }
    }

    @Factory(dataProvider="userModeDataProvider")
    public APISecurityTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException, IOException, org.wso2.am.integration.clients.publisher.api.ApiException, org.wso2.am.integration.clients.store.api.ApiException, XPathExpressionException, AutomationUtilException, InterruptedException, JSONException, RemoteUserStoreManagerServiceUserStoreExceptionException, UserStoreException {
        super.init(this.userMode);
        this.createUser();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        APIRequest apiRequest1 = new APIRequest("mutualsslOnlyAPI", "mutualsslOnlyAPI", new URL(this.apiEndPointUrl));
        apiRequest1.setVersion("1.0.0");
        apiRequest1.setTiersCollection("Unlimited");
        apiRequest1.setTier("Unlimited");
        apiRequest1.setTags("testTag1, testTag2, testTag3");
        apiRequest1.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest1.setProvider(this.user.getUserName());
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/customers/{id}");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        apiRequest1.setOperationsDTOS(operationsDTOS);
        ArrayList<String> securitySchemes = new ArrayList<String>();
        securitySchemes.add("mutualssl");
        securitySchemes.add("mutualssl_mandatory");
        apiRequest1.setSecurityScheme(securitySchemes);
        apiRequest1.setDefault_version("true");
        apiRequest1.setHttps_checked("https");
        apiRequest1.setHttp_checked(null);
        apiRequest1.setDefault_version_checked("true");
        HttpResponse response1 = this.restAPIPublisher.addAPI(apiRequest1);
        this.apiId1 = response1.getData();
        String certOne = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        this.restAPIPublisher.uploadCertificate(new File(certOne), "example", this.apiId1, "Unlimited");
        APIRequest apiRequest2 = new APIRequest("mutualSSLWithOAuthAPI", "mutualSSLWithOAuthAPI", new URL(this.apiEndPointUrl));
        apiRequest2.setVersion("1.0.0");
        apiRequest2.setProvider(this.user.getUserName());
        apiRequest2.setTiersCollection("Unlimited");
        apiRequest2.setTier("Unlimited");
        apiRequest2.setTags("testTag1, testTag2, testTag3");
        apiRequest2.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest2.setOperationsDTOS(operationsDTOS);
        apiRequest2.setDefault_version("true");
        apiRequest2.setHttps_checked("https");
        apiRequest2.setHttp_checked(null);
        apiRequest2.setDefault_version_checked("true");
        ArrayList<String> securitySchemes2 = new ArrayList<String>();
        securitySchemes2.add("mutualssl");
        securitySchemes2.add("oauth2");
        securitySchemes2.add("api_key");
        securitySchemes2.add("oauth_basic_auth_api_key_mandatory");
        apiRequest2.setSecurityScheme(securitySchemes2);
        HttpResponse response2 = this.restAPIPublisher.addAPI(apiRequest2);
        this.apiId2 = response2.getData();
        String certTwo = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        this.restAPIPublisher.uploadCertificate(new File(certTwo), "abcde", this.apiId2, "Unlimited");
        APIRequest apiRequest3 = new APIRequest("mutualSSLandOAuthMandatoryAPI", "mutualSSLandOAuthMandatoryAPI", new URL(this.apiEndPointUrl));
        apiRequest3.setVersion("1.0.0");
        apiRequest3.setTiersCollection("Unlimited");
        apiRequest3.setTier("Unlimited");
        apiRequest3.setTags("testTag1, testTag2, testTag3");
        apiRequest3.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest3.setOperationsDTOS(operationsDTOS);
        apiRequest3.setProvider(this.user.getUserName());
        ArrayList<String> securitySchemes3 = new ArrayList<String>();
        securitySchemes3.add("mutualssl");
        securitySchemes3.add("oauth2");
        securitySchemes3.add("api_key");
        securitySchemes3.add("mutualssl_mandatory");
        securitySchemes3.add("oauth_basic_auth_api_key_mandatory");
        apiRequest3.setSecurityScheme(securitySchemes3);
        apiRequest3.setDefault_version("true");
        apiRequest3.setHttps_checked("https");
        apiRequest3.setHttp_checked(null);
        apiRequest3.setDefault_version_checked("true");
        HttpResponse response3 = this.restAPIPublisher.addAPI(apiRequest3);
        this.apiId3 = response3.getData();
        String certThree = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        this.restAPIPublisher.uploadCertificate(new File(certThree), "abcdef", this.apiId3, "Unlimited");
        APIRequest apiRequest4 = new APIRequest("apiKeySecuredAPI", "apiKeySecuredAPI", new URL(this.apiEndPointUrl));
        apiRequest4.setVersion("1.0.0");
        apiRequest4.setTiersCollection("Unlimited");
        apiRequest4.setTier("Unlimited");
        apiRequest4.setTags("testTag1, testTag2, testTag3");
        apiRequest4.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest4.setOperationsDTOS(operationsDTOS);
        apiRequest4.setDefault_version("true");
        apiRequest4.setHttps_checked("https");
        apiRequest4.setHttp_checked(null);
        apiRequest4.setProvider(this.user.getUserName());
        apiRequest4.setDefault_version_checked("true");
        ArrayList<String> securitySchemes4 = new ArrayList<String>();
        securitySchemes4.add("api_key");
        securitySchemes4.add("oauth_basic_auth_api_key_mandatory");
        apiRequest4.setSecurityScheme(securitySchemes4);
        apiRequest4.setSandbox(this.apiEndPointUrl);
        HttpResponse response4 = this.restAPIPublisher.addAPI(apiRequest4);
        this.apiId4 = response4.getData();
        APIRequest apiRequest5 = new APIRequest("BasicAuthSecuredAPI", "BasicAuthSecuredAPI", new URL(this.apiEndPointUrl));
        apiRequest5.setVersion("1.0.0");
        apiRequest5.setTiersCollection("Unlimited");
        apiRequest5.setTier("Unlimited");
        apiRequest5.setTags("testTag1, testTag2, testTag3");
        apiRequest5.setVisibility(APIDTO.VisibilityEnum.PUBLIC.getValue());
        apiRequest5.setOperationsDTOS(operationsDTOS);
        apiRequest5.setProvider(this.user.getUserName());
        ArrayList<String> securitySchemes5 = new ArrayList<String>();
        securitySchemes5.add("basic_auth");
        securitySchemes5.add("oauth_basic_auth_api_key_mandatory");
        apiRequest5.setSecurityScheme(securitySchemes5);
        apiRequest5.setDefault_version("true");
        apiRequest5.setHttps_checked("https");
        apiRequest5.setHttp_checked(null);
        HttpResponse response5 = this.restAPIPublisher.addAPI(apiRequest5);
        this.apiId5 = response5.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId5, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatusToPublish(this.apiId5, false);
        this.waitForAPIDeploymentSync(apiRequest5.getProvider(), apiRequest5.getName(), apiRequest5.getVersion(), "\"isApiExists\":true");
    }

    @Test(description="This test case tests the behaviour of internal Key token on Created API with authentication types")
    public void testCreateAndDeployRevisionWithInternalKeyTesting() throws JSONException, org.wso2.am.integration.clients.publisher.api.ApiException, XPathExpressionException, APIManagerIntegrationTestException, IOException, org.wso2.am.integration.clients.store.api.ApiException, InterruptedException {
        this.createAPIRevisionAndDeployUsingRest(this.apiId1, this.restAPIPublisher);
        APIDTO api1 = this.restAPIPublisher.getAPIByID(this.apiId1);
        this.waitForAPIDeploymentSync(api1.getProvider(), api1.getName(), api1.getVersion(), "\"isApiExists\":true");
        ApiResponse keyDTOApiResponse1 = this.restAPIPublisher.generateInternalApiKey(this.apiId1);
        Assert.assertEquals((int)keyDTOApiResponse1.getStatusCode(), (int)200);
        HttpResponse httpResponse1 = this.invokeApiWithInternalKey("mutualsslOnlyAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse1.getData()).getApikey());
        Assert.assertEquals((int)httpResponse1.getResponseCode(), (int)200);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId1, APILifeCycleAction.PUBLISH.getAction());
        this.createAPIRevisionAndDeployUsingRest(this.apiId2, this.restAPIPublisher);
        APIDTO api2 = this.restAPIPublisher.getAPIByID(this.apiId2);
        this.waitForAPIDeploymentSync(api2.getProvider(), api2.getName(), api2.getVersion(), "\"isApiExists\":true");
        ApiResponse keyDTOApiResponse2 = this.restAPIPublisher.generateInternalApiKey(this.apiId2);
        HttpResponse httpResponse2 = this.invokeApiWithInternalKey("mutualSSLWithOAuthAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse2.getData()).getApikey());
        Assert.assertEquals((int)httpResponse2.getResponseCode(), (int)200);
        HttpResponse httpResponse3 = this.invokeApiWithInternalKey("mutualSSLWithOAuthAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse1.getData()).getApikey());
        Assert.assertEquals((int)httpResponse3.getResponseCode(), (int)403);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId2, APILifeCycleAction.PUBLISH.getAction());
        httpResponse2 = this.invokeApiWithInternalKey("mutualSSLWithOAuthAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse2.getData()).getApikey());
        Assert.assertEquals((int)httpResponse2.getResponseCode(), (int)200);
        this.createAPIRevisionAndDeployUsingRest(this.apiId3, this.restAPIPublisher);
        APIDTO api3 = this.restAPIPublisher.getAPIByID(this.apiId3);
        this.waitForAPIDeploymentSync(api3.getProvider(), api3.getName(), api3.getVersion(), "\"isApiExists\":true");
        ApiResponse keyDTOApiResponse3 = this.restAPIPublisher.generateInternalApiKey(this.apiId3);
        HttpResponse httpResponse4 = this.invokeApiWithInternalKey("mutualSSLandOAuthMandatoryAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse3.getData()).getApikey());
        Assert.assertEquals((int)httpResponse4.getResponseCode(), (int)200);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId3, APILifeCycleAction.PUBLISH.getAction());
        this.createAPIRevisionAndDeployUsingRest(this.apiId4, this.restAPIPublisher);
        APIDTO api4 = this.restAPIPublisher.getAPIByID(this.apiId4);
        this.waitForAPIDeploymentSync(api4.getProvider(), api4.getName(), api4.getVersion(), "\"isApiExists\":true");
        ApiResponse keyDTOApiResponse4 = this.restAPIPublisher.generateInternalApiKey(this.apiId3);
        HttpResponse httpResponse5 = this.invokeApiWithInternalKey("mutualSSLandOAuthMandatoryAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse4.getData()).getApikey());
        Assert.assertEquals((int)httpResponse5.getResponseCode(), (int)200);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId4, APILifeCycleAction.PUBLISH.getAction());
        HttpResponse applicationResponse = this.restAPIStore.createApplication("AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        this.restAPIStore.subscribeToAPI(this.apiId3, this.applicationId, "Unlimited");
        this.restAPIStore.subscribeToAPI(this.apiId2, this.applicationId, "Unlimited");
        this.restAPIStore.subscribeToAPI(this.apiId4, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("password");
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        HttpResponse httpResponseAfterPublish = this.invokeApiWithInternalKey("mutualsslOnlyAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse1.getData()).getApikey());
        Assert.assertEquals((int)httpResponseAfterPublish.getResponseCode(), (int)200);
        Thread.sleep(120000L);
    }

    private HttpResponse invokeApiWithInternalKey(String context, String version, String resource, String internalKey) throws XPathExpressionException, IOException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Internal-Key", internalKey);
        return HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps(context, version) + resource), requestHeaders);
    }

    @Test(description="This test case tests the behaviour of APIs that are protected with mutual SSL and OAuth2 when the client certificate is not presented but OAuth2 token is presented.", dependsOnMethods={"testCreateAndDeployRevisionWithInternalKeyTesting"})
    public void testCreateAndPublishAPIWithOAuth2() throws XPathExpressionException, IOException, JSONException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI", "1.0.0") + "/customers/123"), requestHeaders);
        JSONObject response = new JSONObject(apiResponse.getData());
        Assert.assertEquals((String)response.getString("code"), (String)"900901", (String)"API invocation succeeded with the access token without need for mutual ssl");
        apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API invocation failed for a test case with valid access token when the API is protected with both mutual sso and oauth2");
    }

    @Test(description="Testing the invocation with Basic Auth for Oauth2 Only API", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithBasicAuthForOauthOnlyAPINegative() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Basic abcce");
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithApiKeys() throws Exception {
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, null, null);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("apikey", apiKeyDTO.getApikey());
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("apiKeySecuredAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(description="Testing the invocation with Basic Auth for APIKey Only API", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithBasicAuthFoAPIKeyNegative() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Basic abcce");
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("apiKeySecuredAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Invoke mutual SSL only API with not supported certificate", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLOnlyAPINegative() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualsslOnlyAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401);
    }

    @Test(description="This method test to validate how application security mandatory and mutual ssl optional api behaviour in success scenario", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatory() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @Test(description="Test with no application security header with valid cert", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatoryNegative1() throws IOException, XPathExpressionException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual authentication success for oauth mandatory scenario");
    }

    @Test(description="This method test to validate how application security mandatory and mutual ssl optional api behaviour in success scenario", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatoryNegative2() throws IOException, XPathExpressionException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "test.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Mutual authentication success for oauth mandatory scenario");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)200, (String)"Mutual authentication success for oauth mandatory scenario");
    }

    @Test(description="This method test to validate how application security mandatory and mutual ssl optional api behaviour in success scenario", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLWithOauthMandatoryNegative3() throws IOException, XPathExpressionException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + UUID.randomUUID().toString());
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual authentication success for oauth mandatory scenario");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual authentication success for oauth mandatory scenario");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLMandatory() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has not succeed");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)200, (String)"Mutual SSL Authentication has not succeed");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLMandatoryNeagative1() throws IOException, XPathExpressionException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException, UnrecoverableKeyException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doMutulSSLGet((String)(this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "new-keystore.jks"), (String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLMandatoryNegative2() throws IOException, XPathExpressionException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @Test(description="API invocation with mutual ssl and oauth mandatory", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testAPIInvocationWithMutualSSLHeader() throws IOException, XPathExpressionException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        requestHeaders.put("X-WSO2-CLIENT-CERTIFICATE", this.generateBase64EncodedCertificate());
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI", "1.0.0") + "/customers/123"), requestHeaders);
        HttpResponse defaultResponse = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLandOAuthMandatoryAPI") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
        Assert.assertEquals((int)defaultResponse.getResponseCode(), (int)401, (String)"Mutual SSL Authentication has succeeded for a different certificate");
    }

    @Test(description="Testing the invocation with API Keys having IP restriction", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithApiKeysWithIPCondition() throws Exception {
        String permittedIP = "152.23.5.6, 192.168.1.2/24, 2001:c00::/23";
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, permittedIP, null);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        Map<String, String> requestHeaders1 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), "152.23.5.6", null);
        HttpResponse response1 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders1);
        Assert.assertEquals((int)response1.getResponseCode(), (int)200);
        Map<String, String> requestHeaders2 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), "192.168.1.6", null);
        HttpResponse response2 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders2);
        Assert.assertEquals((int)response2.getResponseCode(), (int)200);
        Map<String, String> requestHeaders3 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), "192.168.5.6", null);
        HttpResponse response3 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders3);
        Assert.assertEquals((int)response3.getResponseCode(), (int)403);
        Map<String, String> requestHeaders4 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), "2001:c00:0:0:0:0:c:4", null);
        HttpResponse response4 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders4);
        Assert.assertEquals((int)response4.getResponseCode(), (int)200);
        Map<String, String> requestHeaders5 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), "2061:c00:0:0:0:0:0:0", null);
        HttpResponse response5 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders5);
        Assert.assertEquals((int)response5.getResponseCode(), (int)403);
    }

    @Test(description="Testing the invocation with API Keys having Http Referer restriction", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithApiKeysWithRefererCondition() throws Exception {
        String permittedReferer = "www.abc.com/path, sub.cds.com/*, *.gef.com/*";
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, null, permittedReferer);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        Map<String, String> requestHeaders1 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), null, "www.abc.com/path");
        HttpResponse response1 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders1);
        Assert.assertEquals((int)response1.getResponseCode(), (int)200);
        Map<String, String> requestHeaders2 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), null, "www.abc.com/path2");
        HttpResponse response2 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders2);
        Assert.assertEquals((int)response2.getResponseCode(), (int)403);
        Map<String, String> requestHeaders3 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), null, "sub.cds.com/path1/path2");
        HttpResponse response3 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders3);
        Assert.assertEquals((int)response3.getResponseCode(), (int)200);
        Map<String, String> requestHeaders4 = this.createRequestHeadersForAPIKey(apiKeyDTO.getApikey(), null, "example.gef.com/path1");
        HttpResponse response4 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders4);
        Assert.assertEquals((int)response4.getResponseCode(), (int)200);
    }

    @Test(description="Testing the invocation of API Secured only with API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithApiKeysOnly() throws Exception {
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO1 = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, null, null);
        Assert.assertNotNull((Object)apiKeyDTO1, (String)"API Key generation failed");
        Map<String, String> requestHeaders1 = this.createRequestHeadersForAPIKey(apiKeyDTO1.getApikey(), null, null);
        HttpResponse response1 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("apiKeySecuredAPI", "1.0.0") + "/customers/123"), requestHeaders1);
        Assert.assertEquals((int)response1.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api with production endpoint");
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO2 = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX.toString(), -1, null, null);
        Assert.assertNotNull((Object)apiKeyDTO2, (String)"API Key generation failed");
        Map<String, String> requestHeaders2 = this.createRequestHeadersForAPIKey(apiKeyDTO1.getApikey(), null, null);
        HttpResponse response2 = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("apiKeySecuredAPI", "1.0.0") + "/customers/123"), requestHeaders2);
        Assert.assertEquals((int)response2.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api with sandbox endpoint");
        Assert.assertTrue((boolean)response2.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke with sandbox endpoint Response Data:" + response2.getData() + ". Expected Response Data: " + "<id>123</id><name>John</name></Customer>"));
    }

    private Map<String, String> createRequestHeadersForAPIKey(String apiKey, String ip, String referer) {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("apikey", apiKey);
        if (ip != null) {
            requestHeaders.put("X-Forwarded-For", ip);
        }
        if (referer != null) {
            requestHeaders.put("Referer", referer);
        }
        return requestHeaders;
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvocationWithRevokedApiKeys() throws Exception {
        HttpResponse invocationResponseAfterRevoked;
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, null, null);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        this.restAPIStore.revokeAPIKey(this.applicationId, apiKeyDTO.getApikey());
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("apikey", apiKeyDTO.getApikey());
        requestHeader.put("accept", "text/xml");
        boolean isApiKeyValid = true;
        int counter = 1;
        do {
            Thread.sleep(1000L);
            invocationResponseAfterRevoked = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeader);
            int responseCodeAfterRevoked = invocationResponseAfterRevoked.getResponseCode();
            if (responseCodeAfterRevoked == HTTP_RESPONSE_CODE_UNAUTHORIZED) {
                isApiKeyValid = false;
                continue;
            }
            if (responseCodeAfterRevoked == HTTP_RESPONSE_CODE_OK) {
                isApiKeyValid = true;
                continue;
            }
            throw new APIManagerIntegrationTestException("Unexpected response received when invoking the API. Response received :" + invocationResponseAfterRevoked.getData() + ":" + invocationResponseAfterRevoked.getResponseMessage());
        } while (isApiKeyValid && ++counter < 25);
        Assert.assertFalse((boolean)isApiKeyValid, (String)("API Key revocation failed. API invocation response code is expected to be : " + HTTP_RESPONSE_CODE_UNAUTHORIZED + ", but got " + invocationResponseAfterRevoked.getResponseCode()));
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeApiKeyAsJWTNegative() throws Exception {
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, null, null);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("apikey", this.accessToken);
        requestHeader.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeJWTAsAPIKeyNegative() throws Exception {
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String subsAccessTokenPayload = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.user.getUserName(), (String)this.user.getPassword());
        JSONObject subsAccessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, subsAccessTokenPayload, tokenEndpointURL).getData());
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("apikey", subsAccessTokenGenerationResponse.getString("access_token"));
        requestHeader.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeInternalKeyAsAPIKeyNegative() throws Exception {
        ApiResponse keyDTOApiResponse1 = this.restAPIPublisher.generateInternalApiKey(this.apiId2);
        Assert.assertEquals((int)keyDTOApiResponse1.getStatusCode(), (int)200);
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("apikey", ((APIKeyDTO)keyDTOApiResponse1.getData()).getApikey());
        requestHeader.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeInternalKeyAsJWTNegative() throws Exception {
        ApiResponse keyDTOApiResponse1 = this.restAPIPublisher.generateInternalApiKey(this.apiId2);
        Assert.assertEquals((int)keyDTOApiResponse1.getStatusCode(), (int)200);
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("Authorization", "Bearer " + ((APIKeyDTO)keyDTOApiResponse1.getData()).getApikey());
        requestHeader.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeJWTasInternalKeyNegative() throws Exception {
        HttpResponse response = this.invokeApiWithInternalKey("mutualSSLWithOAuthAPI", "1.0.0", "/customers/123", this.accessToken);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeAPIKeyAsInternalKeyNegative() throws Exception {
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, null, null);
        HttpResponse response = this.invokeApiWithInternalKey("mutualSSLWithOAuthAPI", "1.0.0", "/customers/123", apiKeyDTO.getApikey());
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with Revoked API Keys", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeInternalKeyForBasicAuthOnlyAPI() throws Exception {
        ApiResponse keyDTOApiResponse1 = this.restAPIPublisher.generateInternalApiKey(this.apiId5);
        Assert.assertEquals((int)keyDTOApiResponse1.getStatusCode(), (int)200);
        HttpResponse response = this.invokeApiWithInternalKey("BasicAuthSecuredAPI", "1.0.0", "/customers/123", ((APIKeyDTO)keyDTOApiResponse1.getData()).getApikey());
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @Test(description="Testing the invocation with BasicAuth", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeBasicAuth() throws Exception {
        String user1 = this.users[0];
        HashMap<String, String> requestHeaders1 = new HashMap<String, String>();
        requestHeaders1.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])user1.concat("@").concat(this.user.getUserDomain()).concat(":").concat("randomPassword1").getBytes()));
        HttpResponse response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeaders1);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
        for (String user : this.users) {
            HashMap<String, String> requestHeaders = new HashMap<String, String>();
            requestHeaders.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])user.concat("@").concat(this.user.getUserDomain()).concat(":").concat(this.endUserPassword).getBytes()));
            response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeaders);
            Assert.assertEquals((int)response.getResponseCode(), (int)200);
        }
        HashMap<String, String> requestHeaders2 = new HashMap<String, String>();
        requestHeaders2.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])user1.concat("@").concat(this.user.getUserDomain()).concat(":").concat("randomPassword1").getBytes()));
        response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeaders2);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with BasicAuth Invalid user ", dependsOnMethods={"testInvokeBasicAuth"})
    public void testInvokeBasicAuthInvalidCredentials2() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])"random@".concat(this.user.getUserDomain()).concat(":").concat("randomPassword").getBytes()));
        HttpResponse response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with Oauth Token for BasicAuth api", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeBearerTokenForBasicNegative() throws Exception {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the invocation with APIkey Token for BasicAuth api", dependsOnMethods={"testCreateAndPublishAPIWithOAuth2"})
    public void testInvokeAPIKeyForBasicOauthAPINegative() throws Exception {
        org.wso2.am.integration.clients.store.api.v1.dto.APIKeyDTO apiKeyDTO = this.restAPIStore.generateAPIKeys(this.applicationId, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION.toString(), -1, null, null);
        Assert.assertNotNull((Object)apiKeyDTO, (String)"API Key generation failed");
        HashMap<String, String> requestHeader = new HashMap<String, String>();
        requestHeader.put("apikey", apiKeyDTO.getApikey());
        requestHeader.put("accept", "text/xml");
        HttpResponse response = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeader);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
    }

    @Test(description="Testing the User Token Invocation and Password Reset", dependsOnMethods={"testInvokeBasicAuth"})
    public void testInvokeJWTUserToken() throws XPathExpressionException, IOException, JSONException, APIManagerIntegrationTestException, RemoteUserStoreManagerServiceUserStoreExceptionException, ParseException, InterruptedException, ApiException {
        String user1 = this.users[0];
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String subsAccessTokenPayload = APIMTestCaseUtils.getPayloadForPasswordGrant((String)user1.concat("@").concat(this.user.getUserDomain()), (String)this.endUserPassword);
        JSONObject subsAccessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, subsAccessTokenPayload, tokenEndpointURL).getData());
        String accessToken1 = subsAccessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "application/json");
        requestHeaders.put("Authorization", "Bearer " + accessToken1);
        HttpResponse apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API invocation failed for a test case with valid access token when the API is protected with both mutual sso and oauth2");
        this.remoteUserStoreManagerServiceClient.updateUser(user1, "changeme");
        this.verifyRevokedTokenAvailable(TokenUtils.getJtiOfJwtToken((String)accessToken1));
        Thread.sleep(10000L);
        apiResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("mutualSSLWithOAuthAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_UNAUTHORIZED, (String)"API Invocation pass for Revoked Token");
    }

    @Test(description="Testing the invocation with BasicAuth", dependsOnMethods={"testInvokeJWTUserToken"})
    public void testInvokeBasicAuthAfterCredentialsInvalid() throws Exception {
        String user1 = this.users[0];
        HashMap<String, String> requestHeaders1 = new HashMap<String, String>();
        requestHeaders1.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])user1.concat("@").concat(this.user.getUserDomain()).concat(":").concat(this.endUserPassword).getBytes()));
        HttpResponse response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeaders1);
        Assert.assertEquals((int)response.getResponseCode(), (int)401);
        HashMap<String, String> requestHeaders2 = new HashMap<String, String>();
        requestHeaders2.put("Authorization", "Basic " + Base64.encodeBase64String((byte[])user1.concat("@").concat(this.user.getUserDomain()).concat(":").concat("changeme").getBytes()));
        response = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps("BasicAuthSecuredAPI", "1.0.0") + "/customers/123"), requestHeaders2);
        Assert.assertEquals((int)response.getResponseCode(), (int)200);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId1);
        this.restAPIPublisher.deleteAPI(this.apiId2);
        this.restAPIPublisher.deleteAPI(this.apiId3);
        this.restAPIPublisher.deleteAPI(this.apiId4);
        this.restAPIPublisher.deleteAPI(this.apiId5);
        this.removeUsers();
    }

    public String generateBase64EncodedCertificate() throws IOException {
        String certOne = this.getAMResourceLocation() + File.separator + "lifecycletest" + File.separator + "mutualssl" + File.separator + "example.crt";
        String base64EncodedString = IOUtils.toString((InputStream)new FileInputStream(certOne));
        base64EncodedString = Base64.encodeBase64URLSafeString((byte[])base64EncodedString.getBytes());
        return base64EncodedString;
    }

    private void removeUsers() throws RemoteException, RemoteUserStoreManagerServiceUserStoreExceptionException {
        for (String user : this.users) {
            this.remoteUserStoreManagerServiceClient.removeUser(user);
        }
    }

    private void verifyRevokedTokenAvailable(String alias) throws ApiException, InterruptedException {
        int retryCount = 0;
        RevokedJWTDTO selectedRevokedJWTDTO = null;
        do {
            RevokedJWTListDTO revokedJWTListDTOS = this.restAPIInternal.retrieveRevokedList();
            for (RevokedJWTDTO revokedJWTDTO : revokedJWTListDTOS) {
                if (!alias.equals(revokedJWTDTO.getJwtSignature())) continue;
                selectedRevokedJWTDTO = revokedJWTDTO;
                break;
            }
            if (selectedRevokedJWTDTO != null) break;
            Thread.sleep(5000L);
        } while (++retryCount < 20);
        Assert.assertNotNull(selectedRevokedJWTDTO, (String)"Revoked Token didn't store in database");
    }
}

