/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIListDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIVisibilityWithDirectURLTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APIManagerLifecycleBaseTest.class);
    private final String apiName = "APIVisibilityWithDirectURLTestCaseAPIName";
    private final String APIContext = "APIVisibilityWithDirectURLTestCaseAPIContext";
    private final String tags = "test, EndpointType";
    private final String description = "This is test API create by API manager integration test";
    private final String APIVersion = "1.0.0";
    private String CARBON_SUPER_SUBSCRIBER_USERNAME = "directUrlUser";
    private final char[] CARBON_SUPER_SUBSCRIBER_PASSWORD = "password@123".toCharArray();
    private String CARBON_SUPER_SUBSCRIBER_1_USERNAME = "directUrlUser1";
    private final char[] CARBON_SUPER_SUBSCRIBER_1_PASSWORD = "password@123".toCharArray();
    private String INTERNAL_ROLE_SUBSCRIBER = "directUrlRole";
    private String INTERNAL_ROLE_SUBSCRIBER_1 = "directUrlRole1";
    private final String[] permissions = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
    private APIRequest apiRequest;
    private UserManagementClient userManagementClient;
    private String endpointUrl;
    private String apiID;

    @Factory(dataProvider="userModeDataProvider")
    public APIVisibilityWithDirectURLTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.INTERNAL_ROLE_SUBSCRIBER = "secondary/" + this.INTERNAL_ROLE_SUBSCRIBER;
            this.INTERNAL_ROLE_SUBSCRIBER_1 = "secondary/" + this.INTERNAL_ROLE_SUBSCRIBER_1;
            this.CARBON_SUPER_SUBSCRIBER_USERNAME = "secondary/" + this.CARBON_SUPER_SUBSCRIBER_USERNAME;
            this.CARBON_SUPER_SUBSCRIBER_1_USERNAME = "secondary/" + this.CARBON_SUPER_SUBSCRIBER_1_USERNAME;
        }
        this.userManagementClient.addRole(this.INTERNAL_ROLE_SUBSCRIBER, null, this.permissions);
        this.userManagementClient.addRole(this.INTERNAL_ROLE_SUBSCRIBER_1, null, this.permissions);
        this.userManagementClient.addUser(this.CARBON_SUPER_SUBSCRIBER_USERNAME, String.valueOf(this.CARBON_SUPER_SUBSCRIBER_PASSWORD), new String[]{this.INTERNAL_ROLE_SUBSCRIBER}, null);
        this.userManagementClient.addUser(this.CARBON_SUPER_SUBSCRIBER_1_USERNAME, String.valueOf(this.CARBON_SUPER_SUBSCRIBER_1_PASSWORD), new String[]{this.INTERNAL_ROLE_SUBSCRIBER_1}, null);
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api without login")
    public void testDirectLinkAnonymous() throws Exception {
        String providerName = this.user.getUserName();
        this.apiRequest = new APIRequest("APIVisibilityWithDirectURLTestCaseAPIName", "APIVisibilityWithDirectURLTestCaseAPIContext", new URL(this.endpointUrl));
        this.apiRequest.setTags("test, EndpointType");
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiRequest.setVersion("1.0.0");
        this.apiRequest.setProvider(providerName);
        this.apiRequest.setVisibility("restricted");
        this.apiRequest.setRoles(this.INTERNAL_ROLE_SUBSCRIBER);
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apidto = this.restAPIPublisher.addAPI(this.apiRequest, "v3");
        this.apiID = apidto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(apidto.getId(), "Publish");
        for (int retry = 0; retry < 15; ++retry) {
            List apiStoreAPIIdentifierList = APIMTestCaseUtils.getAPIIdentifierListFromHttpResponse((APIListDTO)this.restAPIStore.getAllAPIs());
            if (APIMTestCaseUtils.isAPIAvailable((APIIdentifier)new APIIdentifier(apidto.getProvider(), apidto.getName(), apidto.getVersion()), (List)apiStoreAPIIdentifierList)) {
                this.log.info((Object)"API 'APITest' is available on store.");
                break;
            }
            this.log.info((Object)"Waiting for API 'APITest' is available on store.");
            Thread.sleep(1000L);
        }
        RestAPIStoreImpl anonymousRestAPIStore = this.getRestAPIStoreForAnonymousUser(this.user.getUserDomain());
        try {
            ApiResponse apiResponse = anonymousRestAPIStore.apIsApi.apisApiIdGetWithHttpInfo(apidto.getId(), this.user.getUserDomain(), null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api with login", dependsOnMethods={"testDirectLinkAnonymous"})
    public void testDirectLink() throws Exception {
        RestAPIStoreImpl apiStore = this.getRestAPIStoreForUser(this.CARBON_SUPER_SUBSCRIBER_USERNAME, String.valueOf(this.CARBON_SUPER_SUBSCRIBER_PASSWORD), this.user.getUserDomain());
        APIDTO apidto = apiStore.getAPI(this.apiID);
        Assert.assertNotNull((Object)apidto);
    }

    @Test(groups={"wso2.am"}, description="Test availability of the api from user without restricted role", dependsOnMethods={"testDirectLink"})
    public void testDirectLinkWithoutRestrictedRoleUser() throws Exception {
        RestAPIStoreImpl apiStore = this.getRestAPIStoreForUser(this.CARBON_SUPER_SUBSCRIBER_1_USERNAME, String.valueOf(this.CARBON_SUPER_SUBSCRIBER_1_PASSWORD), this.user.getUserDomain());
        try {
            ApiResponse apiResponse = apiStore.apIsApi.apisApiIdGetWithHttpInfo(this.apiID, this.user.getUserDomain(), null);
        }
        catch (ApiException e) {
            Assert.assertEquals((int)404, (int)e.getCode());
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        if (this.apiID != null) {
            this.undeployAndDeleteAPIRevisionsUsingRest(this.apiID, this.restAPIPublisher);
            this.restAPIPublisher.deleteAPI(this.apiID);
        }
        this.userManagementClient.deleteRole(this.INTERNAL_ROLE_SUBSCRIBER);
        this.userManagementClient.deleteRole(this.INTERNAL_ROLE_SUBSCRIBER_1);
        this.userManagementClient.deleteUser(this.CARBON_SUPER_SUBSCRIBER_USERNAME);
        this.userManagementClient.deleteUser(this.CARBON_SUPER_SUBSCRIBER_1_USERNAME);
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }
}

