/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfBlockAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "BlockAPITest";
    private final String API_CONTEXT = "BlockAPI";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfBlockAPITestCase";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private Map<String, String> requestHeaders;
    private String apiId;
    private String applicationId;

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public AccessibilityOfBlockAPITestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException {
        super.init(this.userMode);
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        HttpResponse applicationResponse = this.restAPIStore.createApplication("AccessibilityOfBlockAPITestCase", "Test Application AccessibilityOfBlockAPITestCase", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Test invocation of the APi before block")
    public void testInvokeAPIBeforeChangeAPILifecycleToBlock() throws Exception {
        APIRequest apiRequest = new APIRequest("BlockAPITest", "BlockAPI", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "BlockAPITest", "1.0.0", "\"isApiExists\":true");
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke api before block");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response data mismatched when invoke  API  before block Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Change API lifecycle to block", dependsOnMethods={"testInvokeAPIBeforeChangeAPILifecycleToBlock"})
    public void testChangeAPILifecycleToBlock() throws Exception {
        HttpResponse response = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.BLOCK.getAction(), null);
        Assert.assertEquals((int)response.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.apiId));
    }

    @Test(groups={"wso2.am"}, description="Invocation og the APi after block", dependsOnMethods={"testChangeAPILifecycleToBlock"})
    public void testInvokeAPIAfterChangeAPILifecycleToBlock() throws Exception {
        this.waitForAPIDeployment();
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("BlockAPI", "1.0.0") + "/customers/123"), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_SERVICE_UNAVAILABLE, (String)"Response code mismatched when invoke api after block");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("{\"code\":\"700700\",\"type\":\"API blocked\",\"description\":\"This API has been blocked temporarily. Please try again later or contact the system administrators.\"}"), (String)("Response data mismatched when invoke  API  after block Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

