/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "DeprecatedAPITest";
    private final String API_CONTEXT = "DeprecatedAPI";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_END_POINT_METHOD = "/customers/123";
    private final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_VERSION_2_0_0 = "2.0.0";
    private final String APPLICATION_NAME = "AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase";
    private String apiEndPointUrl;
    private String providerName;
    APIIdentifier apiIdentifierAPI1Version1;
    APIIdentifier apiIdentifierAPI1Version2;
    private String apiId;
    private String apiId2;
    private String applicationID;
    private String subscriptionId1;
    private String subscriptionId2;
    private APIDTO apiDto;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws APIManagerIntegrationTestException {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.apiIdentifierAPI1Version1 = new APIIdentifier(this.providerName, "DeprecatedAPITest", "1.0.0");
        this.apiIdentifierAPI1Version2 = new APIIdentifier(this.providerName, "DeprecatedAPITest", "2.0.0");
        HttpResponse applicationResponse = this.restAPIStore.createApplication("AccessibilityOfDeprecatedOldAPIAndPublishedCopyAPITestCase", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationID = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old API version before deprecate the old version")
    public void testSubscribeOldVersionBeforeDeprecate() throws APIManagerIntegrationTestException, MalformedURLException, org.wso2.am.integration.clients.publisher.api.ApiException, JSONException {
        APIRequest apiRequest = new APIRequest("DeprecatedAPITest", "DeprecatedAPI", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setTarget("/customers/{id}");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO);
        apiRequest.setOperationsDTOS(operationsDTOS);
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        APIRequest apiRequest2 = new APIRequest("DeprecatedAPITest", "DeprecatedAPI", new URL(this.apiEndPointUrl));
        apiRequest2.setVersion("2.0.0");
        apiRequest2.setTiersCollection("Unlimited");
        apiRequest2.setTier("Unlimited");
        apiRequest2.setOperationsDTOS(operationsDTOS);
        HttpResponse apiResponse2 = this.restAPIPublisher.addAPI(apiRequest2);
        this.apiId2 = apiResponse2.getData();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.createAPIRevisionAndDeployUsingRest(this.apiId2, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.PUBLISH.getAction(), null);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId2, APILifeCycleAction.PUBLISH.getAction(), null);
        HttpResponse oldVersionSubscribeResponse = this.restAPIStore.createSubscription(this.apiId, this.applicationID, "Unlimited");
        this.subscriptionId1 = oldVersionSubscribeResponse.getData();
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of old API version request not successful");
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of new API version before deprecate the old version", dependsOnMethods={"testSubscribeOldVersionBeforeDeprecate"})
    public void testSubscribeNewVersion() {
        HttpResponse newVersionSubscribeResponse = this.restAPIStore.createSubscription(this.apiId2, this.applicationID, "Unlimited");
        this.subscriptionId2 = newVersionSubscribeResponse.getData();
        Assert.assertEquals((int)newVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Subscribe of old API version request not successful ");
    }

    @Test(groups={"wso2.am"}, description="Test deprecate old api version", dependsOnMethods={"testSubscribeNewVersion"})
    public void testDeprecateOldVersion() throws org.wso2.am.integration.clients.publisher.api.ApiException {
        HttpResponse deprecateAPIResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.apiId, APILifeCycleAction.DEPRECATE.getAction(), null);
        Assert.assertEquals((int)deprecateAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API deprecate Response code is invalid " + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
        HttpResponse lcStateRsponse = this.restAPIPublisher.getLifecycleStatus(this.apiId);
        Assert.assertEquals((String)lcStateRsponse.getData(), (String)APILifeCycleState.DEPRECATED.getState(), (String)("API deprecate status Change is invalid in" + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1) + "Response Data:" + lcStateRsponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in the store after API deprecate.", dependsOnMethods={"testDeprecateOldVersion"})
    public void testVisibilityOfOldAPIInStoreAfterDeprecate() throws APIManagerIntegrationTestException, XPathExpressionException {
        this.waitForAPIDeploymentSync(this.user.getUserName(), this.apiIdentifierAPI1Version1.getApiName(), this.apiIdentifierAPI1Version1.getVersion(), "\"isApiExists\":true");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "DeprecatedAPITest", "2.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Test the visibility of API in the store after API deprecate.", dependsOnMethods={"testVisibilityOfOldAPIInStoreAfterDeprecate"})
    public void testVisibilityOfNewAPIInStore() throws ApiException {
        this.apiDto = this.restAPIStore.getAPI(this.apiId2);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)this.apiDto.getId()), (String)("New API version is not visible in API Store after deprecate the old version." + this.getAPIIdentifierString(this.apiIdentifierAPI1Version2)));
    }

    @Test(groups={"wso2.am"}, description="Test the subscription of deprecated API version.", dependsOnMethods={"testVisibilityOfNewAPIInStore"})
    public void testSubscribeOldVersionAfterDeprecate() {
        HttpResponse oldVersionSubscribeResponse = this.restAPIStore.createSubscription(this.apiId, this.applicationID, "Unlimited");
        Assert.assertEquals((Object)oldVersionSubscribeResponse, null, (String)("Subscribe of old API version  after deprecate success, which should fail." + this.getAPIIdentifierString(this.apiIdentifierAPI1Version1)));
    }

    @Test(groups={"wso2.am"}, description="Test the invocation of both deprecated old and  publish new API versions", dependsOnMethods={"testSubscribeOldVersionAfterDeprecate"})
    public void testAccessibilityOfDeprecateOldAPIAndPublishedCopyAPI() throws Exception {
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("accept", "text/xml");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("DeprecatedAPI", "1.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
        HttpResponse newVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttp("DeprecatedAPI", "2.0.0") + "/customers/123"), requestHeaders);
        Assert.assertEquals((int)newVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched");
        Assert.assertTrue((boolean)newVersionInvokeResponse.getData().contains("<id>123</id><name>John</name></Customer>"), (String)"Response data mismatched");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationID);
        Thread.sleep(2000L);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId2, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.apiId2);
    }
}

