/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APILifeCycleAction;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class AccessibilityOfOldAPIAndCopyAPIWithReSubscriptionTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "CopyAPIWithReSubscriptionTest";
    private static final String API_CONTEXT = "CopyAPIWithReSubscription";
    private static final String API_TAGS = "testTag1, testTag2, testTag3";
    private static final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private static final String API_END_POINT_METHOD = "/customers/123";
    private static final String API_RESPONSE_DATA = "<id>123</id><name>John</name></Customer>";
    private static final String API_VERSION_1_0_0 = "1.0.0";
    private static final String API_VERSION_2_0_0 = "2.0.0";
    private static final String APPLICATION_NAME = "AccessibilityOfOldAPIAndCopyAPIWithReSubscriptionTestCase";
    private static final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private String applicationId;
    private String apiId;
    private String newApiId;
    private String consumerKey;
    private String consumerSecret;
    private APIRequest apiRequest;
    private Map<String, String> requestHeaders;
    private ArrayList<String> grantTypes;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.grantTypes = new ArrayList();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + API_END_POINT_POSTFIX_URL;
        this.providerName = this.user.getUserName();
        this.apiRequest = new APIRequest(API_NAME, API_CONTEXT, new URL(this.apiEndPointUrl));
        this.apiRequest.setVersion(API_VERSION_1_0_0);
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTier("Unlimited");
        this.apiRequest.setProvider(this.providerName);
        this.apiRequest.setTags(API_TAGS);
        this.apiRequest.setDescription(API_DESCRIPTION);
        this.apiId = this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        HttpResponse applicationResponse = this.restAPIStore.createApplication(APPLICATION_NAME, "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Test subscribe of old api version.")
    public void testSubscriptionOfOldAPI() throws APIManagerIntegrationTestException, XPathExpressionException {
        this.waitForAPIDeploymentSync(this.apiRequest.getProvider(), this.apiRequest.getName(), this.apiRequest.getVersion(), "\"isApiExists\":true");
        HttpResponse oldVersionSubscribeResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Unlimited", this.restAPIStore);
        Assert.assertEquals((int)oldVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)oldVersionSubscribeResponse.getData()), (String)("Error in subscribe of old API version" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
    }

    @Test(groups={"wso2.am"}, description="Test publishing of copied API with re-subscription required", dependsOnMethods={"testSubscriptionOfOldAPI"})
    public void testPublishCopiedAPIWithReSubscriptionRequired() throws Exception {
        this.apiRequest.setVersion(API_VERSION_2_0_0);
        HttpResponse newVersionResponse = this.restAPIPublisher.copyAPI(API_VERSION_2_0_0, this.apiId, null);
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response Code Mismatch");
        this.newApiId = newVersionResponse.getData();
        this.createAPIRevisionAndDeployUsingRest(this.newApiId, this.restAPIPublisher);
        String lifecycleChecklist = "Requires re-subscription when publishing the API:true";
        HttpResponse publishAPIResponse = this.restAPIPublisher.changeAPILifeCycleStatus(this.newApiId, APILifeCycleAction.PUBLISH.getAction(), lifecycleChecklist);
        Assert.assertEquals((int)publishAPIResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("API publish Response code is invalid " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)APILifeCycleState.PUBLISHED.getState().equals(publishAPIResponse.getData()), (String)("API status Change is invalid when retire an API :CopyAPIWithReSubscriptionTest with API ID (" + this.apiId + ") Response Code:" + publishAPIResponse.getResponseCode()));
        this.waitForAPIDeploymentSync(this.providerName, API_NAME, API_VERSION_2_0_0, "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Test invocation of old API version  before the new version is subscribed.", dependsOnMethods={"testPublishCopiedAPIWithReSubscriptionRequired"})
    public void testInvokeOldAPIBeforeSubscribeTheNewVersion() throws Exception {
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps(API_CONTEXT, API_VERSION_1_0_0) + API_END_POINT_METHOD), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke old api before subscribe the new version");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains(API_RESPONSE_DATA), (String)("Response data mismatched when invoke old API version before subscribe the new version. Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test invocation of new API version  before the new version is subscribed.This invocation should be failed", dependsOnMethods={"testInvokeOldAPIBeforeSubscribeTheNewVersion"})
    public void testInvokeNewAPIBeforeSubscribeTheNewVersion() throws Exception {
        HttpResponse oldVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps(API_CONTEXT, API_VERSION_2_0_0) + API_END_POINT_METHOD), this.requestHeaders);
        Assert.assertEquals((int)oldVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_FORBIDDEN, (String)"Response code mismatched when invoke new api before subscribe the new version");
        Assert.assertTrue((boolean)oldVersionInvokeResponse.getData().contains("{\"code\":\"900908\",\"message\":\"Resource forbidden \",\"description\":\"User is NOT authorized to access the Resource. API Subscription validation failed.\"}"), (String)("Response data mismatched when invoke new API version before subscribe the new version. Response Data:" + oldVersionInvokeResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test subscribe the new API Version", dependsOnMethods={"testInvokeNewAPIBeforeSubscribeTheNewVersion"})
    public void testSubscribeTheNewVersion() throws Exception {
        HttpResponse newVersionSubscribeResponse = this.subscribeToAPIUsingRest(this.newApiId, this.applicationId, "Unlimited", this.restAPIStore);
        Assert.assertEquals((int)newVersionSubscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of New API version  when re-subscription required not successful. Invalid Response Code " + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)newVersionSubscribeResponse.getData()), (String)("Error in subscribe of old API version" + this.getAPIIdentifierStringFromAPIRequest(this.apiRequest)));
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String subsAccessTokenPayload = APIMTestCaseUtils.getPayloadForPasswordGrant((String)this.user.getUserName(), (String)this.user.getPassword());
        JSONObject subsAccessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, subsAccessTokenPayload, tokenEndpointURL).getData());
        this.requestHeaders.put("Authorization", "Bearer " + subsAccessTokenGenerationResponse.getString("access_token"));
    }

    @Test(groups={"wso2.am"}, description="Test invocation of new API version  after the new version is subscribed.", dependsOnMethods={"testSubscribeTheNewVersion"})
    public void testInvokeNewAPIAfterSubscribeTheNewVersion() throws Exception {
        HttpResponse newVersionInvokeResponse = HttpRequestUtil.doGet((String)(this.getAPIInvocationURLHttps(API_CONTEXT, API_VERSION_2_0_0) + API_END_POINT_METHOD), this.requestHeaders);
        Assert.assertEquals((int)newVersionInvokeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatched when invoke new api after subscribe the new version");
        Assert.assertTrue((boolean)newVersionInvokeResponse.getData().contains(API_RESPONSE_DATA), (String)("Response data mismatched when invoke new API version after subscribe the new version. Response Data:" + newVersionInvokeResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationId);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.restAPIStore.removeSubscription(subscriptionDTO.getSubscriptionId());
        }
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.newApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.newApiId);
        super.cleanUp();
    }
}

