/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationPolicyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class AddNewMediationAndInvokeAPITestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "AddNewMediationAndInvokeAPITest";
    private final String API_CONTEXT = "AddNewMediationAndInvokeAPI";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_END_POINT_POSTFIX_URL = "xmlapi";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "AddNewMediationAndInvokeAPI";
    private String accessToken;
    private String applicationId;
    private String apiId;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication("AddNewMediationAndInvokeAPI", "Test Application AccessibilityOfBlockAPITestCase", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
    }

    @Test(groups={"wso2.am"}, description="Invoke the API before adding the log mediation")
    public void testAPIInvocationBeforeAddingNewMediation() throws Exception {
        String apiEndPointUrl = this.getAPIInvocationURLHttp("xmlapi", "1.0.0");
        APIRequest apiRequest = new APIRequest("AddNewMediationAndInvokeAPITest", "AddNewMediationAndInvokeAPI", new URL(apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setTags("testTag1, testTag2, testTag3");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddNewMediationAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response.getHeaders("Content-Type")[0].getValue(), (String)"application/xml; charset=UTF-8");
    }

    @Test(groups={"wso2.am"}, description="Invoke the API after adding the log mediation", dependsOnMethods={"testAPIInvocationBeforeAddingNewMediation"})
    public void testAPIInvocationAfterAddingNewMediation() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        MediationPolicyDTO mediationPolicyDTO = new MediationPolicyDTO();
        mediationPolicyDTO.setType("out");
        mediationPolicyDTO.setName("xml_to_json_out_message");
        ArrayList<MediationPolicyDTO> mediationPolicyDTOList = new ArrayList<MediationPolicyDTO>();
        mediationPolicyDTOList.add(mediationPolicyDTO);
        apidto.setMediationPolicies(mediationPolicyDTOList);
        this.restAPIPublisher.updateAPI(apidto);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddNewMediationAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response2 = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response2.getHeaders("Content-Type")[0].getValue(), (String)"application/json; charset=UTF-8");
    }

    @Test(groups={"wso2.am"}, description="IInvoke the API after removing the log mediation", dependsOnMethods={"testAPIInvocationAfterAddingNewMediation"})
    public void testAPIInvocationBeforeRemovingNewMediation() throws Exception {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        ArrayList mediationPolicyDTOList = new ArrayList();
        apidto.setMediationPolicies(mediationPolicyDTOList);
        this.restAPIPublisher.updateAPI(apidto);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        CloseableHttpClient client = HttpClientBuilder.create().setHostnameVerifier((X509HostnameVerifier)new AllowAllHostnameVerifier()).build();
        HttpGet request = new HttpGet(this.getAPIInvocationURLHttp("AddNewMediationAndInvokeAPI", "1.0.0"));
        request.setHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response2 = client.execute((HttpUriRequest)request);
        Assert.assertEquals((int)response2.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request");
        Assert.assertEquals((String)response2.getHeaders("Content-Type")[0].getValue(), (String)"application/xml; charset=UTF-8");
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

