/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class ChangeAuthTypeOfResourceTestCase
extends APIManagerLifecycleBaseTest {
    private final String API_NAME = "ChangeAuthTypeOfResourceTest999";
    private final String API_CONTEXT = "ChangeAuthTypeOfResource999";
    private final String API_TAGS = "testTag1, testTag2, testTag3";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String RESPONSE_GET = "<id>123</id><name>John</name></Customer>";
    private final String API_GET_ENDPOINT_METHOD = "customers/123";
    private String APPLICATION_NAME = "ChangeAuthTypeOfResourceTestCase";
    private String apiId;
    private String applicationId;
    private String apiEndPointUrl;
    private String providerName;
    private String consumerKey;
    private String consumerSecret;
    private HashMap<String, String> requestHeadersGet;
    private ArrayList<String> grantTypes = new ArrayList();
    private APIIdentifier apiIdentifier;

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.providerName = this.user.getUserName();
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/xml");
        this.apiIdentifier = new APIIdentifier(this.providerName, "ChangeAuthTypeOfResourceTest999", "1.0.0");
        HttpResponse applicationResponse = this.restAPIStore.createApplication(this.APPLICATION_NAME, "Test Application", "50PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        this.applicationId = applicationResponse.getData();
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTOS.add(apiOperationsDTO);
        APIRequest apiRequest = new APIRequest("ChangeAuthTypeOfResourceTest999", "ChangeAuthTypeOfResource999", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setProvider(this.providerName);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setOperationsDTOS(apiOperationsDTOS);
        apiRequest.setTags("testTag1, testTag2, testTag3");
        apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        this.waitForAPIDeploymentSync(apiRequest.getProvider(), apiRequest.getName(), apiRequest.getVersion(), "\"isApiExists\":true");
        this.grantTypes.add("client_credentials");
        this.grantTypes.add("password");
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type Application And Application User")
    public void testInvokeResourceWithAuthTypeApplicationAndApplicationUser() throws Exception {
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "3600", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        this.consumerKey = applicationKeyDTO.getConsumerKey();
        this.consumerSecret = applicationKeyDTO.getConsumerSecret();
        Assert.assertNotNull((Object)this.consumerKey, (String)"Consumer Key not found");
        Assert.assertNotNull((Object)this.consumerSecret, (String)"Consumer Secret not found ");
        Assert.assertNotNull((Object)applicationKeyDTO.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeAuthTypeOfResourceTest999", "1.0.0", "\"isApiExists\":true");
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type Application & Application User");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Application & Application User. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type Application", dependsOnMethods={"testInvokeResourceWithAuthTypeApplicationAndApplicationUser"})
    public void testInvokeResourceWithAuthTypeApplication() throws Exception {
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apiDto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTOS.add(apiOperationsDTO);
        apiDto.setOperations(apiOperationsDTOS);
        APIDTO updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)updateAPIHTTPResponse.getId()), (String)("Update API end point URL Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.waitForAPIDeploymentSync(apiDto.getProvider(), apiDto.getName(), apiDto.getVersion(), "\"isApiExists\":true");
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type Application");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Application. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type Application User", dependsOnMethods={"testInvokeResourceWithAuthTypeApplication"})
    public void testInvokeGETResourceWithAuthTypeApplicationUser() throws Exception {
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apiDto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_USER.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTOS.add(apiOperationsDTO);
        apiDto.setOperations(apiOperationsDTOS);
        APIDTO updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)updateAPIHTTPResponse.getId()), (String)("Update API end point URL Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.waitForAPIDeploymentSync(apiDto.getProvider(), apiDto.getName(), apiDto.getVersion(), "\"isApiExists\":true");
        String requestBody = "grant_type=password&username=admin&password=admin&scope=PRODUCTION";
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        HttpResponse firstResponse = this.restAPIStore.generateUserAccessKey(this.consumerKey, this.consumerSecret, requestBody, tokenEndpointURL);
        JSONObject firstAccessTokenGenerationResponse = new JSONObject(firstResponse.getData());
        String accessToken = firstAccessTokenGenerationResponse.getString("access_token");
        this.requestHeadersGet.put("Authorization", "Bearer " + accessToken);
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type Application User");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Application User. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @Test(groups={"wso2.am"}, description="Invoke a resource with auth type None", dependsOnMethods={"testInvokeGETResourceWithAuthTypeApplicationUser"})
    public void testInvokeGETResourceWithAuthTypeNone() throws Exception {
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiId);
        Gson g = new Gson();
        APIDTO apiDto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        ArrayList<APIOperationsDTO> apiOperationsDTOS = new ArrayList<APIOperationsDTO>();
        APIOperationsDTO apiOperationsDTO = new APIOperationsDTO();
        apiOperationsDTO.setVerb("GET");
        apiOperationsDTO.setAuthType(APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType());
        apiOperationsDTO.setThrottlingPolicy("Unlimited");
        apiOperationsDTO.setTarget("/*");
        apiOperationsDTOS.add(apiOperationsDTO);
        apiDto.setOperations(apiOperationsDTOS);
        APIDTO updateAPIHTTPResponse = this.restAPIPublisher.updateAPI(apiDto, this.apiId);
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)updateAPIHTTPResponse.getId()), (String)("Update API end point URL Response Code is invalid." + this.getAPIIdentifierString(this.apiIdentifier)));
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.waitForAPIDeploymentSync(apiDto.getProvider(), apiDto.getName(), apiDto.getVersion(), "\"isApiExists\":true");
        HttpResponse httpResponseGet = HTTPSClientUtils.doGet((String)(this.getAPIInvocationURLHttp("ChangeAuthTypeOfResource999", "1.0.0") + "/" + "customers/123"), this.requestHeadersGet);
        Assert.assertEquals((int)httpResponseGet.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Invocation fails for GET request for auth type None");
        Assert.assertTrue((boolean)httpResponseGet.getData().contains("<id>123</id><name>John</name></Customer>"), (String)("Response Data not match for GET request for auth type Non3. Expected value :\"<id>123</id><name>John</name></Customer>\" not contains in response data:\"" + httpResponseGet.getData() + "\""));
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }
}

