/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.lifecycle;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.ClientAuthenticator;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.ApplicationKeyBean;
import org.wso2.am.integration.test.utils.bean.DCRParamRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.apimgt.api.model.APIIdentifier;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.engine.context.beans.User;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import waffle.util.Base64;

public class ChangeEndPointSecurityPerTypeTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ChangeEndPointSecurityPerTypeTestCase.class);
    private final String API_NAME = "ChangeEndPointSecurityPerTypeTestCase";
    private final String API_CONTEXT = "ChangeEndPointSecurityPerTypeTestCase";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String APPLICATION_NAME = "ChangeEndPointSecurityPerTypeTestCase";
    String endpointUsername = "admin";
    String endpointPassword = "admin123";
    ApplicationKeyBean applicationKeyBeanProduction;
    ApplicationKeyBean applicationKeyBeanSandbox;
    private HashMap<String, String> requestHeadersGet;
    private String providerName;
    private String apiEndPointUrl;
    private String applicationID;
    private String apiID;
    private ApplicationKeyDTO productionApplication;
    private ApplicationKeyDTO sandboxApplication;

    @Factory(dataProvider="userModeDataProvider")
    public ChangeEndPointSecurityPerTypeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        String dcrURL = this.backEndServerUrl.getWebAppURLHttp() + "client-registration/v0.17/register";
        this.apiEndPointUrl = this.getGatewayURLNhttp() + "backendSecurity/1.0.0";
        this.providerName = this.user.getUserName();
        this.requestHeadersGet = new HashMap();
        this.requestHeadersGet.put("accept", "text/plain");
        this.requestHeadersGet.put("Content-Type", "text/plain");
        APIIdentifier apiIdentifier = new APIIdentifier(this.providerName, "ChangeEndPointSecurityPerTypeTestCase", "1.0.0");
        ApplicationDTO dto = this.restAPIStore.addApplicationWithTokenType("ChangeEndPointSecurityPerTypeTestCase", "Unlimited", "", "", ApplicationDTO.TokenTypeEnum.OAUTH.getValue());
        this.applicationID = dto.getApplicationId();
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("ChangeEndPointSecurityPerTypeTestCase", "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", this.providerName, new URL(this.apiEndPointUrl));
        apiCreationRequestBean.setTier("Unlimited");
        apiCreationRequestBean.setTiersCollection("Unlimited");
        apiCreationRequestBean.setProvider(this.user.getUserName());
        apiCreationRequestBean.setEndpointType("basic");
        apiCreationRequestBean.setEpUsername(this.endpointUsername);
        apiCreationRequestBean.setEpPassword(this.endpointPassword);
        apiIdentifier.setTier("Unlimited");
        APIDTO apidto = this.createPublishAndSubscribeToAPI(apiIdentifier, apiCreationRequestBean, this.restAPIPublisher, this.restAPIStore, this.applicationID, "Unlimited");
        this.apiID = apidto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        this.productionApplication = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        this.sandboxApplication = this.restAPIStore.generateKeys(this.applicationID, "3600", null, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, null, grantTypes);
        DCRParamRequest oauthAppProduction = new DCRParamRequest("dummyapp--production", null, null, this.user.getUserName(), "password client_credentials", dcrURL, this.user.getUserName(), this.user.getPassword(), null);
        DCRParamRequest oauthAppSandbox = new DCRParamRequest("dummyapp--sandbox", null, null, this.user.getUserName(), "password client_credentials", dcrURL, this.user.getUserName(), this.user.getPassword(), null);
        this.applicationKeyBeanProduction = ClientAuthenticator.makeDCRRequest((DCRParamRequest)oauthAppProduction);
        this.applicationKeyBeanSandbox = ClientAuthenticator.makeDCRRequest((DCRParamRequest)oauthAppSandbox);
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security")
    public void testUpdateEndpointSecurityForProduction() throws Exception {
        String productionEndpointSecurity = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"admin1234\",\n    \"password\":\"admin123#QA\"\n  }\n  }";
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        Object endpointConfig = apidto.getEndpointConfig();
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)endpointConfig);
        endpointConfigJson.put((Object)"endpoint_security", new JSONParser().parse(productionEndpointSecurity));
        apidto.setEndpointConfig((Object)endpointConfigJson);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        Map updatedEndpointConfig = (Map)updatedAPI.getEndpointConfig();
        Assert.assertNotNull(updatedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)updatedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("production"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("production");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"admin1234".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"admin1234".concat(":").concat("admin123#QA").getBytes())));
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"");
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testUpdateEndpointSecurityForProduction"})
    public void testUpdateEndpointSecurityForSandbox() throws Exception {
        String sandboxEndpointSecurity = "{\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"sandboxusername\",\n    \"password\":\"admin123#QA\"\n  }\n  }";
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        Object endpointConfig = apidto.getEndpointConfig();
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)endpointConfig);
        endpointConfigJson.put((Object)"endpoint_security", new JSONParser().parse(sandboxEndpointSecurity));
        apidto.setEndpointConfig((Object)endpointConfigJson);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        Map updatedEndpointConfig = (Map)updatedAPI.getEndpointConfig();
        Assert.assertNotNull(updatedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)updatedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("sandbox"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"sandboxusername".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"");
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"sandboxusername".concat(":").concat("admin123#QA").getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testUpdateEndpointSecurityForSandbox"})
    public void testUpdateEndpointSecurityForSandboxAndProduction() throws Exception {
        String sandboxEndpointSecurity = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"production1234\",\n    \"password\":\"admin123#dev\"\n  },\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"BASIC\",\n    \"username\":\"sandbox1234\",\n    \"password\":\"admin123#prod\"\n  }\n  }";
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        Object endpointConfig = apidto.getEndpointConfig();
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)endpointConfig);
        endpointConfigJson.put((Object)"endpoint_security", new JSONParser().parse(sandboxEndpointSecurity));
        apidto.setEndpointConfig((Object)endpointConfigJson);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":false");
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        Map updatedEndpointConfig = (Map)updatedAPI.getEndpointConfig();
        Assert.assertNotNull(updatedEndpointConfig.get("endpoint_security"));
        Map endpointSecurity = (Map)updatedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurity.get("sandbox"));
        Map endpointSecurityModel = (Map)endpointSecurity.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)endpointSecurityModel.get("enabled")));
        Assert.assertTrue((boolean)"sandbox1234".equals(endpointSecurityModel.get("username")));
        Assert.assertTrue((boolean)"".equals(endpointSecurityModel.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)endpointSecurityModel.get("type")));
        Assert.assertNotNull(endpointSecurity.get("production"));
        Map productionMap = (Map)endpointSecurity.get("production");
        Assert.assertTrue((boolean)((Boolean)productionMap.get("enabled")));
        Assert.assertTrue((boolean)"production1234".equals(productionMap.get("username")));
        Assert.assertTrue((boolean)"".equals(productionMap.get("password")));
        Assert.assertTrue((boolean)"basic".equalsIgnoreCase((String)productionMap.get("type")));
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"production1234".concat(":").concat("admin123#dev").getBytes())));
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        Assert.assertEquals((String)((String)headers.get("BACKEND_AUTHORIZATION_HEADER")), (String)"Basic".concat(" ").concat(Base64.encode((byte[])"sandbox1234".concat(":").concat("admin123#prod").getBytes())));
    }

    @Test(groups={"wso2.am"}, description="Test Set Endpoint Security", dependsOnMethods={"testUpdateEndpointSecurityForSandboxAndProduction"})
    public void testUpdateEndpointSecurityForOauth() throws Exception {
        String endpointSecurity = "{\n  \"production\":{\n    \"enabled\":true,\n    \"type\":\"OAUTH\",\n    \"tokenUrl\":\"https://localhost:9943/oauth2/token\",\n    \"clientId\":\"" + this.applicationKeyBeanProduction.getConsumerKey() + "\",\n    \"clientSecret\":\"" + this.applicationKeyBeanProduction.getConsumerSecret() + "\",\n    \"customParameters\":{},\n    \"grantType\":\"CLIENT_CREDENTIALS\"\n  },\n  \"sandbox\":{\n    \"enabled\":true,\n    \"type\":\"OAUTH\",\n    \"tokenUrl\":\"https://localhost:9943/oauth2/token\",\n    \"clientId\":\"" + this.applicationKeyBeanSandbox.getConsumerKey() + "\",\n    \"clientSecret\":\"" + this.applicationKeyBeanSandbox.getConsumerSecret() + "\",\n    \"customParameters\":{},\n    \"grantType\":\"CLIENT_CREDENTIALS\"\n  }\n  }";
        HttpResponse response = this.restAPIPublisher.getAPI(this.apiID);
        APIDTO apidto = (APIDTO)new Gson().fromJson(response.getData(), APIDTO.class);
        Object endpointConfig = apidto.getEndpointConfig();
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)endpointConfig);
        endpointConfigJson.put((Object)"endpoint_security", new JSONParser().parse(endpointSecurity));
        apidto.setEndpointConfig((Object)endpointConfigJson);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.apiID);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":false");
        this.createAPIRevisionAndDeployUsingRest(this.apiID, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "ChangeEndPointSecurityPerTypeTestCase", "1.0.0", "\"isApiExists\":true");
        Map updatedEndpointConfig = (Map)updatedAPI.getEndpointConfig();
        Assert.assertNotNull(updatedEndpointConfig.get("endpoint_security"));
        Map endpointSecurityModel = (Map)updatedEndpointConfig.get("endpoint_security");
        Assert.assertNotNull(endpointSecurityModel.get("sandbox"));
        Map sandboxEndpointSecurityModel = (Map)endpointSecurityModel.get("sandbox");
        Assert.assertTrue((boolean)((Boolean)sandboxEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(sandboxEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanSandbox.getConsumerKey());
        Assert.assertEquals(sandboxEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanSandbox.getConsumerSecret());
        Assert.assertNotNull(endpointSecurityModel.get("production"));
        Map productionEndpointSecurityModel = (Map)endpointSecurityModel.get("production");
        Assert.assertTrue((boolean)((Boolean)productionEndpointSecurityModel.get("enabled")));
        Assert.assertEquals(productionEndpointSecurityModel.get("type"), (Object)"OAUTH");
        Assert.assertEquals(productionEndpointSecurityModel.get("tokenUrl"), (Object)"https://localhost:9943/oauth2/token");
        Assert.assertEquals(productionEndpointSecurityModel.get("clientId"), (Object)this.applicationKeyBeanProduction.getConsumerKey());
        Assert.assertEquals(productionEndpointSecurityModel.get("clientSecret"), (Object)this.applicationKeyBeanProduction.getConsumerSecret());
        String prodAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.productionApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + prodAppTokenJti);
        HttpResponse productionResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)productionResponse.getResponseCode(), (int)200);
        Map headers = productionResponse.getHeaders();
        String authorization = (String)headers.get("BACKEND_AUTHORIZATION_HEADER");
        Assert.assertNotNull((Object)authorization);
        Assert.assertTrue((boolean)authorization.contains("Bearer"));
        String backendToken = authorization.replaceFirst("Bearer ", "");
        this.validateIntrospectionResponse(this.user, backendToken, this.applicationKeyBeanProduction.getConsumerKey());
        String sandAppTokenJti = TokenUtils.getJtiOfJwtToken((String)this.sandboxApplication.getToken().getAccessToken());
        this.requestHeadersGet.put("Authorization", "Bearer " + sandAppTokenJti);
        HttpResponse sandboxResponse = HTTPSClientUtils.doGet((String)this.getAPIInvocationURLHttp("ChangeEndPointSecurityPerTypeTestCase", "1.0.0"), this.requestHeadersGet);
        Assert.assertEquals((int)sandboxResponse.getResponseCode(), (int)200);
        headers = sandboxResponse.getHeaders();
        authorization = (String)headers.get("BACKEND_AUTHORIZATION_HEADER");
        Assert.assertNotNull((Object)authorization);
        Assert.assertTrue((boolean)authorization.contains("Bearer"));
        backendToken = authorization.replaceFirst("Bearer ", "");
        this.validateIntrospectionResponse(this.user, backendToken, this.applicationKeyBeanSandbox.getConsumerKey());
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.restAPIStore.removeApplicationById(this.applicationID);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiID, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiID);
        super.cleanUp();
    }

    private void validateIntrospectionResponse(User user, String accessToken, String clientId) throws UnsupportedEncodingException {
        String introspectionUrl = "https://localhost:9943/oauth2/introspect";
        if (!"carbon.super".equals(user.getUserDomain())) {
            introspectionUrl = "https://localhost:9943/t/" + user.getUserDomain() + "/oauth2/introspect";
        }
        CloseableHttpClient closeableHttpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost();
        httpPost.addHeader("Authorization", "Basic " + Base64.encode((byte[])user.getUserName().concat(":").concat(user.getPassword()).getBytes()));
        httpPost.setURI(URI.create(introspectionUrl));
        UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(Arrays.asList(new BasicNameValuePair("token", accessToken)));
        httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
        try (CloseableHttpResponse response = closeableHttpClient.execute((HttpUriRequest)httpPost);){
            Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
            HttpEntity entity = response.getEntity();
            JSONObject jsonPayload = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(entity.getContent()));
            Assert.assertTrue((boolean)((Boolean)jsonPayload.get((Object)"active")));
            Assert.assertNotNull((Object)jsonPayload.get((Object)"client_id"));
            Assert.assertEquals((Object)jsonPayload.get((Object)"client_id"), (Object)clientId);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
    }
}

