/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.revision;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.test.impl.ApiProductTestHelper;
import org.wso2.am.integration.test.impl.ApiTestHelper;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionRequest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIProductRevisionTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIProductRevisionTestCase.class);
    protected static final int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_CREATED = Response.Status.CREATED.getStatusCode();
    private String apiId;
    private String revisionUUID;
    private ApiTestHelper apiTestHelper;
    private ApiProductTestHelper apiProductTestHelper;
    protected static final String TIER_UNLIMITED = "Unlimited";
    protected static final String TIER_GOLD = "Gold";

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiTestHelper = new ApiTestHelper(this.restAPIPublisher, this.restAPIStore, this.getAMResourceLocation(), this.keyManagerContext.getContextTenant().getDomain(), this.keyManagerHTTPSURL, this.user);
        this.apiProductTestHelper = new ApiProductTestHelper(this.restAPIPublisher, this.restAPIStore);
    }

    @Test(groups={"wso2.am"}, description="API Product Revision create test case")
    public void testAddingAPIProductRevision() throws Exception {
        ArrayList<APIDTO> apisToBeUsed = new ArrayList<APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createApiOne(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        apisToBeUsed.add(this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        String provider = UUID.randomUUID().toString();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList(TIER_UNLIMITED, TIER_GOLD);
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.apiId = apiProductDTO.getId();
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID(this.apiId);
        apiRevisionRequest.setDescription("Test Revision 1");
        HttpResponse apiRevisionResponse = this.restAPIPublisher.addAPIProductRevision(apiRevisionRequest);
        Assert.assertEquals((int)apiRevisionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + apiRevisionResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Check the availability of API Product Revision in publisher before deploying.", dependsOnMethods={"testAddingAPIProductRevision"})
    public void testGetAPIProductRevisions() throws Exception {
        HttpResponse apiRevisionsGetResponse = this.restAPIPublisher.getAPIProductRevisions(this.apiId, null);
        Assert.assertEquals((int)apiRevisionsGetResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to retrieve revisions" + apiRevisionsGetResponse.getData()));
        ArrayList<JSONObject> revisionList = new ArrayList<JSONObject>();
        JSONObject jsonObject = new JSONObject(apiRevisionsGetResponse.getData());
        JSONArray arrayList = jsonObject.getJSONArray("list");
        int l = arrayList.length();
        for (int i = 0; i < l; ++i) {
            revisionList.add(arrayList.getJSONObject(i));
        }
        for (JSONObject revision : revisionList) {
            this.revisionUUID = revision.getString("id");
        }
        Assert.assertNotNull((Object)this.revisionUUID, (String)"Unable to retrieve revision UUID");
    }

    @Test(groups={"wso2.am"}, description="Test deploying API Product Revision to gateway environments", dependsOnMethods={"testGetAPIProductRevisions"})
    public void testDeployAPIProductRevisions() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIProductRevision(this.apiId, this.revisionUUID, apiRevisionDeployRequestList);
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to deploy API Product Revisions:" + apiRevisionsDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test UnDeploying API Product Revision to gateway environments", dependsOnMethods={"testDeployAPIProductRevisions"})
    public void testUnDeployAPIProductRevisions() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName("Default");
        apiRevisionUnDeployRequest.setVhost(null);
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        HttpResponse apiRevisionsUnDeployResponse = this.restAPIPublisher.undeployAPIProductRevision(this.apiId, this.revisionUUID, apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionsUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to Undeploy API Product Revisions:" + apiRevisionsUnDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test restoring API Product using created API Product Revision", dependsOnMethods={"testUnDeployAPIProductRevisions"})
    public void testRestoreAPIProductRevision() throws Exception {
        HttpResponse apiRevisionsRestoreResponse = this.restAPIPublisher.restoreAPIRevision(this.apiId, this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsRestoreResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to resotre API Revisions:" + apiRevisionsRestoreResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deleting API using created API Revision", dependsOnMethods={"testRestoreAPIProductRevision"})
    public void testDeleteAPIProductRevision() throws Exception {
        HttpResponse apiRevisionsDeleteResponse = this.restAPIPublisher.deleteAPIProductRevision(this.apiId, this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to delete API Product Revisions:" + apiRevisionsDeleteResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }
}

