/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.api.revision;

import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.plexus.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionDeployUndeployRequest;
import org.wso2.am.integration.test.utils.bean.APIRevisionRequest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIRevisionTestCase
extends APIMIntegrationBaseTest {
    private final Log log = LogFactory.getLog(APIRevisionTestCase.class);
    protected static final int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_CREATED = Response.Status.CREATED.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_UNAUTHORIZED = Response.Status.UNAUTHORIZED.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_NOT_FOUND = Response.Status.NOT_FOUND.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_BAD_REQUEST = Response.Status.BAD_REQUEST.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_SERVICE_UNAVAILABLE = Response.Status.SERVICE_UNAVAILABLE.getStatusCode();
    protected static final int HTTP_RESPONSE_CODE_TOO_MANY_REQUESTS = 429;
    protected static final int HTTP_RESPONSE_CODE_FORBIDDEN = Response.Status.FORBIDDEN.getStatusCode();
    private final String API_NAME = "RevisionTestAPI";
    private final String API_CONTEXT = "revisiontestapi";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String apiId;
    private String revisionUUID;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
    }

    @Test(groups={"wso2.am"}, description="API Revision create test case")
    public void testAddingAPIRevision() throws Exception {
        APIRequest apiRequest = new APIRequest("RevisionTestAPI", "revisiontestapi", new URL(this.apiEndPointUrl));
        apiRequest.setVersion("1.0.0");
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        Assert.assertEquals((int)apiResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + this.apiId));
        HttpResponse apiDto = this.restAPIPublisher.getAPI(apiResponse.getData());
        Assert.assertTrue((boolean)StringUtils.isNotEmpty((String)apiDto.getData()), (String)("Added Api is not available in APi Publisher. API ID " + this.apiId));
        APIRevisionRequest apiRevisionRequest = new APIRevisionRequest();
        apiRevisionRequest.setApiUUID(this.apiId);
        apiRevisionRequest.setDescription("Test Revision 1");
        HttpResponse apiRevisionResponse = this.restAPIPublisher.addAPIRevision(apiRevisionRequest);
        Assert.assertEquals((int)apiRevisionResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Create API Response Code is invalid." + apiRevisionResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Check the availability of API Revision in publisher before deploying.", dependsOnMethods={"testAddingAPIRevision"})
    public void testGetAPIRevisions() throws Exception {
        HttpResponse apiRevisionsGetResponse = this.restAPIPublisher.getAPIRevisions(this.apiId, null);
        Assert.assertEquals((int)apiRevisionsGetResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to retrieve revisions" + apiRevisionsGetResponse.getData()));
        ArrayList<JSONObject> revisionList = new ArrayList<JSONObject>();
        JSONObject jsonObject = new JSONObject(apiRevisionsGetResponse.getData());
        JSONArray arrayList = jsonObject.getJSONArray("list");
        int l = arrayList.length();
        for (int i = 0; i < l; ++i) {
            revisionList.add(arrayList.getJSONObject(i));
        }
        for (JSONObject revision : revisionList) {
            this.revisionUUID = revision.getString("id");
        }
        Assert.assertNotNull((Object)this.revisionUUID, (String)"Unable to retrieve revision UUID");
    }

    @Test(groups={"wso2.am"}, description="Test deploying API Revision to gateway environments", dependsOnMethods={"testGetAPIRevisions"})
    public void testDeployAPIRevisions() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionDeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionDeployRequest.setName("Default");
        apiRevisionDeployRequest.setVhost("localhost");
        apiRevisionDeployRequest.setDisplayOnDevportal(true);
        apiRevisionDeployRequestList.add(apiRevisionDeployRequest);
        HttpResponse apiRevisionsDeployResponse = this.restAPIPublisher.deployAPIRevision(this.apiId, this.revisionUUID, apiRevisionDeployRequestList);
        Assert.assertEquals((int)apiRevisionsDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to deploy API Revisions:" + apiRevisionsDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test UnDeploying API Revision to gateway environments", dependsOnMethods={"testDeployAPIRevisions"})
    public void testUnDeployAPIRevisions() throws Exception {
        ArrayList<APIRevisionDeployUndeployRequest> apiRevisionUndeployRequestList = new ArrayList<APIRevisionDeployUndeployRequest>();
        APIRevisionDeployUndeployRequest apiRevisionUnDeployRequest = new APIRevisionDeployUndeployRequest();
        apiRevisionUnDeployRequest.setName("Default");
        apiRevisionUnDeployRequest.setVhost(null);
        apiRevisionUnDeployRequest.setDisplayOnDevportal(true);
        apiRevisionUndeployRequestList.add(apiRevisionUnDeployRequest);
        HttpResponse apiRevisionsUnDeployResponse = this.restAPIPublisher.undeployAPIRevision(this.apiId, this.revisionUUID, apiRevisionUndeployRequestList);
        Assert.assertEquals((int)apiRevisionsUnDeployResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to Undeploy API Revisions:" + apiRevisionsUnDeployResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test restoring API using created API Revision", dependsOnMethods={"testUnDeployAPIRevisions"})
    public void testRestoreAPIRevision() throws Exception {
        HttpResponse apiRevisionsRestoreResponse = this.restAPIPublisher.restoreAPIRevision(this.apiId, this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsRestoreResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_CREATED, (String)("Unable to resotre API Revisions:" + apiRevisionsRestoreResponse.getData()));
    }

    @Test(groups={"wso2.am"}, description="Test deleting API using created API Revision", dependsOnMethods={"testRestoreAPIRevision"})
    public void testDeleteAPIRevision() throws Exception {
        HttpResponse apiRevisionsDeleteResponse = this.restAPIPublisher.deleteAPIRevision(this.apiId, this.revisionUUID);
        Assert.assertEquals((int)apiRevisionsDeleteResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Unable to delete API Revisions:" + apiRevisionsDeleteResponse.getData()));
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
    }
}

