/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.apiproduct;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.simple.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.ApiResponse;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIProductDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.MediationPolicyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.ApiProductTestHelper;
import org.wso2.am.integration.test.impl.ApiTestHelper;
import org.wso2.am.integration.test.impl.InvocationStatusCodes;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIProductCreationTestCase
extends APIManagerLifecycleBaseTest {
    private static final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private static final String RESTRICTED_SUBSCRIBER = "restricted_user";
    private static final String STANDARD_SUBSCRIBER = "standard_user";
    private static final String PASSWORD = "$3213#@sd";
    private static final String RESTRICTED_ROLE = "restricted_role";
    private static final String SCOPE = "restricted_scope";
    private ApiTestHelper apiTestHelper;
    private ApiProductTestHelper apiProductTestHelper;

    @Factory(dataProvider="userModeDataProvider")
    public APIProductCreationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void initialize() throws Exception {
        super.init(this.userMode);
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.apiTestHelper = new ApiTestHelper(this.restAPIPublisher, this.restAPIStore, this.getAMResourceLocation(), this.keyManagerContext.getContextTenant().getDomain(), this.keyManagerHTTPSURL, this.user);
        this.apiProductTestHelper = new ApiProductTestHelper(this.restAPIPublisher, this.restAPIStore);
        this.userManagementClient.addRole(RESTRICTED_ROLE, null, null);
        if (this.userManagementClient.userNameExists(INTERNAL_ROLE_SUBSCRIBER, RESTRICTED_SUBSCRIBER)) {
            this.userManagementClient.deleteUser(RESTRICTED_SUBSCRIBER);
        }
        this.userManagementClient.addUser(RESTRICTED_SUBSCRIBER, PASSWORD, new String[]{INTERNAL_ROLE_SUBSCRIBER, RESTRICTED_ROLE}, null);
        if (this.userManagementClient.userNameExists(INTERNAL_ROLE_SUBSCRIBER, STANDARD_SUBSCRIBER)) {
            this.userManagementClient.deleteUser(STANDARD_SUBSCRIBER);
        }
        this.userManagementClient.addUser(STANDARD_SUBSCRIBER, PASSWORD, new String[]{INTERNAL_ROLE_SUBSCRIBER}, null);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product")
    public void testCreateAndInvokeApiProduct() throws Exception {
        ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apisToBeUsed = new ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO>();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiOne = this.apiTestHelper.createApiOne(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO apiTwo = this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        apisToBeUsed.add(apiOne);
        apisToBeUsed.add(apiTwo);
        String provider = this.user.getUserName();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes);
        JSONObject endpointConfigJson = new JSONObject();
        endpointConfigJson.putAll((Map)apiOne.getEndpointConfig());
        Map productionEndpoint = (Map)endpointConfigJson.get((Object)"production_endpoints");
        String endpointUrl = this.getGatewayURLNhttp() + "version2";
        productionEndpoint.replace("url", endpointUrl);
        apiOne.setEndpointConfig((Object)endpointConfigJson);
        this.restAPIPublisher.updateAPI(apiOne);
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes);
        ApiResponse apiProductDTOApiResponse = this.restAPIPublisher.updateAPIProduct(apiProductDTO);
        Assert.assertEquals((int)apiProductDTOApiResponse.getStatusCode(), (int)200);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        HashMap<String, String> requestHeadersGet = new HashMap<String, String>();
        requestHeadersGet.put("Authorization", "Bearer " + productionToken);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse httpResponse = this.invokeWithGet(this.getAPIInvocationURLHttp(context.replaceFirst("/", "")) + "/customers", requestHeadersGet);
        Assert.assertEquals((int)httpResponse.getResponseCode(), (int)200);
        Assert.assertEquals((String)((String)httpResponse.getHeaders().get("Version")), (String)"v2");
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on a visibility restricted API")
    public void testCreateAndInvokeApiProductWithVisibilityRestrictedApi() throws Exception {
        ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apisToBeUsed = new ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        apisToBeUsed.add(this.apiTestHelper.createRestrictedAccessControlApi(this.getBackendEndServiceEndPointHttp("wildcard/resources"), RESTRICTED_ROLE));
        String provider = this.user.getUserName();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), STANDARD_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on a scope protected API")
    public void testCreateAndInvokeApiProductWithScopes() throws Exception {
        ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apisToBeUsed = new ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO>();
        apisToBeUsed.add(this.apiTestHelper.createApiTwo(this.getBackendEndServiceEndPointHttp("wildcard/resources")));
        apisToBeUsed.add(this.apiTestHelper.createScopeProtectedApi(this.getBackendEndServiceEndPointHttp("wildcard/resources"), RESTRICTED_ROLE, SCOPE));
        String provider = this.user.getUserName();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        invocationStatusCodes.addScopeSpecificStatusCode(SCOPE, 403);
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.singletonList(SCOPE));
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.singletonList(SCOPE));
        invocationStatusCodes.addScopeSpecificStatusCode(SCOPE, 200);
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on an API with an in mediation sequence")
    public void testCreateAndInvokeApiProductWithInMediationApi() throws Exception {
        ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apisToBeUsed = new ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO>();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO api = this.apiTestHelper.createInMediationSequenceApi(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        apisToBeUsed.add(api);
        String provider = this.user.getUserName();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        String requestBody = "{ \"foo\" : \"bar\" }";
        String expectedResponse = "<jsonObject><foo>bar</foo></jsonObject>";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes, requestBody, expectedResponse, headers);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, requestBody, expectedResponse, headers);
        Assert.assertNotNull((Object)api);
        for (MediationPolicyDTO mediationPolicy : api.getMediationPolicies()) {
            if (!"in".equals(mediationPolicy.getType())) continue;
            mediationPolicy.setId(null);
            mediationPolicy.setName("xml_to_json_in_message");
        }
        this.restAPIPublisher.updateAPI(api);
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, requestBody, expectedResponse, headers);
        ApiResponse apiProductDTOApiResponse = this.restAPIPublisher.updateAPIProduct(apiProductDTO);
        Assert.assertEquals((int)apiProductDTOApiResponse.getStatusCode(), (int)200);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        headers.put("Content-Type", "text/xml");
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, expectedResponse, requestBody, headers);
    }

    @Test(groups={"wso2.am"}, description="Test creation and invocation of API Product which depends on an API with an out mediation sequence")
    public void testCreateAndInvokeApiProductWithOutMediationApi() throws Exception {
        ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO> apisToBeUsed = new ArrayList<org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO>();
        org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO api = this.apiTestHelper.createOutMediationSequenceApi(this.getBackendEndServiceEndPointHttp("wildcard/resources"));
        apisToBeUsed.add(api);
        String provider = this.user.getUserName();
        String name = UUID.randomUUID().toString();
        String context = "/" + UUID.randomUUID().toString();
        List<String> policies = Arrays.asList("Unlimited", "Gold");
        APIProductDTO apiProductDTO = this.apiProductTestHelper.createAPIProductInPublisher(provider, name, context, apisToBeUsed, policies);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.apiProductTestHelper.verfiyApiProductInPublisher(apiProductDTO);
        APIDTO apiDTO = this.apiProductTestHelper.verifyApiProductInPortal(apiProductDTO);
        ApplicationDTO applicationDTO = this.apiTestHelper.verifySubscription(apiDTO, UUID.randomUUID().toString(), "Unlimited");
        List<String> grantTypes = Arrays.asList("client_credentials", "password");
        ApplicationKeyDTO productionAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, new ArrayList(), grantTypes);
        ApplicationKeyDTO sandboxAppKey = this.apiTestHelper.verifyKeyGeneration(applicationDTO, ApplicationKeyGenerateRequestDTO.KeyTypeEnum.SANDBOX, new ArrayList(), grantTypes);
        String requestBody = "<foo>bar</foo>";
        String expectedResponse = "{\"text\":\"<foo>bar</foo>\"}";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        InvocationStatusCodes invocationStatusCodes = new InvocationStatusCodes();
        this.apiTestHelper.verifyInvocation(apiDTO, productionAppKey.getToken().getAccessToken(), sandboxAppKey.getToken().getAccessToken(), invocationStatusCodes, requestBody, expectedResponse, headers);
        String productionToken = this.apiTestHelper.generateTokenPasswordGrant(productionAppKey.getConsumerKey(), productionAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        String sandboxToken = this.apiTestHelper.generateTokenPasswordGrant(sandboxAppKey.getConsumerKey(), sandboxAppKey.getConsumerSecret(), RESTRICTED_SUBSCRIBER, PASSWORD, Collections.emptyList());
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, requestBody, expectedResponse, headers);
        Assert.assertNotNull((Object)api);
        for (MediationPolicyDTO mediationPolicy : api.getMediationPolicies()) {
            if (!"out".equals(mediationPolicy.getType())) continue;
            mediationPolicy.setId(null);
            mediationPolicy.setName("json_to_xml_out_message");
        }
        this.restAPIPublisher.updateAPI(api);
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, requestBody, expectedResponse, headers);
        ApiResponse apiProductDTOApiResponse = this.restAPIPublisher.updateAPIProduct(apiProductDTO);
        Assert.assertEquals((int)apiProductDTOApiResponse.getStatusCode(), (int)200);
        this.createAPIProductRevisionAndDeployUsingRest(apiProductDTO.getId(), this.restAPIPublisher);
        this.waitForAPIDeployment();
        headers.put("Content-Type", "application/json");
        this.apiTestHelper.verifyInvocation(apiDTO, productionToken, sandboxToken, invocationStatusCodes, expectedResponse, requestBody, headers);
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        super.cleanUp();
        this.userManagementClient.deleteUser(RESTRICTED_SUBSCRIBER);
        this.userManagementClient.deleteUser(STANDARD_SUBSCRIBER);
        this.userManagementClient.deleteRole(RESTRICTED_ROLE);
    }

    private org.wso2.carbon.automation.test.utils.http.client.HttpResponse invokeWithGet(String url, Map<String, String> headers) throws IOException {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(url);
        headers.forEach((arg_0, arg_1) -> ((HttpGet)get).addHeader(arg_0, arg_1));
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        InputStream stream = response.getEntity().getContent();
        String content = IOUtils.toString((InputStream)stream);
        HashMap<String, String> outputHeaders = new HashMap<String, String>();
        for (Header header : response.getAllHeaders()) {
            outputHeaders.put(header.getName(), header.getValue());
        }
        return new org.wso2.carbon.automation.test.utils.http.client.HttpResponse(content, response.getStatusLine().getStatusCode(), outputHeaders);
    }
}

