/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.graphql;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIScopeDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLSchemaDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.GraphQLValidationResponseGraphQLInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.ScopeDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.test.utils.token.TokenUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class GraphqlTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(GraphqlTestCase.class);
    private final String GRAPHQL_API_NAME = "CountriesGraphqlAPI";
    private final String API_CONTEXT = "info";
    private final String API_VERSION_1_0_0 = "1.0.0";
    private final String END_POINT_URL = "https://localhost:9943/am-graphQL-sample/api/graphql/";
    private final String RESPONSE_DATA = "[{\"name\":\"Afrikaans\",\"code\":\"af\"},{\"name\":\"Amharic\",\"code\":\"am\"},{\"name\":\"Arabic\",\"code\":\"ar\"},{\"name\":\"Aymara\",\"code\":\"ay\"},{\"name\":\"Azerbaijani\",\"code\":\"az\"},{\"name\":\"Belarusian\",\"code\":\"be\"}]";
    private static final String GRAPHQL_TEST_USER = "graphqluser";
    private static final String GRAPHQL_TEST_USER_PASSWORD = "graphqlUser";
    private static final String GRAPHQL_ROLE = "graphqlrole";
    private static final long WAIT_TIME = 45000L;
    private String schemaDefinition;
    private String graphqlAPIId;
    private String testAppId1;
    private String testAppId2;
    private String testAppId3;
    private String testAppId4;

    @Factory(dataProvider="userModeDataProvider")
    public GraphqlTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.userManagementClient.addUser(GRAPHQL_TEST_USER, GRAPHQL_TEST_USER_PASSWORD, new String[0], null);
        this.userManagementClient.addRole(GRAPHQL_ROLE, new String[]{GRAPHQL_TEST_USER}, new String[0]);
        this.schemaDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "schema.graphql"), (String)"UTF-8");
        File file = this.getTempFileWithContent(this.schemaDefinition);
        GraphQLValidationResponseDTO responseApiDto = this.restAPIPublisher.validateGraphqlSchemaDefinition(file);
        GraphQLValidationResponseGraphQLInfoDTO graphQLInfo = responseApiDto.getGraphQLInfo();
        String arrayToJson = new ObjectMapper().writeValueAsString((Object)graphQLInfo.getOperations());
        JSONArray operations = new JSONArray(arrayToJson);
        ArrayList<String> environment = new ArrayList<String>();
        environment.add("Default");
        ArrayList<String> policies = new ArrayList<String>();
        policies.add("Unlimited");
        JSONObject additionalPropertiesObj = new JSONObject();
        additionalPropertiesObj.put("name", (Object)"CountriesGraphqlAPI");
        additionalPropertiesObj.put("context", (Object)"info");
        additionalPropertiesObj.put("version", (Object)"1.0.0");
        JSONObject url = new JSONObject();
        url.put("url", (Object)"https://localhost:9943/am-graphQL-sample/api/graphql/");
        JSONObject endpointConfig = new JSONObject();
        endpointConfig.put("endpoint_type", (Object)"http");
        endpointConfig.put("sandbox_endpoints", (Object)url);
        endpointConfig.put("production_endpoints", (Object)url);
        additionalPropertiesObj.put("endpointConfig", (Object)endpointConfig);
        additionalPropertiesObj.put("policies", policies);
        additionalPropertiesObj.put("operations", (Object)operations);
        APIDTO apidto = this.restAPIPublisher.importGraphqlSchemaDefinition(file, additionalPropertiesObj.toString());
        this.graphqlAPIId = apidto.getId();
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlAPIId);
        Assert.assertEquals((int)Response.Status.OK.getStatusCode(), (int)createdApiResponse.getResponseCode(), (String)"CountriesGraphqlAPI API creation is failed");
        this.createAPIRevisionAndDeployUsingRest(this.graphqlAPIId, this.restAPIPublisher);
        this.restAPIPublisher.changeAPILifeCycleStatus(this.graphqlAPIId, "Publish");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "CountriesGraphqlAPI", "1.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="test retrieve schemaDefinition at publisher")
    public void testRetrieveSchemaDefinitionAtPublisher() throws Exception {
        GraphQLSchemaDTO schema = this.restAPIPublisher.getGraphqlSchemaDefinition(this.graphqlAPIId);
        Assert.assertEquals((String)schema.getSchemaDefinition(), (String)this.schemaDefinition);
    }

    @Test(groups={"wso2.am"}, description="test update schemaDefinition at publisher", dependsOnMethods={"testRetrieveSchemaDefinitionAtPublisher"})
    public void testUpdateSchemaDefinitionOfAPI() throws Exception {
        String updatedSchemaDefinition = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("graphql" + File.separator + "updatedSchema.graphql"), (String)"UTF-8");
        this.restAPIPublisher.updateGraphqlSchemaDefinition(this.graphqlAPIId, updatedSchemaDefinition);
        GraphQLSchemaDTO schema = this.restAPIPublisher.getGraphqlSchemaDefinition(this.graphqlAPIId);
        Assert.assertEquals((String)schema.getSchemaDefinition(), (String)updatedSchemaDefinition);
        this.createAPIRevisionAndDeployUsingRest(this.graphqlAPIId, this.restAPIPublisher);
    }

    @Test(groups={"wso2.am"}, description="API invocation using JWT App")
    public void testInvokeGraphqlAPIUsingJWTApplication() throws Exception {
        String graphqlJwtAppName = "CountriesJWTAPP";
        this.testAppId1 = this.createGraphqlAppAndSubscribeToAPI(graphqlJwtAppName, "JWT");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId1, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("info", "1.0.0") + "/";
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        JSONObject queryObject = new JSONObject();
        queryObject.put("query", (Object)"{languages{code name}}");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("Content-Type", "application/json");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject.toString());
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        Assert.assertEquals((String)serviceResponse.getData(), (String)"[{\"name\":\"Afrikaans\",\"code\":\"af\"},{\"name\":\"Amharic\",\"code\":\"am\"},{\"name\":\"Arabic\",\"code\":\"ar\"},{\"name\":\"Aymara\",\"code\":\"ay\"},{\"name\":\"Azerbaijani\",\"code\":\"az\"},{\"name\":\"Belarusian\",\"code\":\"be\"}]", (String)"Response data is not as expected");
    }

    @Test(groups={"wso2.am"}, description="API invocation using oauth App")
    public void testInvokeGraphqlAPIUsingOAuthApplication() throws Exception {
        String graphqlOAUTHAppName = "CountriesOauthAPP";
        this.testAppId2 = this.createGraphqlAppAndSubscribeToAPI(graphqlOAUTHAppName, "JWT");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId2, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String invokeURL = this.getAPIInvocationURLHttp("info", "1.0.0") + "/";
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        JSONObject queryObject = new JSONObject();
        queryObject.put("query", (Object)"{languages{code name}}");
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        requestHeaders.put("Content-Type", "application/json");
        HttpResponse serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject.toString());
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Response code is not as expected");
        Assert.assertEquals((String)serviceResponse.getData(), (String)"[{\"name\":\"Afrikaans\",\"code\":\"af\"},{\"name\":\"Amharic\",\"code\":\"am\"},{\"name\":\"Arabic\",\"code\":\"ar\"},{\"name\":\"Aymara\",\"code\":\"ay\"},{\"name\":\"Azerbaijani\",\"code\":\"az\"},{\"name\":\"Belarusian\",\"code\":\"be\"}]", (String)"Response data is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Oauth Scopes", dependsOnMethods={"testInvokeGraphqlAPIUsingOAuthApplication", "testInvokeGraphqlAPIUsingJWTApplication"})
    public void testOperationalLevelOAuthScopesForGraphql() throws Exception {
        ArrayList<String> role = new ArrayList<String>();
        role.add(GRAPHQL_ROLE);
        ScopeDTO scopeObject = new ScopeDTO();
        scopeObject.setName("subscriber");
        scopeObject.setBindings(role);
        APIScopeDTO apiScopeDTO = new APIScopeDTO();
        apiScopeDTO.setScope(scopeObject);
        ArrayList<APIScopeDTO> apiScopeList = new ArrayList<APIScopeDTO>();
        apiScopeList.add(apiScopeDTO);
        HttpResponse createdApiResponse = this.restAPIPublisher.getAPI(this.graphqlAPIId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(createdApiResponse.getData(), APIDTO.class);
        apidto.setScopes(apiScopeList);
        APIDTO updatedAPI = this.restAPIPublisher.updateAPI(apidto, this.graphqlAPIId);
        this.createAPIRevisionAndDeployUsingRest(this.graphqlAPIId, this.restAPIPublisher);
        ArrayList<String> scope = new ArrayList<String>();
        scope.add("subscriber");
        List operations = updatedAPI.getOperations();
        operations.forEach(item -> {
            if (item.getTarget().equals("languages")) {
                item.setScopes((List)scope);
            }
        });
        apidto.operations(operations);
        this.restAPIPublisher.updateAPI(apidto, this.graphqlAPIId);
        this.createAPIRevisionAndDeployUsingRest(this.graphqlAPIId, this.restAPIPublisher);
        this.testAppId3 = this.createGraphqlAppAndSubscribeToAPI("testOperationalLevelOAuthScopesForGraphql", "OAUTH");
        Thread.sleep(10000L);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        grantTypes.add("password");
        JSONObject queryObject = new JSONObject();
        queryObject.put("query", (Object)"{languages{code name}}");
        String invokeURL = this.getAPIInvocationURLHttp("info", "1.0.0") + "/";
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.testAppId3, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        String tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        log.info((Object)("Access Token response without scope: " + accessToken));
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        HttpResponse serviceResponse = null;
        boolean status = false;
        long waitTime = System.currentTimeMillis() + 45000L;
        while (waitTime > System.currentTimeMillis()) {
            serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject.toString());
            if (200 == serviceResponse.getResponseCode()) {
                status = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.assertTrue((boolean)status, (String)"Response code is not as expected");
        String consumerKey = applicationKeyDTO.getConsumerKey();
        String consumerSecret = applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String username = GRAPHQL_TEST_USER;
        if (this.userMode != TestUserMode.SUPER_TENANT_ADMIN) {
            username = username.concat("@").concat(this.user.getUserDomain());
        }
        String requestBody = "grant_type=password&username=" + username + "&password=" + GRAPHQL_TEST_USER_PASSWORD + "&scope=subscriber";
        HttpResponse response = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(response.getData());
        log.info((Object)("Access Token response with scope: " + response.getData()));
        accessToken = accessTokenGenerationResponse.getString("access_token");
        tokenJti = TokenUtils.getJtiOfJwtToken((String)accessToken);
        requestHeaders.put("Authorization", "Bearer " + tokenJti);
        status = false;
        waitTime = System.currentTimeMillis() + 45000L;
        while (waitTime > System.currentTimeMillis()) {
            serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject.toString());
            if (200 == serviceResponse.getResponseCode()) {
                status = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.assertTrue((boolean)status, (String)"Response code is not as expected");
        Assert.assertEquals((String)serviceResponse.getData(), (String)"[{\"name\":\"Afrikaans\",\"code\":\"af\"},{\"name\":\"Amharic\",\"code\":\"am\"},{\"name\":\"Arabic\",\"code\":\"ar\"},{\"name\":\"Aymara\",\"code\":\"ay\"},{\"name\":\"Azerbaijani\",\"code\":\"az\"},{\"name\":\"Belarusian\",\"code\":\"be\"}]", (String)"Response data is not as expected");
    }

    @Test(groups={"wso2.am"}, description="Oauth Scopes")
    public void testOperationalLevelSecurityForGraphql() throws Exception {
        HttpResponse response = this.restAPIPublisher.getAPI(this.graphqlAPIId);
        Gson g = new Gson();
        APIDTO apidto = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        List operations = apidto.getOperations();
        operations.forEach(item -> {
            if (item.getTarget().equals("languages")) {
                item.setAuthType("None");
            }
        });
        apidto.operations(operations);
        this.restAPIPublisher.updateAPI(apidto, this.graphqlAPIId);
        this.createAPIRevisionAndDeployUsingRest(this.graphqlAPIId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.testAppId4 = this.createGraphqlAppAndSubscribeToAPI("CountriesOauthAPPForSecurityCheck", "OAUTH");
        Thread.sleep(10000L);
        this.waitForAPIDeploymentSync(apidto.getProvider(), apidto.getName(), apidto.getVersion(), "\"isApiExists\":true");
        ArrayList<String> grantTypes = new ArrayList<String>();
        grantTypes.add("client_credentials");
        JSONObject queryObject = new JSONObject();
        queryObject.put("query", (Object)"{languages{code name}}");
        String invokeURL = this.getAPIInvocationURLHttp("info", "1.0.0") + "/";
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Content-Type", "application/json");
        String accessToken = "";
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        boolean status = false;
        long waitTime = System.currentTimeMillis() + 45000L;
        HttpResponse serviceResponse = null;
        while (waitTime > System.currentTimeMillis()) {
            serviceResponse = HTTPSClientUtils.doPost((String)invokeURL, requestHeaders, (String)queryObject.toString());
            if (200 == serviceResponse.getResponseCode()) {
                status = true;
                break;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Assert.assertTrue((boolean)status, (String)"Response code is not as expected");
        Assert.assertEquals((String)serviceResponse.getData(), (String)"[{\"name\":\"Afrikaans\",\"code\":\"af\"},{\"name\":\"Amharic\",\"code\":\"am\"},{\"name\":\"Arabic\",\"code\":\"ar\"},{\"name\":\"Aymara\",\"code\":\"ay\"},{\"name\":\"Azerbaijani\",\"code\":\"az\"},{\"name\":\"Belarusian\",\"code\":\"be\"}]", (String)"Response data is not as expected");
    }

    private String createGraphqlAppAndSubscribeToAPI(String appName, String tokenType) throws ApiException {
        ApplicationDTO applicationDTO = this.restAPIStore.addApplicationWithTokenType(appName, "Unlimited", "", "test app for countries API", tokenType);
        String testApiId = applicationDTO.getApplicationId();
        this.restAPIStore.subscribeToAPI(this.graphqlAPIId, testApiId, "Unlimited");
        return testApiId;
    }

    private File getTempFileWithContent(String schema) throws Exception {
        File temp = File.createTempFile("schema", ".graphql");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(schema);
        out.close();
        return temp;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @AfterClass(alwaysRun=true)
    public void cleanUpArtifacts() throws Exception {
        this.userManagementClient.deleteRole(GRAPHQL_ROLE);
        this.userManagementClient.deleteUser(GRAPHQL_TEST_USER);
        this.restAPIStore.deleteApplication(this.testAppId1);
        this.restAPIStore.deleteApplication(this.testAppId2);
        this.restAPIStore.deleteApplication(this.testAppId3);
        this.restAPIStore.deleteApplication(this.testAppId4);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.graphqlAPIId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.graphqlAPIId);
        super.cleanUp();
    }
}

