/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.io.File;
import java.io.IOException;
import org.apache.axiom.om.OMElement;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.test.utils.generic.TestConfigurationProvider;
import org.wso2.am.integration.test.utils.monitor.utils.WireMonitorServer;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.integration.common.admin.client.AuthenticatorClient;

public class APIMANAGER3357ContentTypeTestCase
extends APIMIntegrationBaseTest {
    public WireMonitorServer wireServer;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.wireServer = new WireMonitorServer(8991);
        AuthenticatorClient login = new AuthenticatorClient(this.gatewayContextMgt.getContextUrls().getBackEndUrl());
        String session = login.login("admin", "admin", "localhost");
        String file = "artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "property" + File.separator + "CONTENT_TYPE_TEST.xml";
        OMElement synapseConfig = APIMTestCaseUtils.loadResource((String)file);
        APIMTestCaseUtils.updateSynapseConfiguration((OMElement)synapseConfig, (String)this.gatewayContextMgt.getContextUrls().getBackEndUrl(), (String)session);
        Thread.sleep(5000L);
    }

    @SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
    @Test(groups={"wso2.am"}, description="Test for reading the multipart/form-data Content-Type header in the request")
    public void testTRANSPORT_HEADERSPropertTest() throws Exception {
        this.wireServer.start();
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(this.gatewayUrlsWrk.getWebAppURLNhttp() + "ContentTypeAPI");
        String relativeFilePath = "/artifacts/AM/synapseconfigs/property/CONTENT_TYPE_TEST.xml";
        relativeFilePath = relativeFilePath.replaceAll("[\\\\/]", File.separator);
        String path = TestConfigurationProvider.getResourceLocation() + relativeFilePath;
        File file = new File(path);
        FileBody uploadFilePart = new FileBody(file);
        MultipartEntity reqEntity = new MultipartEntity();
        reqEntity.addPart("file", (ContentBody)uploadFilePart);
        httppost.setEntity((HttpEntity)reqEntity);
        try {
            httpclient.execute((HttpUriRequest)httppost);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String wireResponse = this.wireServer.getCapturedMessage();
        Assert.assertTrue((boolean)wireResponse.contains("Content-Type: multipart/form-data"), (String)"Content-Type header have multipart/form-data value properly");
        Assert.assertFalse((boolean)wireResponse.contains("Content-Type: multipart/form-data; charset=UTF-8; boundary=MIMEBoundary_"), (String)"Content-Type header contains invalid charset and boundary values");
    }

    @AfterClass(alwaysRun=true)
    public void stop() throws Exception {
        this.cleanUp();
    }
}

