/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.header;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class CORSHeadersTestCase
extends APIManagerLifecycleBaseTest {
    private static final String API_NAME = "CorsHeadersTestAPI";
    private static final String APPLICATION_NAME = "CorsHeadersApp";
    private static final String API_CONTEXT = "corsHeadersTestAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String TAGS = "cors, test";
    private static final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE = "*";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_ALLOW_METHODS_HEADER_VALUE = "DELETE,POST,PUT,PATCH,GET";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER_VALUE = "authorization,Access-Control-Allow-Origin,Content-Type,SOAPAction,Authorization";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private String accessToken;
    private String applicationId;
    private String apiId;
    private ArrayList<String> grantTypes;
    private Map<String, String> requestHeaders;
    private String apiEndPointUrl;
    Log log = LogFactory.getLog(CORSHeadersTestCase.class);

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttps() + "jaxrs_basic/services/customers/customerservice/";
        String providerName = this.user.getUserName();
        APIRequest apiRequest = new APIRequest(API_NAME, API_CONTEXT, new URL(this.apiEndPointUrl), true);
        apiRequest.setTags(TAGS);
        apiRequest.setDescription(DESCRIPTION);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setProvider(providerName);
        APIOperationsDTO apiOperationsDTO1 = new APIOperationsDTO();
        apiOperationsDTO1.setVerb("GET");
        apiOperationsDTO1.setTarget("/customers/{id}");
        apiOperationsDTO1.setAuthType("Application & Application User");
        apiOperationsDTO1.setThrottlingPolicy("Unlimited");
        ArrayList<APIOperationsDTO> operationsDTOS = new ArrayList<APIOperationsDTO>();
        operationsDTOS.add(apiOperationsDTO1);
        apiRequest.setOperationsDTOS(operationsDTOS);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationResponse = this.restAPIStore.createApplication(APPLICATION_NAME, "50PerMin", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        this.apiId = this.createPublishAndSubscribeToAPIUsingRest(apiRequest, this.restAPIPublisher, this.restAPIStore, this.applicationId, "Unlimited");
        this.grantTypes = new ArrayList();
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        this.accessToken = applicationKeyDTO.getToken().getAccessToken();
        this.requestHeaders = new HashMap<String, String>();
        this.requestHeaders.put("accept", "text/xml");
        this.requestHeaders.put("Authorization", "Bearer " + applicationKeyDTO.getToken().getAccessToken());
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Checking CORS headers in pre-flight response")
    public void CheckCORSHeadersInPreFlightResponse() throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpOptions option = new HttpOptions(this.getAPIInvocationURLHttps(API_CONTEXT, API_VERSION) + "/customers/123");
        option.addHeader("Origin", "http://localhost");
        option.addHeader("Access-Control-Request-Method", "GET");
        HttpResponse response = httpclient.execute((HttpUriRequest)option);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatch.");
        Header[] responseHeaders = response.getAllHeaders();
        this.log.info((Object)"Response Headers: CheckCORSHeadersInPreFlightResponse");
        for (Header header : responseHeaders) {
            this.log.info((Object)(header.getName() + " : " + header.getValue()));
        }
        Header header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Origin header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE, (String)"Access-Control-Allow-Origin header value mismatch.");
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_METHODS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Methods header is not available in the response.");
        Assert.assertTrue((boolean)ACCESS_CONTROL_ALLOW_METHODS_HEADER_VALUE.contains(header.getValue()), (String)(header.getValue() + " header value mismatch."));
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_HEADERS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Headers header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_HEADERS_HEADER_VALUE, (String)"Access-Control-Allow-Headers header value mismatch.");
        Assert.assertNull((Object)this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER), (String)"Access-Control-Allow-Credentials header is available in the response, but it should not be.");
    }

    @Test(groups={"wso2.am"}, description="Checking CORS headers in response", dependsOnMethods={"CheckCORSHeadersInPreFlightResponse"})
    public void CheckCORSHeadersInResponse() throws Exception {
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttps(API_CONTEXT, API_VERSION) + "/customers/123");
        get.addHeader("Origin", "http://localhost");
        get.addHeader("Authorization", "Bearer " + this.accessToken);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"Response code mismatch.");
        Header[] responseHeaders = response.getAllHeaders();
        this.log.info((Object)"Response Headers: CheckCORSHeadersInResponse");
        for (Header header : responseHeaders) {
            this.log.info((Object)(header.getName() + " : " + header.getValue()));
        }
        Header header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_ORIGIN_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Origin header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_ORIGIN_HEADER_VALUE, (String)"Access-Control-Allow-Origin header value mismatch.");
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_METHODS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Methods header is not available in the response.");
        Assert.assertTrue((boolean)ACCESS_CONTROL_ALLOW_METHODS_HEADER_VALUE.contains(header.getValue()), (String)"Access-Control-Allow-Methods header value mismatch.");
        header = this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_HEADERS_HEADER);
        Assert.assertNotNull((Object)header, (String)"Access-Control-Allow-Headers header is not available in the response.");
        Assert.assertEquals((String)header.getValue(), (String)ACCESS_CONTROL_ALLOW_HEADERS_HEADER_VALUE, (String)"Access-Control-Allow-Headers header value mismatch.");
        Assert.assertNull((Object)this.pickHeader(responseHeaders, ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER), (String)"Access-Control-Allow-Credentials header is available in the response, but it should not be.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        SubscriptionListDTO subsDTO = this.restAPIStore.getAllSubscriptionsOfApplication(this.applicationId);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.restAPIStore.removeSubscription(subscriptionDTO.getSubscriptionId());
        }
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public CORSHeadersTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }
}

