/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.jwt.idp;

import com.google.gson.Gson;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.admin.api.dto.ClaimMappingEntryDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerCertificatesDTO;
import org.wso2.am.integration.clients.admin.api.dto.KeyManagerDTO;
import org.wso2.am.integration.clients.admin.api.dto.TokenValidationDTO;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.ApiResponse;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ErrorDTO;
import org.wso2.am.integration.test.impl.RestAPIAdminImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.generic.APIMTestCaseUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.am.integration.tests.jwt.idp.JWTGeneratorUtil;
import org.wso2.carbon.automation.engine.context.TestUserMode;

public class ExternalIDPJWTTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(ExternalIDPJWTTestCase.class);
    private static final String KEY_MANAGER_1 = "KeyManager-1";
    private static final String KEY_MANAGER_2 = "KeyManager-2";
    public static final String ALL_KEY_MANAGER = "all";
    private String apiName = "ExternalJWTTest";
    private String apiNameOnlyKM1 = "ExternalJWTTestOnlyKM1";
    private String apiContext = "externaljwtTest";
    private String apiContextOnlyKM1 = "externaljwtTestkm1";
    private String providerName;
    private String apiVersion = "1.0.0";
    private String jwtApplicationName = "JWTAppFOrJWTTest";
    private static final String ISSUER_1 = "https://test.apim.integration";
    private static final String ISSUER_2 = "https://test2.apim.integration";
    private String endpointURL;
    private String jwtApplicationId;
    private String apiId;
    URL tokenEndpointURL;
    private final String JWT_ASSERTION_HEADER = "X-JWT-Assertion";
    private String keyManager1Id;
    private String keyManager2Id;
    private String consumerKey1 = UUID.randomUUID().toString();
    private String consumerKey2 = UUID.randomUUID().toString();
    private String apiIdOnlyKm1;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationDTO = this.restAPIStore.createApplication(this.jwtApplicationName, "JWT Application", "10PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        this.jwtApplicationId = applicationDTO.getData();
        this.keyManager1Id = this.createKeyManager1(this.restAPIAdmin);
        this.keyManager2Id = this.createKeyManager2(this.restAPIAdmin);
        this.tokenEndpointURL = new URL(this.gatewayUrlsWrk.getWebAppURLNhttp() + "token");
        this.apiId = this.createAPI(this.apiName, this.apiContext, Arrays.asList(ALL_KEY_MANAGER));
        this.apiIdOnlyKm1 = this.createAPI(this.apiNameOnlyKM1, this.apiContextOnlyKM1, Arrays.asList(KEY_MANAGER_1));
        this.restAPIStore.subscribeToAPI(this.apiId, this.jwtApplicationId, "Gold");
        this.restAPIStore.subscribeToAPI(this.apiIdOnlyKm1, this.jwtApplicationId, "Gold");
        this.waitForKeyManagerDeployment(this.user.getUserDomain(), KEY_MANAGER_1);
        this.waitForKeyManagerDeployment(this.user.getUserDomain(), KEY_MANAGER_2);
        this.restAPIStore.mapConsumerKeyWithApplication(this.consumerKey1, this.jwtApplicationId, KEY_MANAGER_1);
        this.restAPIStore.mapConsumerKeyWithApplication(this.consumerKey2, this.jwtApplicationId, KEY_MANAGER_2);
        this.waitForAPIDeploymentSync(this.providerName, this.apiName, this.apiVersion, "\"isApiExists\":true");
    }

    private String createAPI(String apiName, String apiContext, List<String> keyManagers) throws XPathExpressionException, APIManagerIntegrationTestException, MalformedURLException, org.wso2.am.integration.clients.publisher.api.ApiException {
        this.providerName = this.user.getUserName();
        this.endpointURL = this.getSuperTenantAPIInvocationURLHttp("jwt_backend", "1.0");
        APIRequest apiRequest = new APIRequest(apiName, apiContext, new URL(this.endpointURL));
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setVisibility("public");
        apiRequest.setProvider(this.providerName);
        if (!keyManagers.contains(ALL_KEY_MANAGER)) {
            apiRequest.setKeyManagers(keyManagers);
        }
        return this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT")
    public void testInvokeExternalIDPGeneratedJWT() throws Exception {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "keystore.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", this.consumerKey1);
        attributes.put("http://idp.org/claims/givenname", "first");
        attributes.put("http://idp.org/claims/firstname", "last");
        attributes.put("http://idp.org/claims/email", "first@gmail.com");
        attributes.put("http://idp.org/claims/mobileno", "424479772294778");
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idptest", "idptest", "wso2carbon", "wso2carbon", "userexternal", ISSUER_1, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        log.info((Object)("External IDP JWT Generated: " + generatedJWT));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
        String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
        boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
        AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
        Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
        Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        log.info((Object)("JWT Received ==" + jsonObject.toString()));
        Object givenName = jsonObject.get("http://wso2.org/claims/givenname");
        Assert.assertNotNull((Object)givenName);
        Assert.assertEquals((Object)givenName, (Object)"first");
        Object firstName = jsonObject.get("http://wso2.org/claims/firstname");
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)firstName, (Object)"last");
        Object email = jsonObject.get("http://wso2.org/claims/email");
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)email, (Object)"first@gmail.com");
        try {
            Object mobileno = jsonObject.get("http://idp.org/claims/mobileno");
            Assert.assertNull((Object)mobileno);
        }
        catch (JSONException e) {
            Assert.assertTrue((boolean)true, (String)"Claim not in jwt");
        }
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT Consumer key is invalid")
    public void testInvokeExternalIDPGeneratedJWTNegative1() throws Exception {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "keystore.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", UUID.randomUUID().toString());
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idptest", "idptest", "wso2carbon", "wso2carbon", "userexternal", ISSUER_1, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.FORBIDDEN.getStatusCode(), (String)"Response code mismatched when api invocation");
        String payload = IOUtils.toString((InputStream)response.getEntity().getContent());
        Assert.assertTrue((boolean)payload.contains("900908"));
        Assert.assertTrue((boolean)payload.contains("User is NOT authorized to access the Resource. API Subscription validation failed."));
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT Certificate is unknown")
    public void testInvokeExternalIDPGeneratedJWTNegative2() throws Exception {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "keystore2.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", UUID.randomUUID().toString());
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idptest", "idptest", "wso2carbon", "wso2carbon", "userexternal", ISSUER_2, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.UNAUTHORIZED.getStatusCode(), (String)"Response code mismatched when api invocation");
        String payload = IOUtils.toString((InputStream)response.getEntity().getContent());
        Assert.assertTrue((boolean)payload.contains("900901"));
        Assert.assertTrue((boolean)payload.contains("Invalid Credentials"));
    }

    @Test(groups={"wso2.am"}, description="invoking From ExternalIDP Generated JWT")
    public void testInvokeExternalIDPGeneratedJWT1() throws Exception {
        File keyStoreFile = Paths.get(this.getAMResourceLocation(), "configFiles", "idpjwt", "idp1.jks").toFile();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("azp", this.consumerKey2);
        attributes.put("http://idp2.org/claims/givenname", "first");
        attributes.put("http://idp2.org/claims/firstname", "last");
        attributes.put("http://idp2.org/claims/email", "first@gmail.com");
        attributes.put("http://idp2.org/claims/mobileno", "424479772294778");
        String generatedJWT = JWTGeneratorUtil.generatedJWT(keyStoreFile, "idp2certificate", "idp1", "wso2carbon", "wso2carbon", "userexternal", ISSUER_2, attributes);
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        HttpGet get = new HttpGet(this.getAPIInvocationURLHttp(this.apiContext, this.apiVersion));
        log.info((Object)("External IDP JWT Generated: " + generatedJWT));
        get.addHeader("Authorization", "Bearer " + generatedJWT);
        HttpResponse response = httpclient.execute((HttpUriRequest)get);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)Response.Status.OK.getStatusCode(), (String)"Response code mismatched when api invocation");
        Header[] responseHeaders = response.getAllHeaders();
        Header jwtheader = this.pickHeader(responseHeaders, "X-JWT-Assertion");
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTHeaderString = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        Assert.assertNotNull((Object)jwtheader, (String)"X-JWT-Assertion is not available in the backend request.");
        String decodedJWTString = APIMTestCaseUtils.getDecodedJWT((String)jwtheader.getValue());
        log.debug((Object)("Decoded JWTString = " + decodedJWTString));
        String jwtHeader = APIMTestCaseUtils.getDecodedJWTHeader((String)jwtheader.getValue());
        byte[] jwtSignature = APIMTestCaseUtils.getDecodedJWTSignature((String)jwtheader.getValue());
        String jwtAssertion = APIMTestCaseUtils.getJWTAssertion((String)jwtheader.getValue());
        boolean isSignatureValid = APIMTestCaseUtils.isJwtSignatureValid((String)jwtAssertion, (byte[])jwtSignature, (String)jwtHeader);
        AssertJUnit.assertTrue((String)"JWT signature verification failed", (boolean)isSignatureValid);
        log.debug((Object)("Decoded JWT header String = " + decodedJWTHeaderString));
        JSONObject jsonHeaderObject = new JSONObject(decodedJWTHeaderString);
        Assert.assertEquals((String)jsonHeaderObject.getString("typ"), (String)"JWT");
        Assert.assertEquals((String)jsonHeaderObject.getString("alg"), (String)"RS256");
        JSONObject jsonObject = new JSONObject(decodedJWTString);
        log.info((Object)("JWT Received ==" + jsonObject.toString()));
        Object givenName = jsonObject.get("http://wso2.org/claims/givenname");
        Assert.assertNotNull((Object)givenName);
        Assert.assertEquals((Object)givenName, (Object)"first");
        Object firstName = jsonObject.get("http://wso2.org/claims/firstname");
        Assert.assertNotNull((Object)firstName);
        Assert.assertEquals((Object)firstName, (Object)"last");
        Object email = jsonObject.get("http://wso2.org/claims/email");
        Assert.assertNotNull((Object)email);
        Assert.assertEquals((Object)email, (Object)"first@gmail.com");
        try {
            Object mobileno = jsonObject.get("http://idp.org/claims/mobileno");
            Assert.assertNull((Object)mobileno);
        }
        catch (JSONException e) {
            Assert.assertTrue((boolean)true, (String)"Claim not in jwt");
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.jwtApplicationId);
        this.restAPIAdmin.deleteKeyManager(this.keyManager1Id);
        this.restAPIAdmin.deleteKeyManager(this.keyManager2Id);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiIdOnlyKm1, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiIdOnlyKm1);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @Factory(dataProvider="userModeDataProvider")
    public ExternalIDPJWTTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    public String createKeyManager1(RestAPIAdminImpl restAPIAdmin) throws Exception {
        KeyManagerDTO keyManagerDTO = new KeyManagerDTO();
        keyManagerDTO.setType("custom");
        keyManagerDTO.setName(KEY_MANAGER_1);
        keyManagerDTO.setDescription("This is Key Manager");
        keyManagerDTO.setEnabled(Boolean.valueOf(true));
        keyManagerDTO.setIssuer(ISSUER_1);
        keyManagerDTO.setEnableMapOAuthConsumerApps(Boolean.valueOf(true));
        keyManagerDTO.setEnableTokenGeneration(Boolean.valueOf(false));
        keyManagerDTO.setEnableOAuthAppCreation(Boolean.valueOf(false));
        keyManagerDTO.setAvailableGrantTypes(Arrays.asList("client_credentials", "password", "implicit", "refresh_token"));
        TokenValidationDTO tokenValidationDTO = new TokenValidationDTO();
        tokenValidationDTO.setEnable(Boolean.valueOf(false));
        ArrayList<TokenValidationDTO> tokenValidationDTOList = new ArrayList<TokenValidationDTO>();
        tokenValidationDTOList.add(tokenValidationDTO);
        keyManagerDTO.setTokenValidation(tokenValidationDTOList);
        keyManagerDTO.setEnableSelfValidationJWT(Boolean.valueOf(true));
        ArrayList<ClaimMappingEntryDTO> claimMappingEntryDTOS = new ArrayList<ClaimMappingEntryDTO>();
        claimMappingEntryDTOS.add(new ClaimMappingEntryDTO().remoteClaim("http://idp.org/claims/givenname").localClaim("http://wso2.org/claims/givenname"));
        claimMappingEntryDTOS.add(new ClaimMappingEntryDTO().remoteClaim("http://idp.org/claims/firstname").localClaim("http://wso2.org/claims/firstname"));
        claimMappingEntryDTOS.add(new ClaimMappingEntryDTO().remoteClaim("http://idp.org/claims/email").localClaim("http://wso2.org/claims/email"));
        keyManagerDTO.setClaimMapping(claimMappingEntryDTOS);
        org.wso2.am.integration.clients.admin.ApiResponse keyManagerDTOApiResponse = restAPIAdmin.addKeyManager(keyManagerDTO);
        KeyManagerDTO retrievedData = (KeyManagerDTO)keyManagerDTOApiResponse.getData();
        return retrievedData.getId();
    }

    private String createKeyManager2(RestAPIAdminImpl restAPIAdmin) throws org.wso2.am.integration.clients.admin.ApiException {
        KeyManagerDTO keyManagerDTO = new KeyManagerDTO();
        keyManagerDTO.setType("custom");
        keyManagerDTO.setName(KEY_MANAGER_2);
        keyManagerDTO.setDescription("This is Key Manager");
        keyManagerDTO.setEnabled(Boolean.valueOf(true));
        keyManagerDTO.setIssuer(ISSUER_2);
        KeyManagerCertificatesDTO keyManagerCertificatesDTO = new KeyManagerCertificatesDTO();
        keyManagerCertificatesDTO.setType(KeyManagerCertificatesDTO.TypeEnum.JWKS);
        keyManagerCertificatesDTO.setValue("https://localhost:8743/jwks/1.0");
        keyManagerDTO.setCertificates(keyManagerCertificatesDTO);
        keyManagerDTO.setEnableMapOAuthConsumerApps(Boolean.valueOf(true));
        keyManagerDTO.setEnableTokenGeneration(Boolean.valueOf(false));
        keyManagerDTO.setEnableOAuthAppCreation(Boolean.valueOf(false));
        keyManagerDTO.setAvailableGrantTypes(Arrays.asList("client_credentials", "password", "implicit", "refresh_token"));
        TokenValidationDTO tokenValidationDTO = new TokenValidationDTO();
        tokenValidationDTO.setEnable(Boolean.valueOf(false));
        ArrayList<TokenValidationDTO> tokenValidationDTOList = new ArrayList<TokenValidationDTO>();
        tokenValidationDTOList.add(tokenValidationDTO);
        keyManagerDTO.setTokenValidation(tokenValidationDTOList);
        keyManagerDTO.setEnableSelfValidationJWT(Boolean.valueOf(true));
        ArrayList<ClaimMappingEntryDTO> claimMappingEntryDTOS = new ArrayList<ClaimMappingEntryDTO>();
        claimMappingEntryDTOS.add(new ClaimMappingEntryDTO().remoteClaim("http://idp2.org/claims/givenname").localClaim("http://wso2.org/claims/givenname"));
        claimMappingEntryDTOS.add(new ClaimMappingEntryDTO().remoteClaim("http://idp2.org/claims/firstname").localClaim("http://wso2.org/claims/firstname"));
        claimMappingEntryDTOS.add(new ClaimMappingEntryDTO().remoteClaim("http://idp2.org/claims/email").localClaim("http://wso2.org/claims/email"));
        keyManagerDTO.setClaimMapping(claimMappingEntryDTOS);
        org.wso2.am.integration.clients.admin.ApiResponse keyManagerDTOApiResponse = restAPIAdmin.addKeyManager(keyManagerDTO);
        KeyManagerDTO retrievedData = (KeyManagerDTO)keyManagerDTOApiResponse.getData();
        return retrievedData.getId();
    }

    @Test(description="test Generate consumer Keys when oauth app creation disable")
    public void generateKeysNegative() {
        org.wso2.carbon.automation.test.utils.http.client.HttpResponse applicationDTO = this.restAPIStore.createApplication("JWT_NEGATIVE_APP", "JWT Application3", "10PerMin", ApplicationDTO.TokenTypeEnum.JWT);
        String appId = applicationDTO.getData();
        try {
            ApiResponse applicationKeyDTOApiResponse = this.restAPIStore.generateKeysWithApiResponse(appId, "300", "https://localhost", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, Arrays.asList("default"), Arrays.asList("client_credentials"), Collections.emptyMap(), KEY_MANAGER_1);
            Assert.fail((String)"Consumer Key Generated For App for key manager not supported");
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)400);
            ErrorDTO errorDTO = (ErrorDTO)new Gson().fromJson(e.getResponseBody(), ErrorDTO.class);
            Assert.assertEquals((long)errorDTO.getCode(), (long)901405L);
            Assert.assertEquals((String)errorDTO.getMessage(), (String)"Key Manager doesn't support generating OAuth applications");
            Assert.assertEquals((String)errorDTO.getDescription(), (String)"Key Manager doesn't support generating OAuth applications");
        }
        this.restAPIStore.deleteApplication(appId);
    }
}

