/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.listener;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.testng.IAlterSuiteListener;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class APIMAlterSuiteListener
implements IAlterSuiteListener {
    public void alter(List<XmlSuite> list) {
        String testsToRunCommaSeparated = System.getenv("PRODUCT_APIM_TESTS");
        String testClassesToRunCommaSeparated = System.getenv("PRODUCT_APIM_TEST_CLASSES");
        if (StringUtils.isBlank((String)testsToRunCommaSeparated) && StringUtils.isBlank((String)testClassesToRunCommaSeparated)) {
            return;
        }
        String[] enabledTests = new String[]{};
        String[] enabledTestClasses = new String[]{};
        if (!StringUtils.isBlank((String)testsToRunCommaSeparated)) {
            enabledTests = testsToRunCommaSeparated.split(",");
        }
        if (!StringUtils.isBlank((String)testClassesToRunCommaSeparated)) {
            enabledTestClasses = testClassesToRunCommaSeparated.split(",");
        }
        for (XmlSuite suite : list) {
            if (!"ApiManager-features-test-suite".equals(suite.getName())) continue;
            ArrayList<XmlTest> newXMLTests = new ArrayList<XmlTest>();
            for (XmlTest xmlTest : suite.getTests()) {
                boolean xmlTestAdded = false;
                for (String enabledTest : enabledTests) {
                    if (!enabledTest.trim().equals(xmlTest.getName().trim())) continue;
                    xmlTestAdded = true;
                    newXMLTests.add(xmlTest);
                }
                ArrayList selectedXmlClassList = new ArrayList();
                for (String enabledTestClass : enabledTestClasses) {
                    List xmlClassList = xmlTest.getClasses();
                    for (int i = 0; i < xmlClassList.size(); ++i) {
                        if (!enabledTestClass.trim().equals(((XmlClass)xmlClassList.get(i)).getName().trim())) continue;
                        if (i != 0) {
                            selectedXmlClassList.add(xmlClassList.get(0));
                        }
                        selectedXmlClassList.add(xmlClassList.get(i));
                    }
                }
                if (selectedXmlClassList.size() <= 0) continue;
                xmlTest.setClasses(selectedXmlClassList);
                if (xmlTestAdded) continue;
                newXMLTests.add(xmlTest);
            }
            suite.setTests(newXMLTests);
        }
    }
}

