/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import com.google.common.io.Files;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIInfoDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIListDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIOperationsDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationConstants;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APIResourceBean;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.ALL})
public class APIImportExportTestCase
extends APIManagerLifecycleBaseTest {
    private final Log log = LogFactory.getLog(APIImportExportTestCase.class);
    private final String API_NAME = "APIImportExportTestCaseAPIName";
    private final String NEW_API_NAME = "NewAPIImportExportTestCaseAPIName";
    private final String PRESERVE_PUBLISHER_API_NAME = "preserveNewAPIImportExportAPIName";
    private final String NOT_PRESERVE_PUBLISHER_API_NAME = "notPreserveNewAPIImportExportAPIName";
    private final String PRESERVE_PUBLISHER_API_CONTEXT = "preserveAPIImportExportContext";
    private final String NOT_PRESERVE_PUBLISHER_API_CONTEXT = "notPreserveAPIImportExportContext";
    private final String API_CONTEXT = "APIImportExportTestCaseContext";
    private final String NEW_API_CONTEXT = "NewAPIImportExportTestCaseContext";
    private final String ALLOWED_ROLE = "allowedRole";
    private final String VISIBILITY_ROLE = "visibilityRole";
    private final String NOT_ALLOWED_ROLE = "denyRole";
    private final String ADMIN_ROLE = "admin";
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String[] PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage/api/subscribe"};
    private final char[] ALLOWED_USER_PASS = "pass@123".toCharArray();
    private final char[] PUBLISHER_USER_PASS = "pass@123".toCharArray();
    private final String SCOPE_NAME = "ImportExportScope";
    private final String TAG1 = "import";
    private final String TAG2 = "export";
    private final String TAG3 = "test";
    private final String DESCRIPTION = "This is test API create by API manager integration test";
    private final String UPDATED_DESCRIPTION = "This is the updated version of API create by API manager integration test";
    private final String API_VERSION = "1.0.0";
    private final String APP_NAME = "APIImportExportTestCaseApp";
    private final String NEW_APP_NAME = "newAPIImportExportTestCaseApp";
    private RestAPIStoreImpl allowedStoreUser;
    private String allowedUser = "allowedUser";
    private String publisherUser = "importExportPublisher";
    private String publisherURLHttps;
    private File zipTempDir;
    private File apiZip;
    private File newApiZip;
    private File preservePublisherApiZip;
    private File notPreservePublisherApiZip;
    private String importUrl;
    private String exportUrl;
    private APICreationRequestBean apiCreationRequestBean;
    private List<APIResourceBean> resList;
    private String tags;
    private String tierCollection;
    private String endpointUrl;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private String apiId;
    private String newApiId;
    private String applicationId;
    private String newApplicationId;
    private String preservePublisherApiId;
    private String notPreservePublisherApiId;
    private ArrayList<String> grantTypes;

    @Factory(dataProvider="userModeDataProvider")
    public APIImportExportTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.grantTypes = new ArrayList();
        this.publisherURLHttps = this.publisherUrls.getWebAppURLHttps();
        this.endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        this.tags = "import,export,test";
        this.tierCollection = "Bronze,Gold,Silver,Unlimited";
        this.importUrl = this.publisherURLHttps + "api/am/publisher/v2" + "/apis/import";
        this.exportUrl = this.publisherURLHttps + "api/am/publisher/v2" + "/apis/export";
        this.userManagementClient = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.createSession(this.keyManagerContext));
        this.userManagementClient.addRole("allowedRole", null, this.PERMISSIONS);
        this.userManagementClient.addRole("denyRole", null, this.PERMISSIONS);
        this.userManagementClient.addRole("visibilityRole", null, this.PERMISSIONS);
        this.userManagementClient.addUser(this.allowedUser, String.valueOf(this.ALLOWED_USER_PASS), new String[]{"Internal/subscriber", "visibilityRole"}, null);
        this.userManagementClient.addUser(this.publisherUser, String.valueOf(this.PUBLISHER_USER_PASS), new String[]{"admin"}, null);
        this.allowedStoreUser = new RestAPIStoreImpl(this.allowedUser, String.valueOf(this.ALLOWED_USER_PASS), this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        if (!this.keyManagerContext.getContextTenant().getDomain().equals("carbon.super")) {
            this.allowedUser = this.allowedUser + "@" + this.keyManagerContext.getContextTenant().getDomain();
            this.publisherUser = this.publisherUser + "@" + this.keyManagerContext.getContextTenant().getDomain();
        }
        this.createAndPublishAPI();
    }

    private void createAndPublishAPI() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("APIImportExportTestCaseAPIName", "APIImportExportTestCaseContext", "1.0.0", providerName, new URL(this.exportUrl));
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setSubPolicyCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean res1 = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "20KPerMin", "/post");
        APIResourceBean res2 = new APIResourceBean("GET", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION.getAuthType(), "50KPerMin", "/get");
        APIResourceBean res3 = new APIResourceBean("PUT", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_USER.getAuthType(), "10KPerMin", "/put");
        APIResourceBean res4 = new APIResourceBean("DELETE", APIMIntegrationConstants.ResourceAuthTypes.APPLICATION_AND_APPLICATION_USER.getAuthType(), "Unlimited", "/delete");
        APIResourceBean res5 = new APIResourceBean("PATCH", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "50KPerMin", "/patch");
        APIResourceBean res6 = new APIResourceBean("HEAD", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "50KPerMin", "/head");
        APIResourceBean res7 = new APIResourceBean("OPTIONS", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "50KPerMin", "/options");
        this.resList.add(res1);
        this.resList.add(res2);
        this.resList.add(res3);
        this.resList.add(res4);
        this.resList.add(res5);
        this.resList.add(res6);
        this.resList.add(res7);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        APIDTO apiDto = this.createAndPublishAPI(this.apiCreationRequestBean, this.restAPIPublisher, false);
        this.apiId = apiDto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
    }

    @Test(groups={"wso2.am"}, description="Exported Sample API")
    public void testAPIExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "APIImportExportTestCaseAPIName" + "&version=" + "1.0.0" + "&providerName=" + this.user.getUserName() + "&format=JSON");
        this.zipTempDir = Files.createTempDir();
        String fileName = this.user.getUserDomain() + "_" + "APIImportExportTestCaseAPIName";
        this.apiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportArtifact(exportRequest, this.apiZip);
    }

    @Test(groups={"wso2.am"}, description="Importing exported API", dependsOnMethods={"testAPIExport"})
    public void testAPIImport() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        HttpResponse serviceResponse = this.restAPIPublisher.deleteAPI(this.apiId);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API delete failed");
        APIImportExportTestCase.importArtifact(this.importUrl, this.apiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
        this.waitForAPIDeployment();
    }

    @Test(groups={"wso2.am"}, description="Checking status of the imported API", dependsOnMethods={"testAPIImport"})
    public void testAPIState() throws Exception {
        APIDTO apiObj = this.getAPI("APIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        this.apiId = apiObj.getId();
        String state = apiObj.getLifeCycleStatus();
        Assert.assertEquals((String)state, (String)APILifeCycleState.PUBLISHED.getState().toUpperCase(), (String)"Imported API not in Published state");
        Assert.assertEquals((String)"APIImportExportTestCaseAPIName", (String)apiObj.getName(), (String)"Imported API Name is incorrect");
        Assert.assertEquals((String)"1.0.0", (String)apiObj.getVersion(), (String)"Imported API version is incorrect");
        Assert.assertEquals((String)"This is test API create by API manager integration test", (String)apiObj.getDescription(), (String)"Imported API description is incorrect");
        Assert.assertEquals((String)"/APIImportExportTestCaseContext", (String)apiObj.getContext().replace("/t/wso2.com", ""), (String)"Imported API context is incorrect");
        List tagList = apiObj.getTags();
        Assert.assertTrue((boolean)tagList.contains("import"), (String)"Imported API not contain tag: import");
        Assert.assertTrue((boolean)tagList.contains("export"), (String)"Imported API not contain tag: export");
        Assert.assertTrue((boolean)tagList.contains("test"), (String)"Imported API not contain tag: test");
        Assert.assertTrue((boolean)apiObj.getPolicies().contains("Gold"), (String)"Imported API not contain Tier: Gold");
        Assert.assertTrue((boolean)apiObj.getPolicies().contains("Bronze"), (String)"Imported API not contain Tier: Bronze");
        Assert.assertTrue((boolean)apiObj.getPolicies().contains("Silver"), (String)"Imported API not contain Tier: Silver");
        Assert.assertTrue((boolean)apiObj.getPolicies().contains("Unlimited"), (String)"Imported API not contain Tier: Unlimited");
        Assert.assertTrue((boolean)apiObj.getTransport().contains("http"), (String)"Imported API HTTP transport status is incorrect");
        Assert.assertTrue((boolean)apiObj.getTransport().contains("https"), (String)"Imported API HTTP transport status is incorrect");
        Assert.assertFalse((boolean)apiObj.isResponseCachingEnabled(), (String)"Imported API response Cache status is incorrect");
        Assert.assertEquals((Object)APIDTO.VisibilityEnum.PUBLIC, (Object)apiObj.getVisibility(), (String)"Imported API visibility is incorrect");
        Assert.assertFalse((boolean)apiObj.isIsDefaultVersion(), (String)"Imported API Default Version status is incorrect");
        List apiOperationsDTOList = apiObj.getOperations();
        Assert.assertEquals((int)this.resList.size(), (int)apiOperationsDTOList.size(), (String)"Imported API not in Created state");
        String method = null;
        String authType = null;
        String tier = null;
        String urlPattern = null;
        for (int i = 0; i < this.resList.size(); ++i) {
            APIResourceBean res = this.resList.get(i);
            for (APIOperationsDTO apiOperationsDTO : apiOperationsDTOList) {
                method = apiOperationsDTO.getVerb();
                if (!StringUtils.equals((String)res.getResourceMethod(), (String)method)) continue;
                authType = apiOperationsDTO.getAuthType();
                tier = apiOperationsDTO.getThrottlingPolicy();
                urlPattern = apiOperationsDTO.getTarget();
                break;
            }
            Assert.assertEquals((String)res.getResourceMethod(), method, (String)"Imported API Resource method is incorrect");
            Assert.assertEquals((String)res.getUriTemplate(), urlPattern, (String)"Imported API Resource URL template is incorrect");
        }
    }

    @Test(groups={"wso2.am"}, description="Update imported Sample API", dependsOnMethods={"testAPIState"})
    public void testAPIUpdate() throws Exception {
        APIDTO apiObj = this.getAPI("APIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        this.apiId = apiObj.getId();
        apiObj.setDescription("This is the updated version of API create by API manager integration test");
        this.restAPIPublisher.updateAPI(apiObj);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
    }

    @Test(groups={"wso2.am"}, description="Checking status of the updated API", dependsOnMethods={"testAPIUpdate"})
    public void testAPIStateAfterUpdate() throws Exception {
        APIDTO updatedApiObj = this.getAPI("APIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        this.apiId = updatedApiObj.getId();
        String state = updatedApiObj.getLifeCycleStatus();
        Assert.assertEquals((String)state, (String)APILifeCycleState.PUBLISHED.getState().toUpperCase(), (String)"Imported API not in Published state");
        Assert.assertEquals((String)"APIImportExportTestCaseAPIName", (String)updatedApiObj.getName(), (String)"Imported API Name is incorrect");
        Assert.assertEquals((String)"1.0.0", (String)updatedApiObj.getVersion(), (String)"Imported API version is incorrect");
        Assert.assertEquals((String)"This is the updated version of API create by API manager integration test", (String)updatedApiObj.getDescription(), (String)"Imported API description is incorrect");
        List tagList = updatedApiObj.getTags();
        Assert.assertTrue((boolean)tagList.contains("import"), (String)"Imported API not contain tag: import");
        Assert.assertTrue((boolean)tagList.contains("export"), (String)"Imported API not contain tag: export");
        Assert.assertTrue((boolean)tagList.contains("test"), (String)"Imported API not contain tag: test");
        Assert.assertTrue((boolean)updatedApiObj.getPolicies().contains("Gold"), (String)"Imported API not contain Tier: Gold");
        Assert.assertTrue((boolean)updatedApiObj.getPolicies().contains("Bronze"), (String)"Imported API not contain Tier: Bronze");
        Assert.assertTrue((boolean)updatedApiObj.getPolicies().contains("Silver"), (String)"Imported API not contain Tier: Silver");
        Assert.assertTrue((boolean)updatedApiObj.getPolicies().contains("Unlimited"), (String)"Imported API not contain Tier: Unlimited");
        Assert.assertTrue((boolean)updatedApiObj.getTransport().contains("http"), (String)"Imported API HTTP transport status is incorrect");
        Assert.assertTrue((boolean)updatedApiObj.getTransport().contains("https"), (String)"Imported API HTTP transport status is incorrect");
        Assert.assertFalse((boolean)updatedApiObj.isResponseCachingEnabled(), (String)"Imported API response Cache status is incorrect");
        Assert.assertEquals((Object)APIDTO.VisibilityEnum.PUBLIC, (Object)updatedApiObj.getVisibility(), (String)"Imported API visibility is incorrect");
        Assert.assertFalse((boolean)updatedApiObj.isIsDefaultVersion(), (String)"Imported API Default Version status is incorrect");
        List apiOperationsDTOList = updatedApiObj.getOperations();
        Assert.assertEquals((int)this.resList.size(), (int)apiOperationsDTOList.size(), (String)"Imported API not in Created state");
        String method = null;
        String authType = null;
        String tier = null;
        String urlPattern = null;
        for (int i = 0; i < this.resList.size(); ++i) {
            APIResourceBean res = this.resList.get(i);
            for (APIOperationsDTO apiOperationsDTO : apiOperationsDTOList) {
                method = apiOperationsDTO.getVerb();
                if (!StringUtils.equals((String)res.getResourceMethod(), (String)method)) continue;
                authType = apiOperationsDTO.getAuthType();
                tier = apiOperationsDTO.getThrottlingPolicy();
                urlPattern = apiOperationsDTO.getTarget();
                break;
            }
            Assert.assertEquals((String)res.getResourceMethod(), method, (String)"Imported API Resource method is incorrect");
            Assert.assertEquals((String)res.getUriTemplate(), urlPattern, (String)"Imported API Resource URL template is incorrect");
        }
    }

    @Test(groups={"wso2.am"}, description="Implementing sample api for scope test", dependsOnMethods={"testAPIStateAfterUpdate"})
    public void testNewAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("NewAPIImportExportTestCaseAPIName", "NewAPIImportExportTestCaseContext", "1.0.0", providerName, new URL(this.endpointUrl));
        String resourceFile = "artifacts" + File.separator + "AM" + File.separator + "configFiles" + File.separator + "importExport" + File.separator + "swagger.json";
        String swagger = IOUtils.toString((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceFile), (String)"UTF-8");
        swagger = swagger.replaceAll("\\$authType", "Application & Application User").replaceAll("\\$tier", "Unlimited").replaceAll("\\$scope", "ImportExportScope").replaceAll("\\$roles", "allowedRole").replaceAll("\\$apiName", "NewAPIImportExportTestCaseAPIName").replaceAll("\\$apiVersion", "1.0.0");
        this.apiCreationRequestBean.setSwagger(swagger);
        this.apiCreationRequestBean.setVisibility(APIDTO.VisibilityEnum.RESTRICTED.getValue());
        this.apiCreationRequestBean.setRoles("visibilityRole");
        APIDTO apiDto = this.createAndPublishAPI(this.apiCreationRequestBean, this.restAPIPublisher, false);
        this.newApiId = apiDto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.newApiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        this.waitForAPIDeploymentSync(providerName, "NewAPIImportExportTestCaseAPIName", "1.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Invoke the API before export", dependsOnMethods={"testNewAPICreation"})
    public void testNewAPIInvoke() throws Exception {
        HttpResponse applicationResponse = this.allowedStoreUser.createApplication("APIImportExportTestCaseApp", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        String provider = this.user.getUserName();
        HttpResponse subscribeResponse = this.subscribeToAPIUsingRest(this.newApiId, this.applicationId, "Unlimited", this.allowedStoreUser);
        Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful  API Name:NewAPIImportExportTestCaseAPIName API Version:1.0.0 API Provider Name :" + provider));
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.allowedStoreUser.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found ", (String)accessToken);
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("NewAPIImportExportTestCaseContext", "1.0.0");
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Imported API not in Created state");
    }

    @Test(groups={"wso2.am"}, description="Exporting above created new API", dependsOnMethods={"testNewAPIInvoke"})
    public void testNewAPIExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "NewAPIImportExportTestCaseAPIName" + "&version=" + "1.0.0" + "&providerName=" + this.user.getUserName() + "&format=JSON");
        String fileName = this.user.getUserDomain() + "_" + "NewAPIImportExportTestCaseAPIName";
        this.newApiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportArtifact(exportRequest, this.newApiZip);
    }

    @Test(groups={"wso2.am"}, description="Importing new API", dependsOnMethods={"testNewAPIExport"})
    public void testNewAPIImport() throws Exception {
        this.allowedStoreUser.removeApplicationById(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.newApiId, this.restAPIPublisher);
        HttpResponse serviceResponse = this.restAPIPublisher.deleteAPI(this.newApiId);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API delete failed");
        APIImportExportTestCase.importArtifact(this.importUrl, this.newApiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
    }

    @Test(groups={"wso2.am"}, description="Checking newly imported API status", dependsOnMethods={"testNewAPIImport"})
    public void testNewAPIState() throws Exception {
        APIDTO apiObj = this.getAPI("NewAPIImportExportTestCaseAPIName", "1.0.0", this.user.getUserName());
        this.newApiId = apiObj.getId();
        this.createAPIRevisionAndDeployUsingRest(this.newApiId, this.restAPIPublisher);
        this.waitForAPIDeployment();
        String state = apiObj.getLifeCycleStatus();
        Assert.assertEquals((String)state, (String)APILifeCycleState.PUBLISHED.getState().toUpperCase(), (String)"Imported API not in Published state");
        Assert.assertEquals((String)"NewAPIImportExportTestCaseAPIName", (String)apiObj.getName(), (String)"Imported API Name is incorrect");
        Assert.assertEquals((String)"1.0.0", (String)apiObj.getVersion(), (String)"Imported API version is incorrect");
        Assert.assertEquals((String)"/NewAPIImportExportTestCaseContext", (String)apiObj.getContext().replace("/t/wso2.com", ""), (String)"Imported API context is incorrect");
        Assert.assertEquals((Object)APIDTO.VisibilityEnum.RESTRICTED, (Object)apiObj.getVisibility(), (String)"Imported API Visibility is incorrect");
        String endpointConfig = apiObj.getEndpointConfig().toString();
        Assert.assertTrue((boolean)endpointConfig.contains(this.endpointUrl), (String)"Imported API Endpoint url is incorrect");
    }

    @Test(groups={"wso2.am"}, description="Invoke the newly imported API", dependsOnMethods={"testNewAPIState"})
    public void testNewAPIInvokeAfterImport() throws Exception {
        HttpResponse applicationResponse = this.allowedStoreUser.createApplication("newAPIImportExportTestCaseApp", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.newApplicationId = applicationResponse.getData();
        String provider = this.user.getUserName();
        HttpResponse subscribeResponse = this.subscribeToAPIUsingRest(this.newApiId, this.newApplicationId, "Gold", this.allowedStoreUser);
        Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful  API Name:NewAPIImportExportTestCaseAPIName API Version:1.0.0 API Provider Name :" + provider));
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.allowedStoreUser.generateKeys(this.newApplicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, null, this.grantTypes);
        String accessToken = applicationKeyDTO.getToken().getAccessToken();
        Assert.assertNotNull((Object)"Access Token not found ", (String)accessToken);
        this.requestHeaders.clear();
        this.requestHeaders.put("Authorization", "Bearer " + accessToken);
        String invokeURL = this.getAPIInvocationURLHttp("NewAPIImportExportTestCaseContext", "1.0.0");
        HttpResponse serviceResponse = HTTPSClientUtils.doGet((String)(invokeURL + "/add?x=1&y=1"), this.requestHeaders);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)200, (String)"Imported API not in Created state");
    }

    @Test(groups={"wso2.am"}, description="Sample API creation", dependsOnMethods={"testNewAPIInvokeAfterImport"})
    public void testPreserveProviderTrueAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("preserveNewAPIImportExportAPIName", "preserveAPIImportExportContext", "1.0.0", providerName, new URL(this.exportUrl));
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean resource = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "20KPerMin", "/post");
        this.resList.add(resource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        APIDTO apiDto = this.createAndPublishAPI(this.apiCreationRequestBean, this.restAPIPublisher, false);
        this.preservePublisherApiId = apiDto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.preservePublisherApiId, this.restAPIPublisher);
    }

    @Test(groups={"wso2.am"}, description="Exported Sample API", dependsOnMethods={"testPreserveProviderTrueAPICreation"})
    public void testPreserveProviderTrueApiExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "preserveNewAPIImportExportAPIName" + "&version=" + "1.0.0" + "&providerName=" + this.user.getUserName() + "&format=JSON");
        String fileName = this.user.getUserDomain() + "_" + "preserveNewAPIImportExportAPIName";
        this.preservePublisherApiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportArtifact(exportRequest, this.preservePublisherApiZip);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.preservePublisherApiId, this.restAPIPublisher);
        HttpResponse serviceResponse = this.restAPIPublisher.deleteAPI(this.preservePublisherApiId);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API delete failed");
    }

    @Test(groups={"wso2.am"}, description="Importing exported API", dependsOnMethods={"testPreserveProviderTrueApiExport"})
    public void testPreserveProviderTrueSameProviderApiImport() throws Exception {
        APIImportExportTestCase.importArtifact(this.importUrl + "?preserveProvider=true", this.preservePublisherApiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
        this.waitForAPIDeployment();
        this.log.info((Object)("API ID before import: " + this.preservePublisherApiId));
        APIDTO apiObj = this.getAPI("preserveNewAPIImportExportAPIName", "1.0.0", this.user.getUserName());
        this.preservePublisherApiId = apiObj.getId();
        this.createAPIRevisionAndDeployUsingRest(this.preservePublisherApiId, this.restAPIPublisher);
        String provider = apiObj.getProvider();
        Assert.assertEquals((String)provider, (String)this.user.getUserName(), (String)"Provider is not as expected when 'preserveProvider'=true");
        this.undeployAndDeleteAPIRevisionsUsingRest(this.preservePublisherApiId, this.restAPIPublisher);
        HttpResponse serviceResponse = this.restAPIPublisher.deleteAPI(this.preservePublisherApiId);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API delete failed");
        APIImportExportTestCase.importArtifact(this.importUrl + "?preserveProvider=true", this.preservePublisherApiZip, this.publisherUser, this.PUBLISHER_USER_PASS);
        this.waitForAPIDeployment();
        this.log.info((Object)("API ID  different publisher before import: " + this.preservePublisherApiId));
        apiObj = this.getAPI("preserveNewAPIImportExportAPIName", "1.0.0", this.user.getUserName());
        this.preservePublisherApiId = apiObj.getId();
        provider = apiObj.getProvider();
        Assert.assertEquals((String)provider, (String)this.user.getUserName(), (String)"Provider is not as expected when 'preserveProvider'=true");
    }

    @Test(groups={"wso2.am"}, description="Sample API creation", dependsOnMethods={"testPreserveProviderTrueSameProviderApiImport"})
    public void testPreserveProviderFalseAPICreation() throws Exception {
        String providerName = this.user.getUserName();
        this.apiCreationRequestBean = new APICreationRequestBean("notPreserveNewAPIImportExportAPIName", "notPreserveAPIImportExportContext", "1.0.0", providerName, new URL(this.exportUrl));
        this.apiCreationRequestBean.setTags(this.tags);
        this.apiCreationRequestBean.setDescription("This is test API create by API manager integration test");
        this.apiCreationRequestBean.setTiersCollection(this.tierCollection);
        this.resList = new ArrayList<APIResourceBean>();
        APIResourceBean resource = new APIResourceBean("POST", APIMIntegrationConstants.ResourceAuthTypes.NONE.getAuthType(), "20KPerMin", "/post");
        this.resList.add(resource);
        this.apiCreationRequestBean.setResourceBeanList(this.resList);
        APIDTO apiDto = this.createAndPublishAPI(this.apiCreationRequestBean, this.restAPIPublisher, false);
        this.notPreservePublisherApiId = apiDto.getId();
        this.createAPIRevisionAndDeployUsingRest(this.notPreservePublisherApiId, this.restAPIPublisher);
    }

    @Test(groups={"wso2.am"}, description="Exported Sample API", dependsOnMethods={"testPreserveProviderFalseAPICreation"})
    public void testPreserveProviderFalseApiExport() throws Exception {
        URL exportRequest = new URL(this.exportUrl + "?name=" + "notPreserveNewAPIImportExportAPIName" + "&version=" + "1.0.0" + "&providerName=" + this.user.getUserName() + "&format=JSON");
        String fileName = this.user.getUserDomain() + "_" + "notPreserveNewAPIImportExportAPIName";
        this.notPreservePublisherApiZip = new File(this.zipTempDir.getAbsolutePath() + File.separator + fileName + ".zip");
        this.exportArtifact(exportRequest, this.notPreservePublisherApiZip);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.notPreservePublisherApiId, this.restAPIPublisher);
        HttpResponse serviceResponse = this.restAPIPublisher.deleteAPI(this.notPreservePublisherApiId);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API delete failed");
    }

    @Test(groups={"wso2.am"}, description="Importing exported API", dependsOnMethods={"testPreserveProviderFalseApiExport"})
    public void testPreserveProviderFalseSameProviderApiImport() throws Exception {
        APIImportExportTestCase.importArtifact(this.importUrl + "?preserveProvider=false", this.notPreservePublisherApiZip, this.user.getUserName(), this.user.getPassword().toCharArray());
        this.waitForAPIDeployment();
        this.log.info((Object)("API ID before import: " + this.notPreservePublisherApiId));
        APIDTO apiObj = this.getAPI("notPreserveNewAPIImportExportAPIName", "1.0.0", this.user.getUserName());
        this.notPreservePublisherApiId = apiObj.getId();
        String provider = apiObj.getProvider();
        Assert.assertEquals((String)provider, (String)this.user.getUserName(), (String)"Provider is not as expected when 'preserveProvider'=false");
        HttpResponse serviceResponse = this.restAPIPublisher.deleteAPI(this.notPreservePublisherApiId);
        Assert.assertEquals((int)serviceResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API delete failed");
        APIImportExportTestCase.importArtifact(this.importUrl + "?preserveProvider=false", this.notPreservePublisherApiZip, this.publisherUser, this.PUBLISHER_USER_PASS);
        this.waitForAPIDeployment();
        this.log.info((Object)("API ID  different publisher before import: " + this.notPreservePublisherApiId));
        apiObj = this.getAPI("notPreserveNewAPIImportExportAPIName", "1.0.0", this.publisherUser);
        this.notPreservePublisherApiId = apiObj.getId();
        provider = apiObj.getProvider();
        Assert.assertEquals((String)provider, (String)this.publisherUser, (String)"Provider is not as expected when 'preserveProvider'=false");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.allowedStoreUser.deleteApplication(this.applicationId);
        this.allowedStoreUser.deleteApplication(this.newApplicationId);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.newApiId);
        this.restAPIPublisher.deleteAPI(this.preservePublisherApiId);
        this.restAPIPublisher.deleteAPI(this.notPreservePublisherApiId);
        boolean deleteStatus = this.apiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.newApiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.preservePublisherApiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.notPreservePublisherApiZip.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp file delete not successful");
        deleteStatus = this.zipTempDir.delete();
        Assert.assertTrue((boolean)deleteStatus, (String)"temp directory delete not successful");
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    private static String encodeCredentials(String user, char[] pass) {
        StringBuilder builder = new StringBuilder(user).append(':').append(pass);
        String cred = builder.toString();
        byte[] encodedBytes = Base64.encodeBase64((byte[])cred.getBytes());
        return new String(encodedBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportArtifact(URL exportRequest, File fileName) throws URISyntaxException, IOException {
        CloseableHttpClient client = HTTPSClientUtils.getHttpsClient();
        HttpGet get = new HttpGet(exportRequest.toURI());
        get.addHeader("Authorization", "Basic " + APIImportExportTestCase.encodeCredentials(this.user.getUserName(), this.user.getPassword().toCharArray()));
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (FileOutputStream outStream = new FileOutputStream(fileName);){
                entity.writeTo((OutputStream)outStream);
            }
        }
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200, (String)"Response code is not as expected");
        Assert.assertTrue((boolean)fileName.exists(), (String)"File save was not successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void importArtifact(String importUrl, File fileName, String user, char[] pass) throws IOException {
        String temp;
        URL url = new URL(importUrl);
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        connection.setDoOutput(true);
        connection.setRequestMethod("POST");
        FileBody fileBody = new FileBody(fileName);
        MultipartEntity multipartEntity = new MultipartEntity(HttpMultipartMode.STRICT);
        multipartEntity.addPart("file", (ContentBody)fileBody);
        connection.setRequestProperty("Content-Type", multipartEntity.getContentType().getValue());
        connection.setRequestProperty("Authorization", "Basic " + APIImportExportTestCase.encodeCredentials(user, pass));
        try (OutputStream out = connection.getOutputStream();){
            multipartEntity.writeTo(out);
        }
        int status = connection.getResponseCode();
        BufferedReader read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((temp = read.readLine()) != null) {
            response.append(temp);
        }
        Assert.assertEquals((int)status, (int)200, (String)("Response code is not as expected : " + response));
    }

    private APIDTO getAPI(String apiName, String apiVersion, String provider) throws Exception {
        int retry = 10;
        String apiId = "";
        APIListDTO apiListDTO = this.restAPIPublisher.getAllAPIs();
        this.log.info((Object)("Get All APIS after import: " + apiListDTO.toString()));
        if (apiListDTO == null) {
            Thread.sleep(3000L);
            for (int i = 0; i < retry && (apiListDTO = this.restAPIPublisher.getAllAPIs()) == null; ++retry, ++i) {
                Thread.sleep(3000L);
                this.log.info((Object)"Waiting for the imported APIs");
            }
        }
        Assert.assertNotNull((Object)apiListDTO, (String)"No APIs found in API Publisher");
        for (APIInfoDTO apiInfoDTO : apiListDTO.getList()) {
            if (!apiName.equals(apiInfoDTO.getName()) || !apiVersion.equals(apiInfoDTO.getVersion()) || !provider.equals(apiInfoDTO.getProvider())) continue;
            apiId = apiInfoDTO.getId();
            this.log.info((Object)("API Object after Import: " + apiInfoDTO.toString()));
        }
        this.log.info((Object)("API ID after import: " + apiId));
        HttpResponse response = this.restAPIPublisher.getAPI(apiId);
        Assert.assertEquals((int)response.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)"API get failed");
        Gson g = new Gson();
        APIDTO apiObj = (APIDTO)g.fromJson(response.getData(), APIDTO.class);
        return apiObj;
    }
}

