/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIM4765ResourceOrderInSwagger
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIM4765ResourceOrderInSwagger.class);
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APIM4765ResourceOrderInSwagger(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
    }

    @Test(groups={"wso2.am"}, description="Test resource order in the swagger")
    public void swaggerResourceOrderTest() throws Exception {
        String APIName = "SwaggerReorderTest";
        String APIContext = "swagger_reorder_test";
        String tags = "youtube, token, media";
        String url = this.getGatewayURLHttp() + "jaxrs_basic/services/customers/customerservice";
        String description = "This is test API create by API manager integration test";
        String APIVersion = "1.0.0";
        String lineSeparator = System.getProperty("line.separator");
        APIRequest apiRequest = new APIRequest(APIName, APIContext, new URL(url), new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(APIVersion);
        apiRequest.setSandbox(url);
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        String swagger = "{\"paths\":{\"/*\":{\"get\":{\"x-auth-type\":\"Application \",\"x-throttling-tier\":\"10KPerMin\",\"responses\":{\"200\":{}}}},\"/post\":{\"get\":{\"x-auth-type\":\"Application \",\"x-throttling-tier\":\"10KPerMin\",\"responses\":{\"200\":{}}}},\"/list\":{\"get\":{\"x-auth-type\":\"Application \",\"x-throttling-tier\":\"10KPerMin\",\"responses\":{\"200\":{}}}}},\"swagger\":\"2.0\",\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[]}},\"info\":{\"licence\":{},\"title\":\"TokenTestAPI\",\"description\":\"This is test API create by API manager integration test\",\"contact\":{\"email\":null,\"name\":null},\"version\":\"1.0.0\"}}";
        String resourceOrder = "\"paths\" : {" + lineSeparator + "    \"/*\" : {" + lineSeparator + "      \"get\" : {" + lineSeparator + "        \"parameters\" : [ ]," + lineSeparator + "        \"responses\" : {" + lineSeparator + "          \"200\" : { }" + lineSeparator + "        }," + lineSeparator + "        \"security\" : [ {" + lineSeparator + "          \"default\" : [ ]" + lineSeparator + "        } ]," + lineSeparator + "        \"x-auth-type\" : \"Application \"," + lineSeparator + "        \"x-throttling-tier\" : \"10KPerMin\"" + lineSeparator + "      }" + lineSeparator + "    }," + lineSeparator + "    \"/post\" : {" + lineSeparator + "      \"get\" : {" + lineSeparator + "        \"parameters\" : [ ]," + lineSeparator + "        \"responses\" : {" + lineSeparator + "          \"200\" : { }" + lineSeparator + "        }," + lineSeparator + "        \"security\" : [ {" + lineSeparator + "          \"default\" : [ ]" + lineSeparator + "        } ]," + lineSeparator + "        \"x-auth-type\" : \"Application \"," + lineSeparator + "        \"x-throttling-tier\" : \"10KPerMin\"" + lineSeparator + "      }" + lineSeparator + "    }," + lineSeparator + "    \"/list\" : {" + lineSeparator + "      \"get\" : {" + lineSeparator + "        \"parameters\" : [ ]," + lineSeparator + "        \"responses\" : {" + lineSeparator + "          \"200\" : { }" + lineSeparator + "        }," + lineSeparator + "        \"security\" : [ {" + lineSeparator + "          \"default\" : [ ]" + lineSeparator + "        } ]," + lineSeparator + "        \"x-auth-type\" : \"Application \"," + lineSeparator + "        \"x-throttling-tier\" : \"10KPerMin\"" + lineSeparator + "      }" + lineSeparator + "    }" + lineSeparator + "  }";
        this.restAPIPublisher.updateSwagger(this.apiId, swagger);
        String storeDefinition = this.restAPIStore.getSwaggerByID(this.apiId, this.user.getUserDomain());
        boolean isResourceOrderEqual = storeDefinition.contains(resourceOrder);
        Assert.assertTrue((boolean)isResourceOrderEqual, (String)"Resource order is not equal to the given order.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        super.cleanUp();
    }
}

