/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.ApiException;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationListDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM678ApplicationCreationTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIM678ApplicationCreationTestCase.class);
    private String applicationName = "NewApplication1";
    private static final String description = "NewApplicationCreation";
    private static final String appTier = "Unlimited";
    private static Map<String, String> customAttributes = new HashMap<String, String>(){
        {
            this.put("billing_tier", "default_tier");
        }
    };
    private String applicationId;
    protected static final int HTTP_RESPONSE_CODE_OK = Response.Status.OK.getStatusCode();
    private List<String> applicationsList = new ArrayList<String>();

    @Factory(dataProvider="userModeDataProvider")
    public APIM678ApplicationCreationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @DataProvider(name="createApplicationWithValidData")
    public static Object[][] createAppWithValidDataProvider() throws Exception {
        return new Object[][]{{"NewApplication1", appTier, description}, {"NewApplication2", appTier, ""}, {"NewApplication3", appTier, description}, {"NewApplication4", appTier, ""}};
    }

    @DataProvider(name="createApplicationWithInValidData")
    public static Object[][] createAppWithInValidDataProvider() throws Exception {
        return new Object[][]{{"", appTier, ""}, {"NewApplication5", "", description}, {"", "", description}};
    }

    @DataProvider(name="createApplicationWithCustomAttributes")
    public static Object[][] createApplicationWithCustomAttributes() throws Exception {
        return new Object[][]{{"NewApplication6", appTier, description, ApplicationDTO.TokenTypeEnum.JWT, customAttributes}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        this.restAPIStore = new RestAPIStoreImpl(this.storeContext.getContextTenant().getTenantAdmin().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
    }

    @Test(dataProvider="createApplicationWithValidData", description="Create an Application")
    public void testApplicationCreation(String applicationName, String tier, String description) throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication(applicationName, description, appTier, ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response Code is mismatched in add application " + applicationName));
        Assert.assertNotNull((Object)applicationResponse, (String)("Error in Application Creation: " + applicationName));
        this.applicationsList.add(applicationResponse.getData());
    }

    @Test(description="Create already created application", dependsOnMethods={"testApplicationCreation"})
    public void testAlreadyCreatedApplication() throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplication(this.applicationName, description, appTier, ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertNull((Object)applicationResponse, (String)("Create already created application: " + this.applicationName));
    }

    @Test(description="Get all created applications", dependsOnMethods={"testApplicationCreation"})
    public void getAllCreatedApplications() throws Exception {
        ApplicationListDTO applicationListDTO = this.restAPIStore.getAllApps();
        Assert.assertNotNull((Object)applicationListDTO, (String)"Error while get all applications");
    }

    @Test(description="Update an application")
    public void testUpdateApplication() throws Exception {
        String applicationName = "testApplication";
        HttpResponse applicationResponse = this.restAPIStore.createApplication(applicationName, description, appTier, ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response Code is mismatched in add application " + applicationName));
        this.applicationsList.add(applicationResponse.getData());
        String newAppName = "UpdateApplication";
        String newappDescription = "Application updated";
        String newAppTier = "Gold";
        HttpResponse updateTierResponse = this.restAPIStore.updateApplicationByID(applicationResponse.getData(), applicationName, description, newAppTier, ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertTrue((boolean)updateTierResponse.getData().contains(newAppTier), (String)("Error while updating application tier" + applicationName));
        HttpResponse updateNameResponse = this.restAPIStore.updateApplicationByID(applicationResponse.getData(), newAppName, description, appTier, ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertTrue((boolean)updateNameResponse.getData().contains(newAppName), (String)("Error while updating application name" + applicationName));
        HttpResponse updateDesResponse = this.restAPIStore.updateApplicationByID(applicationResponse.getData(), applicationName, newappDescription, newAppTier, ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertTrue((boolean)updateDesResponse.getData().contains(newappDescription), (String)("Error while updating application description" + applicationName));
    }

    @Test(description="Remove application")
    public void testRemoveApplication() throws Exception {
        String applicationName = "RemoveMeApp";
        HttpResponse createApplicationResponse = this.restAPIStore.createApplication(applicationName, description, appTier, ApplicationDTO.TokenTypeEnum.JWT);
        Assert.assertEquals((int)createApplicationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response Code is mismatched in add application " + applicationName));
        ApplicationDTO applicationResponse = this.restAPIStore.getApplicationById(createApplicationResponse.getData());
        HttpResponse deleteApplicationResponse = this.restAPIStore.deleteApplication(new JSONObject((Object)applicationResponse).getString("applicationId"));
        Assert.assertEquals((int)deleteApplicationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response Code is mismatched get application " + applicationName));
        try {
            this.restAPIStore.getApplicationById(createApplicationResponse.getData());
        }
        catch (ApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)404, (String)("Application is not deleted: " + applicationName));
        }
    }

    @Test(dataProvider="createApplicationWithCustomAttributes", description="Create an Application")
    public void testApplicationCreationWithCustomAttributes(String applicationName, String tier, String description, ApplicationDTO.TokenTypeEnum token, Map<String, String> applicationAttributes) throws Exception {
        HttpResponse applicationResponse = this.restAPIStore.createApplicationWithCustomAttribute(applicationName, description, appTier, token, applicationAttributes);
        Assert.assertEquals((int)applicationResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Response Code is mismatched in add application with custom attributes " + applicationName));
        Assert.assertNotNull((Object)applicationResponse, (String)("Error in Application Creation: " + applicationName));
        this.applicationsList.add(applicationResponse.getData());
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.removeAllApps();
    }

    public void removeAllApps() throws Exception {
        for (String appId : this.applicationsList) {
            this.restAPIStore.deleteApplication(appId);
        }
    }
}

