/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentDTO;
import org.wso2.am.integration.clients.publisher.api.v1.dto.DocumentListDTO;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class APIM714GetAllDocumentationTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIM714GetAllDocumentationTestCase.class);
    private APIRequest apiRequest;
    private final String API_END_POINT_POSTFIX_URL = "jaxrs_basic/services/customers/customerservice/";
    private String apiEndPointUrl;
    private String providerName;
    private final String API_DESCRIPTION = "This is test API create by API manager integration test";
    private static final String apiName = "DocumentTestAPI";
    private static final String apiVersion = "1.0.0";
    private APIPublisherRestClient apiPublisherClientUser;
    private static final String apiContext = "documenttestapi";
    String documentId = null;
    String apiId = null;
    DocumentDTO documentDTO = new DocumentDTO();

    @Factory(dataProvider="userModeDataProvider")
    public APIM714GetAllDocumentationTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        log.info((Object)("Test Starting user mode:" + this.userMode));
        this.apiPublisherClientUser = new APIPublisherRestClient(this.publisherURLHttp);
        this.providerName = this.publisherContext.getContextTenant().getContextUser().getUserName();
        this.apiEndPointUrl = this.backEndServerUrl.getWebAppURLHttp() + "jaxrs_basic/services/customers/customerservice/";
        this.apiRequest = new APIRequest(apiName, apiContext, new URL(this.apiEndPointUrl));
        this.apiRequest.setVersion(apiVersion);
        this.apiRequest.setTiersCollection("Unlimited");
        this.apiRequest.setTier("Unlimited");
        this.apiRequest.setProvider(this.providerName);
        this.apiRequest.setDescription("This is test API create by API manager integration test");
        this.apiId = this.createAndPublishAPIUsingRest(this.apiRequest, this.restAPIPublisher, false);
        DocumentDTO.VisibilityEnum docVisibility = DocumentDTO.VisibilityEnum.API_LEVEL;
        DocumentDTO.SourceTypeEnum sourceType = DocumentDTO.SourceTypeEnum.INLINE;
        String summary = "This is a sample documentation";
        String name = "Introduction to PhoneVerification API";
        DocumentDTO.TypeEnum type = DocumentDTO.TypeEnum.HOWTO;
        this.documentDTO.setName(name);
        this.documentDTO.setType(type);
        this.documentDTO.setSourceType(sourceType);
        this.documentDTO.setSummary(summary);
        this.documentDTO.setVisibility(docVisibility);
        HttpResponse documentationResponse = this.restAPIPublisher.addDocument(this.apiId, this.documentDTO);
        Assert.assertEquals((int)documentationResponse.getResponseCode(), (int)200, (String)"Error while add documentation to API");
        this.documentId = documentationResponse.getData();
    }

    @Test(groups={"webapp"}, description="Update Document content")
    public void updateDocumentationContent() throws Exception {
        HttpResponse updateContentResponse = this.restAPIPublisher.addContentDocument(this.apiId, this.documentId, "updated documentation content");
        Assert.assertEquals((int)updateContentResponse.getResponseCode(), (int)200, (String)"Error while update documentation content");
    }

    @Test(groups={"webapp"}, description="Update Document")
    public void updateDocument() throws Exception {
        this.documentDTO.setType(DocumentDTO.TypeEnum.SAMPLES);
        HttpResponse updateDocumentResponse = this.restAPIPublisher.updateDocument(this.apiId, this.documentId, this.documentDTO);
        Assert.assertEquals((int)updateDocumentResponse.getResponseCode(), (int)200, (String)"Error while update the documents");
    }

    @Test(groups={"webapp"}, description="Get All Documents")
    public void testAllDocuments() throws Exception {
        DocumentListDTO documentListDTO = this.restAPIPublisher.getDocuments(this.apiId);
        Assert.assertEquals((int)1, (int)documentListDTO.getList().size(), (String)"Error while getting documentations of API");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        HttpResponse deleteResponse = this.restAPIPublisher.deleteDocument(this.apiId, this.documentId);
        Assert.assertEquals((int)deleteResponse.getResponseCode(), (int)200, (String)"Error while delete the document");
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
    }
}

