/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.xpath.XPathExpressionException;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.SubscriptionListDTO;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;
import org.wso2.carbon.user.mgt.stub.UserAdminUserAdminException;

public class APIMANAGER4373BrokenAPIInStoreTestCase
extends APIManagerLifecycleBaseTest {
    private final String USER_PASSWORD = "123123";
    private final String FIRST_USER = "APIMANAGER4373_user";
    private final String FIRST_ROLE = "APIMANAGER4373_role1";
    private final String SECOND_ROLE = "APIMANAGER4373_role2";
    private final String INTERNAL_SUBSCRIBER = "Internal/subscriber";
    private final String APP_NAME = "APIMANAGER4373";
    private final String BROKEN_API = "brokenAPI";
    private final String HEALTHY_API = "healthyAPI";
    private final String EP_URL = "http://gdata.youtube.com/feeds/api/standardfeeds";
    private final String API_VERSION = "1.0.0";
    private final String RESTRICTED = "restricted";
    private final String TAG_UPDATED = "updated";
    private String contextUsername = "admin";
    private String contextUserPassword = "admin";
    private UserManagementClient userManagementClient1;
    private RestAPIStoreImpl apiStoreSubUser;
    private String publisherURLHttp;
    private String storeURLHttp;
    private String brokenApiId;
    private String healthyApiId;
    private String appId;

    @BeforeClass
    public void init() {
        try {
            super.init();
            this.publisherURLHttp = this.publisherUrls.getWebAppURLHttp();
            this.storeURLHttp = this.storeUrls.getWebAppURLHttp();
            this.contextUsername = this.keyManagerContext.getContextTenant().getContextUser().getUserName();
            this.contextUserPassword = this.keyManagerContext.getContextTenant().getContextUser().getPassword();
            this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.contextUsername, this.contextUserPassword);
            this.userManagementClient1.addRole("APIMANAGER4373_role1", new String[0], new String[0]);
            this.userManagementClient1.addRole("APIMANAGER4373_role2", new String[0], new String[0]);
            this.userManagementClient1.addUser("APIMANAGER4373_user", "123123", new String[]{"Internal/subscriber", "APIMANAGER4373_role1"}, "APIMANAGER4373_user");
            this.apiStoreSubUser = new RestAPIStoreImpl("APIMANAGER4373_user", "123123", this.keyManagerContext.getContextTenant().getDomain(), this.storeURLHttps);
        }
        catch (APIManagerIntegrationTestException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while initializing testcase: " + e.getCause()));
        }
        catch (RemoteException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while adding new users: " + e.getCause()));
        }
        catch (UserAdminUserAdminException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while adding new users: " + e.getCause()));
        }
        catch (XPathExpressionException e) {
            Assert.assertTrue((boolean)false, (String)("Error occurred while retrieving context: " + e.getCause()));
        }
    }

    @Test(groups={"wso2.am"}, description="Test effect of changing the role of subscribed API")
    public void testAPIRoleChangeEffectInStore() throws Exception {
        APIRequest brokenApiRequest = new APIRequest("brokenAPI", "brokenAPI", new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        brokenApiRequest.setVersion("1.0.0");
        brokenApiRequest.setProvider(this.contextUsername);
        brokenApiRequest.setVisibility("restricted");
        brokenApiRequest.setRoles("APIMANAGER4373_role1");
        this.brokenApiId = this.createAndPublishAPIUsingRest(brokenApiRequest, this.restAPIPublisher, false);
        APIRequest healthyApiRequest = new APIRequest("healthyAPI", "healthyAPI", new URL("http://gdata.youtube.com/feeds/api/standardfeeds"));
        healthyApiRequest.setVersion("1.0.0");
        healthyApiRequest.setProvider(this.contextUsername);
        healthyApiRequest.setVisibility("restricted");
        healthyApiRequest.setRoles("APIMANAGER4373_role1");
        this.healthyApiId = this.createAndPublishAPIUsingRest(healthyApiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.contextUsername, "healthyAPI", "1.0.0", "\"isApiExists\":true");
        HttpResponse applicationResponse = this.apiStoreSubUser.createApplication("APIMANAGER4373", "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.appId = applicationResponse.getData();
        HttpResponse subscribeResponse = this.subscribeToAPIUsingRest(this.brokenApiId, this.appId, "Gold", this.apiStoreSubUser);
        Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of API request not successful  API Name:brokenAPI API Version:1.0.0 API Provider Name :" + this.contextUsername));
        subscribeResponse = this.subscribeToAPIUsingRest(this.healthyApiId, this.appId, "Gold", this.apiStoreSubUser);
        Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of API request not successful  API Name:healthyAPI API Version:1.0.0 API Provider Name :" + this.contextUsername));
        brokenApiRequest.setRoles("APIMANAGER4373_role2");
        brokenApiRequest.setTags("updated");
        this.restAPIPublisher.updateAPI(brokenApiRequest, this.brokenApiId);
        this.waitForAPIDeployment();
        SubscriptionListDTO subscriptionListDTO = null;
        try {
            subscriptionListDTO = this.apiStoreSubUser.getAllSubscriptionsOfApplication(this.appId);
            Assert.assertTrue((boolean)subscriptionListDTO.getList().toString().contains("healthyAPI"), (String)"Subscription retrieval failed when one API is broken");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.userManagementClient1.updateRolesOfUser("APIMANAGER4373_user", new String[]{"Internal/subscriber", "APIMANAGER4373_role1", "APIMANAGER4373_role2"});
        SubscriptionListDTO subsDTO = this.apiStoreSubUser.getAllSubscriptionsOfApplication(this.appId);
        for (SubscriptionDTO subscriptionDTO : subsDTO.getList()) {
            this.apiStoreSubUser.removeSubscription(subscriptionDTO.getSubscriptionId());
        }
        this.apiStoreSubUser.deleteApplication(this.appId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.brokenApiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.healthyApiId, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.brokenApiId);
        this.restAPIPublisher.deleteAPI(this.healthyApiId);
        if (this.userManagementClient1 != null) {
            this.userManagementClient1.deleteUser("APIMANAGER4373_user");
            this.userManagementClient1.deleteRole("APIMANAGER4373_role1");
            this.userManagementClient1.deleteRole("APIMANAGER4373_role2");
        }
    }
}

