/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.json.JSONException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.admin.clients.mediation.SynapseConfigAdminClient;
import org.wso2.am.integration.test.utils.APIManagerIntegrationTestException;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APILifeCycleState;
import org.wso2.am.integration.test.utils.bean.APILifeCycleStateRequest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.bean.APPKeyRequestGenerator;
import org.wso2.am.integration.test.utils.bean.SubscriptionRequest;
import org.wso2.am.integration.test.utils.clients.APIPublisherRestClient;
import org.wso2.am.integration.test.utils.clients.APIStoreRestClient;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.common.TestConfigurationProvider;

public class APIMANAGER4533BackendReturningStatusCode200TestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER4533BackendReturningStatusCode200TestCase.class);
    private APIPublisherRestClient apiPublisher;
    private APIStoreRestClient apiStore;
    private String newSynapseConfig;
    private SynapseConfigAdminClient synapseConfigAdminClient;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER4533BackendReturningStatusCode200TestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER}, {TestUserMode.TENANT_USER}};
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        String gatewaySessionCookie = this.createSession(this.gatewayContextWrk);
        this.apiPublisher = new APIPublisherRestClient(this.publisherUrls.getWebAppURLHttp());
        this.apiStore = new APIStoreRestClient(this.storeUrls.getWebAppURLHttp());
        this.synapseConfigAdminClient = new SynapseConfigAdminClient(this.gatewayContextWrk.getContextUrls().getBackEndUrl(), gatewaySessionCookie);
        String synapseConfigArtifactsPath = TestConfigurationProvider.getResourceLocation() + File.separator + "artifacts" + File.separator + "AM" + File.separator + "synapseconfigs" + File.separator + "rest" + File.separator + "dummy_api_APIMANAGER-4533.xml";
        this.newSynapseConfig = this.readFile(synapseConfigArtifactsPath);
        this.synapseConfigAdminClient.updateConfiguration(this.newSynapseConfig);
    }

    @Test(groups={"wso2.am"}, description="Send a request to a backend returning 200 and check if the expected result is received")
    public void testAPIReturningStatusCode200() {
        try {
            this.apiPublisher.login(this.publisherContext.getContextTenant().getContextUser().getUserName(), this.publisherContext.getContextTenant().getContextUser().getPassword());
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()));
            Assert.assertTrue((boolean)false);
        }
        catch (XPathExpressionException e) {
            log.error((Object)("XPathExpressionException " + e.getMessage()));
            Assert.assertTrue((boolean)false);
        }
        String apiName = "Test200_API" + this.userMode;
        String apiVersion = "1.0.0";
        String apiContext = "test200_api" + this.userMode;
        String endpointUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "response200";
        APIRequest apiRequest = null;
        try {
            apiRequest = new APIRequest(apiName, apiContext, new URL(endpointUrl));
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("Error creating APIRequest " + e.getMessage()));
            Assert.assertTrue((boolean)false);
        }
        catch (MalformedURLException e) {
            log.error((Object)("Invalid URL " + this.gatewayUrlsWrk.getWebAppURLNhttp() + "response200"), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        apiRequest.setVersion(apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setResourceMethod("GET");
        try {
            apiRequest.setProvider(this.publisherContext.getContextTenant().getContextUser().getUserName());
            this.apiPublisher.addAPI(apiRequest);
            APILifeCycleStateRequest updateRequest = new APILifeCycleStateRequest(apiName, this.publisherContext.getContextTenant().getContextUser().getUserName(), APILifeCycleState.PUBLISHED);
            this.apiPublisher.changeAPILifeCycleStatus(updateRequest);
            this.apiStore.login(this.storeContext.getContextTenant().getContextUser().getUserName(), this.storeContext.getContextTenant().getContextUser().getPassword());
            this.apiStore.addApplication("APP200", "Unlimited", "", "");
            SubscriptionRequest subscriptionRequest = new SubscriptionRequest(apiName, apiVersion, this.storeContext.getContextTenant().getContextUser().getUserName(), "APP200", "Unlimited");
            this.apiStore.subscribe(subscriptionRequest);
            APPKeyRequestGenerator generateAppKeyRequest = new APPKeyRequestGenerator("APP200");
            String responseString = this.apiStore.generateApplicationKey(generateAppKeyRequest).getData();
            JSONObject response = new JSONObject(responseString);
            String accessToken = response.getJSONObject("data").getJSONObject("key").getString("accessToken");
            String apiInvocationUrl = this.userMode == TestUserMode.TENANT_ADMIN || this.userMode == TestUserMode.TENANT_USER ? this.gatewayUrlsWrk.getWebAppURLNhttps() + "t/wso2.com/" + apiContext + "/" + apiVersion : this.gatewayUrlsWrk.getWebAppURLNhttps() + apiContext + "/" + apiVersion;
            DefaultHttpClient httpclient = new DefaultHttpClient();
            HttpGet get = new HttpGet(apiInvocationUrl);
            get.addHeader((Header)new BasicHeader("Authorization", "Bearer " + accessToken));
            get.addHeader((Header)new BasicHeader("Accept", "application/json"));
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)get);
            Assert.assertEquals((int)httpResponse.getStatusLine().getStatusCode(), (int)200, (String)"Status Code is not 200");
        }
        catch (APIManagerIntegrationTestException e) {
            log.error((Object)("APIManagerIntegrationTestException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (JSONException e) {
            log.error((Object)("Error parsing JSON to get access token " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (XPathExpressionException e) {
            log.error((Object)("XPathExpressionException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
        catch (IOException e) {
            log.error((Object)("IOException " + e.getMessage()), (Throwable)e);
            Assert.assertTrue((boolean)false);
        }
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        super.cleanUp();
    }

    protected String readFile(String fileLocation) throws APIManagerIntegrationTestException {
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(new File(fileLocation)));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
            String string = stringBuilder.toString();
            return string;
        }
        catch (IOException ioE) {
            throw new APIManagerIntegrationTestException("IOException when reading the file from:" + fileLocation, (Throwable)ioE);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error when closing the buffer reade which used to reed the file:" + fileLocation + ". Error:" + e.getMessage()));
                }
            }
        }
    }
}

