/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.util.HashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.test.utils.base.APIMIntegrationBaseTest;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.test.utils.http.HTTPSClientUtils;
import org.wso2.carbon.automation.engine.annotations.ExecutionEnvironment;
import org.wso2.carbon.automation.engine.annotations.SetEnvironment;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

@SetEnvironment(executionEnvironments={ExecutionEnvironment.STANDALONE})
public class APIMANAGER5843WSDLHostnameTestCase
extends APIMIntegrationBaseTest {
    private static final Log log = LogFactory.getLog(APIMANAGER5843WSDLHostnameTestCase.class);
    private String apiName = "APIMANAGER5843";
    private String apiContext = "apimanager5843";
    private String apiVersion = "1.0.0";
    private String backendEndWSDL;
    private String backendEndUrl;
    private String apiId;

    @Factory(dataProvider="userModeDataProvider")
    public APIMANAGER5843WSDLHostnameTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        if (TestUserMode.SUPER_TENANT_ADMIN == this.userMode) {
            super.init();
        }
        this.backendEndWSDL = this.getGatewayURLNhttp() + "services/echo?wsdl";
        this.backendEndUrl = this.getGatewayURLNhttp() + "services/echo";
    }

    @Test(groups={"wso2.am"}, description="API creation with wsdl")
    public void testAPICreationWithWSDL() throws Exception {
        APIRequest apiRequest = new APIRequest(this.apiName, this.apiContext, new URL(this.backendEndUrl));
        apiRequest.setVersion(this.apiVersion);
        apiRequest.setTiersCollection("Unlimited");
        apiRequest.setTier("Unlimited");
        apiRequest.setWsdl(this.backendEndWSDL);
        apiRequest.setProvider(this.user.getUserName());
        HttpResponse apiResponse = this.restAPIPublisher.addAPI(apiRequest);
        this.apiId = apiResponse.getData();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Authorization", "Basic " + new String(Base64.encodeBase64((byte[])(this.user.getUserName() + ':' + this.user.getPassword()).getBytes())));
        String username = this.user.getUserNameWithoutDomain();
        if (TestUserMode.TENANT_ADMIN == this.userMode) {
            username = this.user.getUserNameWithoutDomain() + "-AT-" + this.user.getUserDomain();
        }
        String wsdl = HTTPSClientUtils.doGet((String)(this.getGatewayMgtURLHttps() + "registry/resourceContent?path=/_system/governance/apimgt/applicationdata/wsdls/" + username + "--APIMANAGER58431.0.0.wsdl"), map).getData();
        Assert.assertFalse((boolean)wsdl.contains("null/"), (String)"WSDL has 'null' as service hostname.");
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIPublisher.deleteAPI(this.apiId);
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}};
    }
}

