/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.am.integration.tests.other;

import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Factory;
import org.testng.annotations.Test;
import org.wso2.am.integration.clients.publisher.api.v1.dto.APIDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyDTO;
import org.wso2.am.integration.clients.store.api.v1.dto.ApplicationKeyGenerateRequestDTO;
import org.wso2.am.integration.test.impl.RestAPIPublisherImpl;
import org.wso2.am.integration.test.impl.RestAPIStoreImpl;
import org.wso2.am.integration.test.utils.bean.APICreationRequestBean;
import org.wso2.am.integration.test.utils.bean.APIRequest;
import org.wso2.am.integration.tests.api.lifecycle.APIManagerLifecycleBaseTest;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.carbon.integration.common.admin.client.UserManagementClient;

public class APIScopeTestCase
extends APIManagerLifecycleBaseTest {
    private static final Log log = LogFactory.getLog(APIScopeTestCase.class);
    private UserManagementClient userManagementClient1 = null;
    private static final String API_NAME = "APIScopeTestAPI";
    private static final String API_VERSION = "1.0.0";
    private static final String APP_NAME = "NewApplication";
    private String USER_SMITH = "smith";
    private String ADMIN_ROLE = "admin";
    private static final String SUBSCRIBER_ROLE = "subscriber";
    private final String INTERNAL_ROLE_SUBSCRIBER = "Internal/subscriber";
    private final String API_VERSION_WITH_SCOPE = "1.0.0";
    private final String API_VERSION_WITH_SCOPE_COPY = "2.0.0";
    private final String API_NAME_WITH_SCOPE = "APIScopeTestWithScopeName";
    private final String API_CONTEXT_WITH_SCOPE = "APIScopeTestWithScopeContext";
    private final String SCOPE_NAME = "APIScopeUpdateCopyScope";
    private final String ALLOWED_ROLE = "admin";
    private final String[] ADMIN_PERMISSIONS = new String[]{"/permission/admin/login", "/permission/admin/manage", "/permission/admin/configure", "/permission/admin/monitor"};
    private final String[] NEW_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "admin"};
    private final String[] OLD_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone", "role1"};
    private final String[] SEC_OLD_ROLE_LIST = new String[]{"Internal/publisher", "Internal/creator", "Internal/subscriber", "Internal/everyone"};
    private String apiId;
    private String apiIdWithScope;
    private String copyApiId;
    private String applicationId;
    private ArrayList<String> grantTypes;

    @Factory(dataProvider="userModeDataProvider")
    public APIScopeTestCase(TestUserMode userMode) {
        this.userMode = userMode;
    }

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init(this.userMode);
        this.grantTypes = new ArrayList();
    }

    @Test(groups={"wso2.am"}, description="Testing the scopes with admin, subscriber roles")
    public void testSetScopeToResourceTestCase() throws Exception {
        String userSmith;
        String gatewayUrl;
        this.userManagementClient1 = new UserManagementClient(this.keyManagerContext.getContextUrls().getBackEndUrl(), this.keyManagerContext.getContextTenant().getTenantAdmin().getUserName(), this.keyManagerContext.getContextTenant().getTenantAdmin().getPassword());
        if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
            this.USER_SMITH = "secondary/" + this.USER_SMITH;
            this.ADMIN_ROLE = "secondary/" + this.ADMIN_ROLE;
            this.userManagementClient1.addRole(this.ADMIN_ROLE, new String[]{this.user.getUserNameWithoutDomain()}, this.ADMIN_PERMISSIONS);
        }
        if (TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.NEW_ROLE_LIST);
        }
        if (this.keyManagerContext.getContextTenant().getDomain().equals("carbon.super")) {
            gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp();
            userSmith = this.USER_SMITH;
        } else {
            gatewayUrl = this.gatewayUrlsWrk.getWebAppURLNhttp() + "t/" + this.keyManagerContext.getContextTenant().getDomain() + "/";
            userSmith = this.USER_SMITH + "@" + this.keyManagerContext.getContextTenant().getDomain();
        }
        this.userManagementClient1.addUser(this.USER_SMITH, "john123", new String[]{"Internal/subscriber"}, this.USER_SMITH);
        this.restAPIPublisher = new RestAPIPublisherImpl(this.publisherContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.publisherContext.getContextTenant().getContextUser().getPassword(), this.publisherContext.getContextTenant().getDomain(), this.publisherURLHttps);
        this.restAPIStore = new RestAPIStoreImpl(this.storeContext.getContextTenant().getContextUser().getUserNameWithoutDomain(), this.storeContext.getContextTenant().getContextUser().getPassword(), this.storeContext.getContextTenant().getDomain(), this.storeURLHttps);
        String apiContext = "testScopeAPI";
        String tags = "thomas-bayer, testing, rest-Apis";
        String url = this.getGatewayURLNhttp() + "response";
        String description = "This is a test API created by API manager integration test";
        APIRequest apiRequest = new APIRequest(API_NAME, apiContext, new URL(url));
        apiRequest.setTags(tags);
        apiRequest.setDescription(description);
        apiRequest.setVersion(API_VERSION);
        apiRequest.setProvider(this.user.getUserName());
        this.apiId = this.createAndPublishAPIUsingRest(apiRequest, this.restAPIPublisher, false);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
        String modifiedResource = "{\"paths\":{ \"/*\":{\"put\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\" },\"post\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"admin_scope\"},\"get\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\",\"x-scope\":\"user_scope\"},\"delete\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"Application User\",\"x-throttling-tier\":\"Unlimited\"},\"options\":{ \"responses\":{\"200\":{}},\"x-auth-type\":\"None\",\"x-throttling-tier\":\"Unlimited\"}}},\"swagger\":\"2.0\",\"info\":{\"title\":\"APIScopeTestAPI\",\"version\":\"1.0.0\"},\"x-wso2-security\":{\"apim\":{\"x-wso2-scopes\":[{\"name\":\"admin_scope\",\"description\":\"\",\"key\":\"admin_scope\",\"roles\":\"" + this.ADMIN_ROLE + "\"},{\"name\":\"user_scope\",\"description\":\"\",\"key\":\"user_scope\",\"roles\":\"" + this.ADMIN_ROLE + ",Internal/subscriber\"}]}}}";
        this.restAPIPublisher.updateSwagger(this.apiId, modifiedResource);
        this.createAPIRevisionAndDeployUsingRest(this.apiId, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), API_NAME, API_VERSION, "\"isApiExists\":true");
        HttpResponse applicationResponse = this.restAPIStore.createApplication(APP_NAME, "Test Application", "Unlimited", ApplicationDTO.TokenTypeEnum.JWT);
        this.applicationId = applicationResponse.getData();
        String provider = this.user.getUserName();
        HttpResponse subscribeResponse = this.subscribeToAPIUsingRest(this.apiId, this.applicationId, "Gold", this.restAPIStore);
        Assert.assertEquals((int)subscribeResponse.getResponseCode(), (int)HTTP_RESPONSE_CODE_OK, (String)("Subscribe of old API version request not successful  API Name:APIScopeTestAPI API Version:1.0.0 API Provider Name :" + provider));
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("admin_scope");
        scopes.add("user_scope");
        this.grantTypes.add("password");
        this.grantTypes.add("client_credentials");
        ApplicationKeyDTO applicationKeyDTO = this.restAPIStore.generateKeys(this.applicationId, "36000", "", ApplicationKeyGenerateRequestDTO.KeyTypeEnum.PRODUCTION, scopes, this.grantTypes);
        String consumerKey = applicationKeyDTO.getConsumerKey();
        String consumerSecret = applicationKeyDTO.getConsumerSecret();
        URL tokenEndpointURL = new URL(this.keyManagerHTTPSURL + "oauth2/token");
        String requestBody = "grant_type=password&username=" + this.user.getUserName() + "&password=" + this.user.getPassword() + "&scope=admin_scope user_scope";
        HttpResponse response = this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL);
        JSONObject accessTokenGenerationResponse = new JSONObject(response.getData());
        String accessToken = accessTokenGenerationResponse.getString("access_token");
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Admin user cannot access the GET Method");
        URL endPointURL = new URL(gatewayUrl + "testScopeAPI/1.0.0/test");
        response = HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"Admin user cannot access the POST Method");
        requestBody = "grant_type=password&username=" + userSmith + "&password=john123&scope=admin_scope user_scope";
        accessTokenGenerationResponse = new JSONObject(this.restAPIStore.generateUserAccessKey(consumerKey, consumerSecret, requestBody, tokenEndpointURL).getData());
        accessToken = accessTokenGenerationResponse.getString("access_token");
        requestHeaders = new HashMap();
        requestHeaders.put("Authorization", "Bearer " + accessToken);
        response = HttpRequestUtil.doGet((String)(gatewayUrl + "testScopeAPI/1.0.0/test"), requestHeaders);
        Assert.assertEquals((int)response.getResponseCode(), (int)Response.Status.OK.getStatusCode(), (String)"User John cannot access the GET Method");
        try {
            endPointURL = new URL(gatewayUrl + "testScopeAPI/1.0.0/test");
            response = HttpRequestUtil.doPost((URL)endPointURL, (String)"", requestHeaders);
            Assert.assertTrue((response.getResponseCode() != Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)"testRole John can access the POST Method");
        }
        catch (Exception e) {
            log.error((Object)"user john cannot access the resources (expected behaviour)");
            Assert.assertTrue((boolean)true, (String)"user john cannot access the resources");
        }
    }

    @Test(groups={"wso2.am"}, description="Testing Copy api with scopes assigned", dependsOnMethods={"testSetScopeToResourceTestCase"})
    public void testCopyApiWithScopes() throws Exception {
        String tierCollection = "Unlimited";
        String endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api";
        APICreationRequestBean apiCreationRequestBean = new APICreationRequestBean("APIScopeTestWithScopeName", "APIScopeTestWithScopeContext", API_VERSION, this.user.getUserName(), new URL(endpointUrl));
        apiCreationRequestBean.setTiersCollection(tierCollection);
        String swagger = "{\"paths\": {\"/add\": {\"get\": {\"x-auth-type\": \"" + URLEncoder.encode("Application & Application User", "UTF-8") + "\",\"x-throttling-tier\": \"" + "Unlimited" + "\",\"x-scope\": \"" + "APIScopeUpdateCopyScope" + "\",\"responses\": {\"200\": {}},\"parameters\": [{\"name\": \"x\",\"paramType\": \"query\",\"required\": false,\"type\": \"string\",\"description\": \"First value\",\"in\": \"query\"}, {\"name\": \"y\",\"paramType\": \"query\",\"required\": false,\"type\": \"string\",\"description\": \"Second Value\",\"in\": \"query\"}]}}},\"swagger\": \"2.0\",\"x-wso2-security\": {\"apim\": {\"x-wso2-scopes\": [{\"description\": \"Sample Scope\",\"name\": \"" + "APIScopeUpdateCopyScope" + "\",\"roles\": \"" + "admin" + "\",\"key\": \"" + "APIScopeUpdateCopyScope" + "\"}]}},\"info\": {\"title\": \"" + "APIScopeTestWithScopeName" + "\",\"" + API_VERSION + "\": \"1.0.0\"}}";
        apiCreationRequestBean.setSwagger(swagger);
        APIDTO apiDto = this.createAndPublishAPI(apiCreationRequestBean, this.restAPIPublisher, false);
        this.apiIdWithScope = apiDto.getId();
        this.restAPIPublisher.updateSwagger(this.apiIdWithScope, swagger);
        this.createAPIRevisionAndDeployUsingRest(this.apiIdWithScope, this.restAPIPublisher);
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIScopeTestWithScopeName", API_VERSION, "\"isApiExists\":false");
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIScopeTestWithScopeName", API_VERSION, "\"isApiExists\":true");
        HttpResponse newVersionResponse = this.restAPIPublisher.copyAPI("2.0.0", this.apiIdWithScope, null);
        Assert.assertEquals((int)newVersionResponse.getResponseCode(), (int)200, (String)"Response Code Mismatch");
        this.copyApiId = newVersionResponse.getData();
        this.waitForAPIDeploymentSync(this.user.getUserName(), "APIScopeTestWithScopeName", "2.0.0", "\"isApiExists\":true");
    }

    @Test(groups={"wso2.am"}, description="Testing Update api with scopes assigned", dependsOnMethods={"testCopyApiWithScopes"})
    public void testUpdateApiWithScopes() throws Exception {
        String tierCollection = "Gold";
        String endpointUrl = this.backEndServerUrl.getWebAppURLHttp() + "am/sample/calculator/v1/api/add";
        APIRequest apiRequest = new APIRequest("APIScopeTestWithScopeName", "APIScopeTestWithScopeContext", new URL(endpointUrl));
        apiRequest.setTiersCollection(tierCollection);
        apiRequest.setVersion(API_VERSION);
        apiRequest.setDescription("test api description");
        HttpResponse updateResponse = this.restAPIPublisher.updateAPI(apiRequest, this.apiIdWithScope);
        Assert.assertEquals((int)updateResponse.getResponseCode(), (int)200, (String)"Response Code Mismatch");
        this.createAPIRevisionAndDeployUsingRest(this.apiIdWithScope, this.restAPIPublisher);
    }

    @AfterClass(alwaysRun=true)
    public void destroy() throws Exception {
        this.restAPIStore.deleteApplication(this.applicationId);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiId, this.restAPIPublisher);
        this.undeployAndDeleteAPIRevisionsUsingRest(this.apiIdWithScope, this.restAPIPublisher);
        this.restAPIPublisher.deleteAPI(this.apiId);
        this.restAPIPublisher.deleteAPI(this.apiIdWithScope);
        this.restAPIPublisher.deleteAPI(this.copyApiId);
        if (TestUserMode.SUPER_TENANT_EMAIL_USER.equals((Object)this.userMode) || TestUserMode.TENANT_EMAIL_USER.equals((Object)this.userMode)) {
            this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.OLD_ROLE_LIST);
        }
        if (this.userManagementClient1 != null) {
            if (TestUserMode.SUPER_TENANT_USER_STORE_USER.equals((Object)this.userMode)) {
                this.userManagementClient1.updateRolesOfUser(this.user.getUserNameWithoutDomain(), this.SEC_OLD_ROLE_LIST);
            }
            this.userManagementClient1.deleteUser(this.USER_SMITH);
        }
        super.cleanUp();
    }

    @DataProvider
    public static Object[][] userModeDataProvider() {
        return new Object[][]{{TestUserMode.SUPER_TENANT_ADMIN}, {TestUserMode.TENANT_ADMIN}, {TestUserMode.SUPER_TENANT_USER_STORE_USER}, {TestUserMode.SUPER_TENANT_EMAIL_USER}, {TestUserMode.TENANT_EMAIL_USER}};
    }
}

